/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: AppClientModuleInfo.java 21566 2011-08-08 12:28:12Z cazauxj $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ear.internal;

public class AppClientModuleInfo {
    private String moduleName = null;
    private String fileName = null;
    private String deploymentDesc = null;
    private String jonasDeploymentDesc = null;

    public AppClientModuleInfo(final String moduleName, final String fileName, final String deploymentDesc, final String jonasDeploymentDesc) {
        this.moduleName = moduleName;
        this.fileName = fileName;
        this.deploymentDesc = deploymentDesc;
        this.jonasDeploymentDesc = jonasDeploymentDesc;
    }

    public String getDeploymentDesc() {
        return deploymentDesc;
    }

    public String getFileName() {
        return fileName;
    }

    public String getJonasDeploymentDesc() {
        return jonasDeploymentDesc;
    }

    public String getModuleName() {
        return moduleName;
    }

}