/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s): Florent BENOIT & Ludovic BERT
 * --------------------------------------------------------------------------
 * $Id: JOnASEARServiceMBean.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ear.internal;

import java.util.List;
import java.util.Set;

/**
 * JOnAS EAR Service MBean interface. This interface provides a description for
 * the EAR service management.
 * @author Florent Benoit
 * @author Ludovic Bert
 */

public interface JOnASEARServiceMBean {

    /**
     * @return current number of ears deployed in the JOnAS server
     */
    Integer getCurrentNumberOfEars();

    /**
     * Return the list of installed Applications. The EAR files or the
     * directories with expanded Applications are searched in JONAS_BASE/apps
     * and all Applications directories 'autoload'.
     * @return The list of EAR files or the directories with expanded
     *         Applications found
     * @throws Exception if the list can't be retrieved
     */
    List getInstalledEars() throws Exception;

    /**
     * This method is added temporarily. It will disapear when Ears will have
     * their associated MBeans (when Ears will become manageable)
     * @return the names of the ears currently deployed in the JOnAS server
     */
    Set getEarNames();

    /**
     * Test if the specified filename is already deployed or not
     * @param fileName the name of the ear file.
     * @return true if the ear is deployed, else false.
     */
    boolean isEarLoaded(String fileName);

    /**
     * Return the list of all loaded Applications.
     * @return The list of deployed Applications
     */
    List getDeployedEars();

    /**
     * Return the list of installed Applications ready to deploy.
     * @return The list of deployable Applications
     * @throws Exception if the list of deployable ears can't be returned
     */
    List getDeployableEars() throws Exception;

    /**
     * Return the list of "autoload" directories for web applications.
     * @return The list of all "autoload" directories
     */
    List getAutoloadDirectories();

    /**
     * Return the Apps directory.
     * @return The Apps directory
     */
    String getAppsDirectory();

}