/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDesc;
import org.ow2.jonas.deployment.client.ClientContainerDeploymentDescException;
import org.ow2.jonas.deployment.client.wrapper.ClientManagerWrapper;
import org.ow2.jonas.deployment.ear.EarDeploymentDesc;
import org.ow2.jonas.deployment.ear.EarDeploymentDescException;
import org.ow2.jonas.deployment.ear.wrapper.EarManagerWrapper;
import org.ow2.jonas.deployment.ear.xml.Web;
import org.ow2.jonas.deployment.ejb.wrapper.EjbManagerWrapper;
import org.ow2.jonas.deployment.web.wrapper.WebManagerWrapper;
import org.ow2.jonas.ear.EarService;
import org.ow2.jonas.ear.EarServiceException;
import org.ow2.jonas.ear.internal.AppClientModuleInfo;
import org.ow2.jonas.ear.internal.EarCleanTask;
import org.ow2.jonas.ear.internal.EarDeployer;
import org.ow2.jonas.ear.internal.JOnASEARServiceMBean;
import org.ow2.jonas.ear.internal.mbean.AppClientModule;
import org.ow2.jonas.ear.internal.mbean.Ear;
import org.ow2.jonas.ejb.EJBService;
import org.ow2.jonas.ejb.easybeans.IEasyBeansService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;
import org.ow2.jonas.lib.cpmanager.EarClassPathManager;
import org.ow2.jonas.lib.cpmanager.EarClassPathManagerException;
import org.ow2.jonas.lib.cpmanager.JarList;
import org.ow2.jonas.lib.cpmanager.JarListException;
import org.ow2.jonas.lib.loader.ClientClassLoader;
import org.ow2.jonas.lib.loader.EjbJarClassLoader;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.security.mapping.JPolicyUserRoleMapping;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.lib.work.AbsCleanTask;
import org.ow2.jonas.lib.work.CleanerException;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.lib.work.EarFileManager;
import org.ow2.jonas.lib.work.FileManagerException;
import org.ow2.jonas.lib.work.WorkCleaner;
import org.ow2.jonas.lib.wsgen.CheckerException;
import org.ow2.jonas.lib.wsgen.WsGenChecker;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.resource.ResourceServiceException;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.ws.WSServiceException;
import org.ow2.jonas.ws.WebServicesService;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.archive.ArchiveManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.url.URLUtils;

public class JOnASEARService
extends AbsServiceImpl
implements EarService,
JOnASEARServiceMBean {
    protected static final String JONAS_BASE = JProp.getJonasBase();
    protected static final String APPS_DIR = JONAS_BASE + File.separator + "apps";
    protected static final String WORK_DIR = JProp.getWorkDir();
    protected static final String WORK_APPS_DIR = WORK_DIR + File.separator + "apps";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ear");
    private static WorkCleaner workCleaner = null;
    private JmxService jmxService = null;
    private List earNames = new Vector();
    private EJBService ejbService = null;
    private JWebContainerService webContainerService = null;
    private WebServicesService wsService = null;
    private ResourceService resourceService = null;
    private IEasyBeansService easyBeansService = null;
    private Hashtable ears = null;
    private ArrayList autoloadDirectories = new ArrayList();
    private DeployerLog earDeployerLog = null;
    private ClassLoader appsClassLoader;
    private EarDeployer earDeployer = null;
    private IDeployerManager deployerManager;

    public JOnASEARService() {
        this.ears = new Hashtable();
        this.earDeployer = new EarDeployer();
    }

    public void setParsingwithvalidation(boolean validate) {
        EarManagerWrapper.setParsingWithValidation((boolean)validate);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            if (!validate) {
                logger.log(BasicLevel.DEBUG, (Object)"EAR XML parsing without validation");
            } else {
                logger.log(BasicLevel.DEBUG, (Object)"EAR XML parsing with validation");
            }
        }
    }

    public void setDescriptors(String descriptors) {
        this.earNames = JOnASEARService.convertToList((String)descriptors);
    }

    public void setAutoloaddir(String directoriesValue) {
        List directories = JOnASEARService.convertToList((String)directoriesValue);
        for (String directory : directories) {
            this.addEars(directory);
            File oFile = new File(APPS_DIR, directory);
            if (!oFile.exists()) {
                oFile = new File(directory);
            }
            if (!oFile.exists()) continue;
            try {
                this.autoloadDirectories.add(oFile.getCanonicalPath());
            }
            catch (IOException e) {
                String err = "Error when trying to verify Application EAR autoload directory : " + directory;
                logger.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            }
        }
    }

    public void checkRequirements() throws ServiceException {
        if (this.jmxService == null) {
            this.throwRequirementException("Missing reference on " + JmxService.class);
        }
    }

    protected void doStop() throws ServiceException {
        URL earFileName = null;
        Enumeration earEntries = this.ears.keys();
        while (earEntries.hasMoreElements()) {
            earFileName = (URL)earEntries.nextElement();
            try {
                ComponentContext ctx = new ComponentContext(earFileName.getFile());
                ctx.rebind("filename", (Object)earFileName);
                this.unDeployEar((Context)ctx);
            }
            catch (Exception e) {
                String err = "Error when undeploying the ear :" + earFileName;
                logger.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            }
        }
        if (this.deployerManager != null) {
            this.deployerManager.unregister((IDeployer)this.earDeployer);
        }
        if (this.jmxService != null) {
            this.unregisterEarServiceMBean(this.getDomainName());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"EarService stopped");
        }
    }

    public String deployEar(Context ctx) throws EarServiceException {
        ComponentContext contctx;
        String err;
        EjbJarClassLoader ejbClassLoader;
        IDeployable deployable;
        File f;
        String fileName;
        block115: {
            if (this.webContainerService == null && this.ejbService == null) {
                throw new EarServiceException("The ear service requires that at least the service ejb or web is launched for deploying an ear file.");
            }
            try {
                fileName = (String)ctx.lookup("filename");
            }
            catch (NamingException e) {
                throw new EarServiceException("Error during performing lookup a fileName", (Throwable)e);
            }
            f = null;
            try {
                f = new File(fileName).getCanonicalFile();
                if (f.exists()) break block115;
                boolean found = false;
                String earFileName = null;
                if (fileName.toLowerCase().endsWith(".ear")) {
                    earFileName = APPS_DIR + File.separator + fileName;
                    f = new File(earFileName).getCanonicalFile();
                    found = f.exists();
                }
                if (found) {
                    fileName = earFileName;
                    break block115;
                }
                String err2 = "deployEar: The file " + fileName + " was not found neither in the current directory nor in the " + APPS_DIR + " directory";
                logger.log(BasicLevel.ERROR, (Object)err2);
                throw new EarServiceException(err2);
            }
            catch (IOException e) {
                String err3 = "Error when trying to get the canonical file from " + fileName;
                logger.log(BasicLevel.ERROR, (Object)(err3 + " " + e.getMessage()));
                throw new EarServiceException(err3, (Throwable)e);
            }
        }
        try {
            ObjectName j2eeServer = J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName());
            WsGenChecker wsgc = new WsGenChecker(fileName, j2eeServer, this.jmxService.getJmxServer());
            wsgc.checkWsGen(this.getDomainName());
        }
        catch (CheckerException e) {
            throw new EarServiceException("Cannot apply WsGen on the ear : " + fileName, (Throwable)e);
        }
        catch (Exception ue) {
            throw new EarServiceException("Cannot apply WsGen on the ear (unexpected exception) : " + fileName, (Throwable)ue);
        }
        URL[] earUrl = new URL[1];
        URL earRootUrl = null;
        try {
            earUrl[0] = f.toURL();
            earRootUrl = new File(WORK_APPS_DIR + File.separator + this.getJonasServerName()).toURL();
        }
        catch (MalformedURLException e) {
            String err4 = "Invalid ear file name '" + fileName;
            logger.log(BasicLevel.ERROR, (Object)(err4 + "': " + e.getMessage()));
            throw new EarServiceException(err4, (Throwable)e);
        }
        if (this.ears.get(earUrl[0]) != null) {
            String err5 = "The ear file : " + f.getName() + " is already deployed ('" + earUrl[0].getFile() + "'). You must undeploy the application " + "before a new deployment.";
            logger.log(BasicLevel.ERROR, (Object)err5);
            throw new EarServiceException(err5);
        }
        URLClassLoader loaderCls = new URLClassLoader(earUrl, this.appsClassLoader);
        EarDeploymentDesc earDD = null;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Getting the deployment descriptor of the file" + f.getName()));
        }
        File earFile = URLUtils.urlToFile((URL)earUrl[0]);
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)earFile);
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
        }
        catch (DeployableHelperException e) {
            throw new EarServiceException("Cannot get a deployable for the archive '" + archive + "'", (Throwable)e);
        }
        EARDeployable earDeployable = null;
        if (!(deployable instanceof EARDeployable)) {
            throw new EarServiceException("The Deployable '" + deployable + "' is not an EAR Deployable");
        }
        earDeployable = (EARDeployable)deployable;
        try {
            earDD = EarManagerWrapper.getDeploymentDesc((EARDeployable)earDeployable, (ClassLoader)loaderCls);
        }
        catch (EarDeploymentDescException e) {
            String err6 = "Error in the Deployment descriptor '" + fileName + "': " + (Object)((Object)e);
            logger.log(BasicLevel.ERROR, (Object)err6);
            throw new EarServiceException(err6, (Throwable)e);
        }
        Web[] webs = earDD.getWebTags();
        String[] webTags = new String[webs.length];
        String[] ejbTags = earDD.getEjbTags();
        String[] connectorTags = earDD.getConnectorTags();
        String[] clientTags = earDD.getClientTags();
        String[] altDDClients = earDD.getAltDDClients();
        String[] altDDEjbs = earDD.getAltDDEjbs();
        String[] altDDWebs = earDD.getAltDDWebs();
        String[] altDDConnectors = earDD.getAltDDConnectors();
        String[] securityRoles = earDD.getSecurityRolesNames();
        File fEar = new File(earUrl[0].getFile());
        File tmpFile = null;
        try {
            int i;
            File fCanonicEar = fEar.getCanonicalFile();
            for (i = 0; i < ejbTags.length; ++i) {
                tmpFile = new File(fEar, ejbTags[i]);
                if ((tmpFile = tmpFile.getCanonicalFile()).getPath().startsWith(fCanonicEar.getPath())) continue;
                String err7 = "Error : The ejb-jar file " + ejbTags[i] + " is not inside the ear file " + fEar;
                logger.log(BasicLevel.ERROR, (Object)err7);
                throw new EarServiceException(err7);
            }
            for (i = 0; i < webs.length; ++i) {
                tmpFile = new File(fEar, webs[i].getWebUri());
                if (!(tmpFile = tmpFile.getCanonicalFile()).getPath().startsWith(fCanonicEar.getPath())) {
                    String err8 = "Error : The war file " + webs[i].getWebUri() + " is not inside the ear file " + fEar;
                    logger.log(BasicLevel.ERROR, (Object)err8);
                    throw new EarServiceException(err8);
                }
                webTags[i] = webs[i].getWebUri();
            }
            for (i = 0; i < connectorTags.length; ++i) {
                tmpFile = new File(fEar, connectorTags[i]);
                if ((tmpFile = tmpFile.getCanonicalFile()).getPath().startsWith(fCanonicEar.getPath())) continue;
                String err9 = "Error : The rar file " + connectorTags[i] + " is not inside the ear file " + fEar;
                logger.log(BasicLevel.ERROR, (Object)err9);
                throw new EarServiceException(err9);
            }
            for (i = 0; i < clientTags.length; ++i) {
                tmpFile = new File(fEar, clientTags[i]);
                if ((tmpFile = tmpFile.getCanonicalFile()).getPath().startsWith(fCanonicEar.getPath())) continue;
                String err10 = "Error : The client jar file " + clientTags[i] + " is not inside the ear file " + fEar;
                throw new EarServiceException(err10);
            }
        }
        catch (IOException ioe) {
            String err11 = "Error while trying to get the canonical file of " + tmpFile;
            logger.log(BasicLevel.ERROR, (Object)(err11 + " : " + ioe.getMessage()));
            throw new EarServiceException(err11, (Throwable)ioe);
        }
        JarList ejbsList = new JarList(ejbTags);
        JarList warsList = new JarList(webTags);
        JarList connectorsList = new JarList(connectorTags);
        JarList clientsList = new JarList(clientTags);
        URL dirUnpackURL = null;
        try {
            dirUnpackURL = EarFileManager.unpackEar((URL)earUrl[0], (URL)earRootUrl);
        }
        catch (FileManagerException e) {
            String err12 = "Error while unpacking the file '" + earUrl[0] + "'";
            logger.log(BasicLevel.ERROR, (Object)(err12 + " : " + e.getMessage()));
            throw new EarServiceException(err12, (Throwable)e);
        }
        if (new File(earUrl[0].getFile()).isFile()) {
            try {
                this.earDeployerLog.addEntry(new File(earUrl[0].getFile()), new File(dirUnpackURL.getFile()));
            }
            catch (DeployerLogException e) {
                String err13 = "Error while adding the " + earUrl[0] + " entry in the log file";
                logger.log(BasicLevel.ERROR, (Object)(err13 + " : " + e.getMessage()));
                throw new EarServiceException(err13, (Throwable)e);
            }
        }
        EarClassPathManager earCPManager = null;
        try {
            earCPManager = new EarClassPathManager(ejbsList, warsList, dirUnpackURL);
        }
        catch (EarClassPathManagerException e) {
            String err14 = "Error while creating the Ear class path manager of the ear : '" + earUrl[0] + "'";
            logger.log(BasicLevel.ERROR, (Object)(err14 + " : " + e.getMessage()));
            throw new EarServiceException(err14, (Throwable)e);
        }
        URL[] classpathURLs = null;
        try {
            classpathURLs = earCPManager.getResolvedClassPath();
        }
        catch (EarClassPathManagerException e) {
            String err15 = "Error while trying to resolve the classpath of the ejbjars and wars of the ear : '" + earUrl[0] + "'";
            logger.log(BasicLevel.ERROR, (Object)(err15 + " : " + e.getMessage()));
            throw new EarServiceException(err15, (Throwable)e);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Creating the EAR classLoader");
        }
        JClassLoader earClassLoader = new JClassLoader(earUrl[0].toExternalForm(), new URL[0], this.appsClassLoader);
        URL[] jarUrls = null;
        URL[] warUrls = null;
        URL[] connectorUrls = null;
        URL[] clientUrls = null;
        try {
            jarUrls = ejbsList.getURLs(dirUnpackURL.toExternalForm());
            warUrls = warsList.getURLs(dirUnpackURL.toExternalForm());
            connectorUrls = connectorsList.getURLs(dirUnpackURL.toExternalForm());
            clientUrls = clientsList.getURLs(dirUnpackURL.toExternalForm());
        }
        catch (JarListException e) {
            String err16 = "Error while geting the Urls from jarlist of the ear : '" + earUrl[0] + "'";
            logger.log(BasicLevel.ERROR, (Object)(err16 + " : " + e.getMessage()));
            throw new EarServiceException(err16, (Throwable)e);
        }
        String[] warsContextRoots = new String[webs.length];
        String ctxRoot = null;
        for (int i = 0; i < webs.length; ++i) {
            ctxRoot = webs[i].getContextRoot();
            if (ctxRoot == null) continue;
            warsContextRoots[i] = ctxRoot;
        }
        String altdd = null;
        File fAltDD = null;
        URL[] warsAltDDs = new URL[altDDWebs.length];
        for (int i = 0; i < altDDWebs.length; ++i) {
            if (altDDWebs[i] == null || (altdd = altDDWebs[i]) == null) continue;
            try {
                fAltDD = new File(new URL(dirUnpackURL.toExternalForm() + File.separator + altdd).getFile());
                warsAltDDs[i] = fAltDD.getCanonicalFile().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                String err17 = "Can't build URL for alt-dd '" + altdd;
                logger.log(BasicLevel.ERROR, (Object)(err17 + "': " + e.getMessage()));
                throw new EarServiceException(err17, (Throwable)e);
            }
            catch (IOException ioe) {
                String err18 = "Can't get canonicalFile() for the file '" + fAltDD;
                logger.log(BasicLevel.ERROR, (Object)(err18 + "': " + ioe.getMessage()));
                throw new EarServiceException(err18, (Throwable)ioe);
            }
        }
        URL[] ejbsAltDDs = new URL[altDDEjbs.length];
        for (int i = 0; i < altDDEjbs.length; ++i) {
            if (altDDEjbs[i] == null || (altdd = altDDEjbs[i]) == null) continue;
            try {
                fAltDD = new File(new URL(dirUnpackURL.toExternalForm() + File.separator + altdd).getFile());
                ejbsAltDDs[i] = fAltDD.getCanonicalFile().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                String err19 = "Can't build URL for alt-dd '" + altdd;
                logger.log(BasicLevel.ERROR, (Object)(err19 + "': " + e.getMessage()));
                throw new EarServiceException(err19, (Throwable)e);
            }
            catch (IOException ioe) {
                String err20 = "Can't get canonicalFile() for the file '" + fAltDD;
                logger.log(BasicLevel.ERROR, (Object)(err20 + "': " + ioe.getMessage()));
                throw new EarServiceException(err20, (Throwable)ioe);
            }
        }
        URL[] connectorsAltDDs = new URL[altDDConnectors.length];
        for (int i = 0; i < altDDConnectors.length; ++i) {
            if (altDDConnectors[i] == null || (altdd = altDDConnectors[i]) == null) continue;
            try {
                fAltDD = new File(new URL(dirUnpackURL.toExternalForm() + File.separator + altdd).getFile());
                connectorsAltDDs[i] = fAltDD.getCanonicalFile().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                String err21 = "Can't build URL for alt-dd '" + altdd;
                logger.log(BasicLevel.ERROR, (Object)(err21 + "': " + e.getMessage()));
                throw new EarServiceException(err21, (Throwable)e);
            }
            catch (IOException ioe) {
                String err22 = "Can't get canonicalFile() for the file '" + fAltDD;
                logger.log(BasicLevel.ERROR, (Object)(err22 + "': " + ioe.getMessage()));
                throw new EarServiceException(err22, (Throwable)ioe);
            }
        }
        URL[] clientAltDDs = new URL[altDDClients.length];
        for (int i = 0; i < altDDClients.length; ++i) {
            if (altDDClients[i] == null || (altdd = altDDClients[i]) == null) continue;
            try {
                fAltDD = new File(new URL(dirUnpackURL.toExternalForm() + File.separator + altdd).getFile());
                clientAltDDs[i] = fAltDD.getCanonicalFile().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                String err23 = "Can't build URL for alt-dd '" + altdd;
                logger.log(BasicLevel.ERROR, (Object)(err23 + "': " + e.getMessage()));
                throw new EarServiceException(err23, (Throwable)e);
            }
            catch (IOException ioe) {
                String err24 = "Can't get canonicalFile() for the file '" + fAltDD;
                logger.log(BasicLevel.ERROR, (Object)(err24 + "': " + ioe.getMessage()));
                throw new EarServiceException(err24, (Throwable)ioe);
            }
        }
        String[] roleNames = new String[securityRoles.length];
        String affRoleNames = "";
        for (int i = 0; i < securityRoles.length; ++i) {
            roleNames[i] = securityRoles[i];
            affRoleNames = affRoleNames + roleNames[i] + ";";
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("role names = " + affRoleNames));
        }
        EjbManagerWrapper.setAvailableEjbJarsAndAltDDs((URLClassLoader)earClassLoader, (URL[])jarUrls, (URL[])ejbsAltDDs);
        WebManagerWrapper.setAltDD((URLClassLoader)earClassLoader, (URL[])warUrls, (URL[])warsAltDDs);
        ClientManagerWrapper.setAltDD((URLClassLoader)earClassLoader, (URL[])clientUrls, (URL[])clientAltDDs);
        URL[] urls = new URL[jarUrls.length + classpathURLs.length];
        System.arraycopy(jarUrls, 0, urls, 0, jarUrls.length);
        System.arraycopy(classpathURLs, 0, urls, jarUrls.length, classpathURLs.length);
        if (this.resourceService != null && connectorUrls.length > 0) {
            try {
                ComponentContext contctx2 = null;
                try {
                    contctx2 = new ComponentContext(dirUnpackURL.getFile());
                    contctx2.rebind("earUrl", (Object)earUrl[0]);
                    contctx2.rebind("urls", (Object)connectorUrls);
                    contctx2.rebind("earClassLoader", (Object)earClassLoader);
                    contctx2.rebind("altDDs", (Object)connectorsAltDDs);
                }
                catch (NamingException e) {
                    String err25 = "Can not bind params for the resource service, Can't deploy rars ";
                    throw new ResourceServiceException(err25, (Throwable)e);
                }
                this.resourceService.deployRars((Context)contctx2);
            }
            catch (ServiceException e) {
                String err26 = "Error during the deployment of the rars files of the Ear file " + fileName;
                logger.log(BasicLevel.ERROR, (Object)(err26 + "': " + e.getMessage()));
                throw new EarServiceException(err26, (Throwable)e);
            }
        }
        if (jarUrls.length > 0 && this.ejbService != null) {
            URL[] compilationURLs = null;
            if (this.resourceService != null) {
                URL[] myApplicationJars = earClassLoader.getURLs();
                URL[] appsJars = ((URLClassLoader)earClassLoader.getParent()).getURLs();
                compilationURLs = new URL[myApplicationJars.length + appsJars.length + urls.length];
                System.arraycopy(urls, 0, compilationURLs, 0, urls.length);
                System.arraycopy(appsJars, 0, compilationURLs, urls.length, appsJars.length);
                System.arraycopy(myApplicationJars, 0, compilationURLs, urls.length + appsJars.length, myApplicationJars.length);
            }
            for (int i = 0; i < jarUrls.length; ++i) {
                this.ejbService.checkGenIC(jarUrls[i].getFile(), compilationURLs);
            }
        }
        try {
            ejbClassLoader = new EjbJarClassLoader(urls, (ClassLoader)earClassLoader);
        }
        catch (IOException ioe) {
            err = "Cannot Create EJB ClassLoader for EAR '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + " : " + ioe.getMessage()));
            throw new EarServiceException(err, (Throwable)ioe);
        }
        if (this.wsService != null) {
            try {
                Hashtable<URL, String> ctxRoots = new Hashtable<URL, String>();
                for (int w = 0; w < webs.length; ++w) {
                    ctxRoots.put(warUrls[w], webs[w].getContextRoot());
                }
                contctx = null;
                try {
                    contctx = new ComponentContext(dirUnpackURL.getFile());
                    contctx.rebind("unpackDir", (Object)dirUnpackURL.toExternalForm());
                    contctx.rebind("jarUrls", (Object)jarUrls);
                    contctx.rebind("warUrls", (Object)warUrls);
                    contctx.rebind("earURL", (Object)earUrl[0]);
                    contctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
                    contctx.rebind("earClassLoader", (Object)earClassLoader);
                    contctx.rebind("warCtxRootMapping", ctxRoots);
                }
                catch (NamingException e) {
                    String err27 = "Cannot bind params for the WebServices service, Can't deploy Web Services Endpoints ";
                    throw new WSServiceException(err27, (Throwable)e);
                }
                this.wsService.deployWebServices((Context)contctx);
            }
            catch (ServiceException se) {
                err = "Error during the deployment of the WebServices of the Ear file " + fileName;
                logger.log(BasicLevel.ERROR, (Object)(err + " : " + se.getMessage()));
                this.wsService.removeCache((ClassLoader)earClassLoader);
                try {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("Undeploying Rars of the ear " + fileName));
                    }
                    if (this.resourceService != null && connectorUrls.length > 0) {
                        this.resourceService.unDeployRars(connectorUrls, earUrl[0]);
                    }
                }
                catch (ServiceException se2) {
                    err = "Error during the undeployment of the rars files of the Ear file " + fileName;
                    logger.log(BasicLevel.ERROR, (Object)(err + "': " + se2.getMessage()));
                }
                throw new EarServiceException(err, (Throwable)se);
            }
        }
        if (this.ejbService != null && jarUrls.length > 0) {
            try {
                ComponentContext contctx3 = null;
                try {
                    contctx3 = new ComponentContext(dirUnpackURL.getFile());
                    contctx3.rebind("earRootUrl", (Object)dirUnpackURL);
                    contctx3.rebind("earUrl", (Object)earUrl[0]);
                    contctx3.rebind("jarURLs", (Object)jarUrls);
                    contctx3.rebind("earClassLoader", (Object)earClassLoader);
                    contctx3.rebind("ejbClassLoader", (Object)ejbClassLoader);
                    contctx3.rebind("roleNames", (Object)roleNames);
                }
                catch (NamingException e) {
                    String err28 = "Can not bind params for the ejb service, Can't deploy jars ";
                    throw new EarServiceException(err28, (Throwable)e);
                }
                this.ejbService.deployJars((Context)contctx3);
            }
            catch (ServiceException e) {
                err = "Error during the deployment of the jars files of the Ear file " + fileName;
                logger.log(BasicLevel.ERROR, (Object)(err + "': " + e.getMessage()));
                this.ejbService.removeCache((ClassLoader)earClassLoader);
                if (this.resourceService != null && connectorUrls.length > 0) {
                    this.resourceService.unDeployRars(connectorUrls, earUrl[0]);
                }
                throw new EarServiceException(err, (Throwable)e);
            }
        }
        this.linkPolicyObjects(earDD.getUserToRoleMapping(), jarUrls, warUrls, warsContextRoots);
        this.commitEJBPolicyObjects(jarUrls);
        EjbJarClassLoader parentWarClassLoader = ejbClassLoader;
        if (this.webContainerService != null && warUrls.length > 0) {
            try {
                contctx = null;
                try {
                    contctx = new ComponentContext(dirUnpackURL.getFile());
                    contctx.rebind("earURL", (Object)earUrl[0]);
                    contctx.rebind("urls", (Object)warUrls);
                    contctx.rebind("parentClassLoader", (Object)parentWarClassLoader);
                    contctx.rebind("earClassLoader", (Object)earClassLoader);
                    contctx.rebind("altDDs", (Object)warsAltDDs);
                    contctx.rebind("contextRoots", (Object)warsContextRoots);
                }
                catch (NamingException e) {
                    String err29 = "Can not bind params for the web container service, Can't deploy wars ";
                    throw new EarServiceException(err29, (Throwable)e);
                }
                this.webContainerService.deployWars((Context)contctx);
            }
            catch (JWebContainerServiceException e) {
                String err30 = "Error during the deployment of the wars file of the Ear file " + fileName;
                logger.log(BasicLevel.ERROR, (Object)(err30 + "': " + e.getMessage()));
                this.webContainerService.removeCache((ClassLoader)earClassLoader);
                err30 = "Undeploy the jars loaded from this ear";
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)err30);
                }
                try {
                    if (this.ejbService != null && jarUrls.length > 0) {
                        this.ejbService.removeCache((ClassLoader)earClassLoader);
                        this.ejbService.unDeployJars(jarUrls);
                    }
                    if (this.resourceService != null && connectorUrls.length > 0) {
                        this.resourceService.unDeployRars(connectorUrls, earUrl[0]);
                    }
                }
                catch (ServiceException se) {
                    err30 = "Error during the undeployment of the jars file of the Ear file " + fileName;
                    logger.log(BasicLevel.ERROR, (Object)(err30 + "': " + se.getMessage()));
                    throw new EarServiceException(err30, (Throwable)e);
                }
                throw new EarServiceException(err30, (Throwable)e);
            }
        }
        this.commitWebBPolicyObjects(warUrls, warsContextRoots);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("We store the rars/wars/jars associated to the url :" + earUrl[0]));
        }
        if (this.wsService != null) {
            try {
                contctx = null;
                try {
                    contctx = new ComponentContext(earRootUrl.getFile());
                    contctx.rebind("classloader", (Object)earClassLoader);
                    ObjectName name = J2eeObjectName.J2EEApplication((String)this.getDomainName(), (String)this.getJonasServerName(), (String)ModuleNamingUtils.fromURL((URL)earUrl[0]));
                    contctx.rebind("parentObjectName", (Object)name);
                    contctx.rebind("isInEar", (Object)Boolean.TRUE);
                }
                catch (NamingException e) {
                    String err31 = "Can not bind params for the WebServices service, can't complete deployment of Web Services Endpoints";
                    throw new JWebContainerServiceException(err31, (Throwable)e);
                }
                this.wsService.completeWSDeployment((Context)contctx);
            }
            catch (ServiceException se) {
                String err32 = "Error during the deployment of the WebServices of the Ear file '" + earRootUrl + "'";
                logger.log(BasicLevel.ERROR, (Object)(err32 + " : " + se.getMessage()));
                try {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"Undeploy the WebApps loaded from this ear");
                    }
                    if (this.webContainerService != null && warUrls.length > 0) {
                        this.webContainerService.removeCache((ClassLoader)earClassLoader);
                        this.webContainerService.unDeployWars(warUrls);
                    }
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"Undeploy the EjbJars loaded from this ear");
                    }
                    if (this.ejbService != null && jarUrls.length > 0) {
                        this.ejbService.removeCache((ClassLoader)earClassLoader);
                        this.ejbService.unDeployJars(jarUrls);
                    }
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"Undeploy the Resources loaded from this ear");
                    }
                    if (this.resourceService != null && connectorUrls.length > 0) {
                        this.resourceService.unDeployRars(connectorUrls, earUrl[0]);
                    }
                }
                catch (ServiceException se2) {
                    err32 = "Error during the undeployment of the webapps/ejbjars/rars file of the Ear file " + fileName;
                    logger.log(BasicLevel.ERROR, (Object)(err32 + "': " + se2.getMessage()));
                }
                throw new JWebContainerServiceException(err32, (Throwable)se);
            }
        }
        File dirUnpackFile = new File(dirUnpackURL.getFile());
        dirUnpackFile.setLastModified(new Date().getTime());
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String j2eeApplicationName = ModuleNamingUtils.fromURL((URL)earUrl[0]);
        AppClientModuleInfo[] appClientModules = new AppClientModuleInfo[clientUrls.length];
        for (int i = 0; i < clientUrls.length; ++i) {
            URL clientUrl = clientUrls[i];
            String moduleName = ModuleNamingUtils.fromURL((URL)clientUrl);
            String moduleFileName = clientUrl.getPath();
            String moduleDD = null;
            String jonasModuleDD = null;
            EjbJarClassLoader moduleCL = null;
            try {
                moduleCL = new ClientClassLoader(clientUrl, (ClassLoader)ejbClassLoader);
            }
            catch (IOException ioe) {
                moduleCL = ejbClassLoader;
            }
            try {
                ClientContainerDeploymentDesc clientContainerDD = ClientManagerWrapper.getDeploymentDesc((URL)clientUrl, (ClassLoader)moduleCL, (ClassLoader)earClassLoader);
                moduleDD = clientContainerDD.getXmlContent();
                jonasModuleDD = clientContainerDD.getJOnASXmlContent();
            }
            catch (ClientContainerDeploymentDescException e) {
                String err33 = "Cannot read the deployment descriptors ': " + clientUrls[i] + "'" + e.toString();
                logger.log(BasicLevel.WARN, (Object)err33, (Throwable)e);
            }
            appClientModules[i] = new AppClientModuleInfo(moduleName, moduleFileName, moduleDD, jonasModuleDD);
        }
        this.registerAppClientModuleMBeans(domainName, serverName, j2eeApplicationName, appClientModules);
        String unpackDir = dirUnpackURL.getFile();
        String ddXmlContent = earDD.getXmlContent();
        Ear ear = this.registerJ2EEApplicationModule(domainName, serverName, j2eeApplicationName, unpackDir, earUrl[0], ddXmlContent, jarUrls, warUrls, connectorUrls);
        this.ears.put(earUrl[0], ear);
        if (this.ejbService != null) {
            this.ejbService.removeCache((ClassLoader)earClassLoader);
        }
        if (this.webContainerService != null) {
            this.webContainerService.removeCache((ClassLoader)earClassLoader);
        }
        if (this.wsService != null) {
            this.wsService.removeCache((ClassLoader)earClassLoader);
        }
        logger.log(BasicLevel.INFO, (Object)("Ear " + earUrl[0] + " available."));
        return J2eeObjectName.J2EEApplicationName((String)domainName, (String)serverName, (String)j2eeApplicationName);
    }

    public String deployEar(String fileName) throws Exception {
        ComponentContext ctx = null;
        String mbeanOn = null;
        try {
            ctx = new ComponentContext(fileName);
            ctx.rebind("filename", (Object)fileName);
        }
        catch (NamingException e) {
            String err = "Error when deploying the ear file ";
            logger.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            throw e;
        }
        try {
            mbeanOn = this.deployEar((Context)ctx);
        }
        catch (ServiceException e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot deploy file '" + fileName + "'"));
            throw new Exception("Cannot deploy file '" + fileName + "'", e);
        }
        return mbeanOn;
    }

    protected void doStart() throws ServiceException {
        if (this.easyBeansService != null) {
            this.earDeployer.setEmbedded(this.easyBeansService.getEasyBeansServer());
        }
        try {
            LoaderManager lm = LoaderManager.getInstance();
            this.appsClassLoader = lm.getAppsLoader();
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot get the Applications ClassLoader from EAR Container Service: " + e));
            throw new ServiceException("Cannot get the Applications ClassLoader from EAR Container Service", (Throwable)e);
        }
        if (this.jmxService != null) {
            this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        }
        URL earApps = null;
        try {
            earApps = new File(WORK_APPS_DIR + File.separator + this.getJonasServerName()).toURL();
        }
        catch (MalformedURLException mue) {
            throw new ServiceException("Error when trying to get the URL of the jonasroot/apps directory", (Throwable)mue);
        }
        File fLog = new File(earApps.getFile() + File.separator + this.getJonasServerName() + ".log");
        if (!fLog.exists()) {
            try {
                fLog.getParentFile().mkdirs();
                fLog.createNewFile();
            }
            catch (IOException e) {
                throw new ServiceException("cannot create the log file" + fLog, (Throwable)e);
            }
        }
        try {
            this.earDeployerLog = new DeployerLog(fLog);
        }
        catch (DeployerLogException e) {
            throw new ServiceException("Can not get an EarDeployerLog", (Throwable)e);
        }
        EarCleanTask earCleanTask = new EarCleanTask(this, earApps, this.earDeployerLog);
        workCleaner = WorkCleaner.getInstance();
        try {
            workCleaner.registerTask((AbsCleanTask)earCleanTask);
        }
        catch (CleanerException ce) {
            throw new ServiceException("Cannot register the EAR clean task", (Throwable)ce);
        }
        workCleaner.executeTasks();
        this.earDeployer.setAppsClassLoader(this.appsClassLoader);
        this.earDeployer.setJMXService(this.jmxService);
        this.deployerManager.register((IDeployer)this.earDeployer);
        for (String fileName : this.earNames) {
            String err;
            ComponentContext contctx = null;
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("filename", (Object)fileName);
            }
            catch (NamingException e) {
                throw new ServiceException("Cannot start the EarService", (Throwable)e);
            }
            try {
                this.deployEar((Context)contctx);
            }
            catch (EarServiceException ese) {
                err = "Cannot deploy the file '" + fileName + "' : " + ese.getMessage();
                logger.log(BasicLevel.WARN, (Object)err, (Throwable)ese);
            }
            catch (Exception ue) {
                err = "Cannot deploy the file (unexpected exception) '" + fileName + "' : " + ue.getMessage();
                logger.log(BasicLevel.WARN, (Object)err, (Throwable)ue);
            }
        }
        this.registerEarServiceMBean(this, this.getDomainName());
    }

    public void unDeployEar(Context ctx) throws EarServiceException {
        URL earUrl = null;
        try {
            earUrl = (URL)ctx.lookup("filename");
        }
        catch (NamingException e) {
            throw new EarServiceException("Trying to remove the ear file but there is no filename specified", (Throwable)e);
        }
        Ear ear = (Ear)((Object)this.ears.get(earUrl));
        if (ear == null) {
            throw new EarServiceException("Trying to remove the ear file " + earUrl.getFile() + " but this file was not found in the loaded Ear files");
        }
        URL[] warsToUndeploy = ear.getWars();
        if (this.webContainerService != null && warsToUndeploy.length > 0) {
            this.webContainerService.unDeployWars(warsToUndeploy);
        }
        URL[] jarsToUndeploy = ear.getEjbJars();
        if (this.ejbService != null && jarsToUndeploy.length > 0) {
            this.ejbService.unDeployJars(jarsToUndeploy);
        }
        URL[] rarsToUndeploy = ear.getRars();
        if (this.resourceService != null && rarsToUndeploy.length > 0) {
            this.resourceService.unDeployRars(rarsToUndeploy, earUrl);
        }
        File f = new File(earUrl.getFile());
        this.ears.remove(earUrl);
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String j2eeappName = ear.getName();
        this.unregisterJ2EEApplicationModule(domainName, serverName, j2eeappName);
        this.unregisterAppClientModuleMBeans(domainName, serverName, j2eeappName);
        logger.log(BasicLevel.INFO, (Object)("Ear " + f.getName() + " no longer available."));
    }

    public void unDeployEar(String fileName) throws Exception {
        URL url = null;
        URL earUrl = null;
        boolean found = false;
        try {
            Enumeration e = this.ears.keys();
            url = new File(fileName).getCanonicalFile().toURL();
            while (e.hasMoreElements() && !found) {
                earUrl = (URL)e.nextElement();
                if (!earUrl.equals(url)) continue;
                found = true;
            }
            if (fileName.toLowerCase().endsWith(".ear") && !found) {
                String earFileName = APPS_DIR + File.separator + fileName;
                e = this.ears.keys();
                url = new File(earFileName).getCanonicalFile().toURL();
                while (e.hasMoreElements() && !found) {
                    earUrl = (URL)e.nextElement();
                    if (!earUrl.equals(url)) continue;
                    found = true;
                }
            }
            if (!found) {
                String err = "Cannot undeploy the ear '" + fileName + "', it is not deployed.";
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new Exception(err);
            }
        }
        catch (MalformedURLException mue) {
            String err = "Error when trying to get the url from" + fileName;
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new Exception(err, mue);
        }
        catch (IOException ioe) {
            String err = "Error when trying to get the canonical file from " + fileName;
            logger.log(BasicLevel.ERROR, (Object)(err + ioe.getMessage()));
            throw new Exception(err, ioe);
        }
        ComponentContext ctx = null;
        try {
            ctx = new ComponentContext(fileName);
            ctx.rebind("filename", (Object)url);
        }
        catch (NamingException e) {
            String err = "Error when binding parameters";
            logger.log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new Exception(err, e);
        }
        try {
            this.unDeployEar((Context)ctx);
        }
        catch (EarServiceException e) {
            throw new Exception(e);
        }
    }

    public Integer getCurrentNumberOfEars() {
        return new Integer(this.ears.size());
    }

    public List getInstalledEars() throws Exception {
        ArrayList al = JModule.getInstalledContainersInDir((String)APPS_DIR, (String)"ear", (String)"META-INF", (String)"application.xml");
        for (String name : this.autoloadDirectories) {
            al.addAll(JModule.getInstalledContainersInDir((String)name, (String)"ear", (String)"META-INF", (String)"application.xml"));
        }
        return al;
    }

    public Set getEarNames() {
        HashSet<String> names = new HashSet<String>();
        URL earUrl = null;
        Enumeration e = this.ears.keys();
        while (e.hasMoreElements()) {
            earUrl = (URL)e.nextElement();
            names.add(earUrl.getFile());
        }
        return names;
    }

    private void addEars(String dirPath) {
        boolean found = false;
        File dir = new File(APPS_DIR + File.separator + dirPath);
        found = dir.isDirectory();
        if (found) {
            this.addEarsFrom(dir);
        } else {
            String err = "Warning: Cannot load dir: '" + dirPath + "' ";
            err = err + "is not a directory or directory doesn't exist";
            logger.log(BasicLevel.WARN, (Object)err);
        }
    }

    private void addEarsFrom(File dir) throws EarServiceException {
        block5: {
            try {
                if (dir.isDirectory()) {
                    File[] files = dir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].getPath().toLowerCase().endsWith(".ear")) {
                            this.earNames.add(files[i].getCanonicalPath());
                            continue;
                        }
                        if (!files[i].isDirectory()) continue;
                        this.addEarsFrom(files[i]);
                    }
                    break block5;
                }
                String err = "Cannot load dir: '" + dir.getPath();
                err = err + "' is not a directory";
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new EarServiceException(err);
            }
            catch (IOException e) {
                String err = "Invalid file name '" + dir.getPath();
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new EarServiceException(err, (Throwable)e);
            }
        }
    }

    public boolean isEarLoaded(String fileName) {
        URL url = null;
        boolean isLoaded = false;
        try {
            try {
                url = new File(fileName).getCanonicalFile().toURL();
                if (this.ears.get(url) != null) {
                    isLoaded = true;
                } else {
                    url = null;
                }
            }
            catch (Exception e) {
                url = null;
            }
            if (url == null && this.ears.get(url = new File(APPS_DIR + File.separator + fileName).getCanonicalFile().toURL()) != null) {
                isLoaded = true;
            }
        }
        catch (Exception e) {
            String err = "Can not found if the ear is deployed or not";
            logger.log(BasicLevel.ERROR, (Object)err);
            return false;
        }
        return isLoaded;
    }

    public Boolean isEarDeployed(String fileName) {
        return new Boolean(this.isEarLoaded(fileName));
    }

    public boolean isEarDeployedByUnpackName(String unpackName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("entering for unpackName= " + unpackName));
        }
        Enumeration lc = this.ears.elements();
        while (lc.hasMoreElements()) {
            Ear ear = (Ear)((Object)lc.nextElement());
            String deployedUnpackName = new File(ear.getUnpackName()).getName();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("deployedUnpackName=" + deployedUnpackName));
            }
            if (!deployedUnpackName.equals(unpackName)) continue;
            return true;
        }
        return false;
    }

    public List getDeployedEars() {
        ArrayList<String> al = new ArrayList<String>();
        Enumeration enumEars = this.ears.elements();
        while (enumEars.hasMoreElements()) {
            Ear oEar = (Ear)((Object)enumEars.nextElement());
            URL oURL = oEar.getEarUrl();
            al.add(oURL.getFile());
        }
        return al;
    }

    public List getDeployableEars() throws Exception {
        List al = this.getInstalledEars();
        al.removeAll(this.getDeployedEars());
        return al;
    }

    public List getAutoloadDirectories() {
        ArrayList<String> al = new ArrayList<String>();
        for (String fileName : this.autoloadDirectories) {
            try {
                al.add(new File(fileName).toURL().getPath());
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Can't get autoload directories : " + e.getMessage()));
            }
        }
        return al;
    }

    public String getAppsDirectory() {
        String sRet = null;
        try {
            sRet = new File(APPS_DIR).toURL().getPath();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get the APPS directory", e);
        }
        return sRet;
    }

    private PolicyConfigurationFactory getPolicyConfigurationFactory() {
        PolicyConfigurationFactory pcFactory = null;
        try {
            pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (Exception cnfe) {
            String err = "Cannot retrieve current policy configuration factory";
            logger.log(BasicLevel.ERROR, (Object)(err + "': " + cnfe.getMessage()));
            throw new EarServiceException(err, (Throwable)cnfe);
        }
        return pcFactory;
    }

    private void addEjbContextIdToList(URL[] jarUrls, List contextIDs) {
        if (this.ejbService != null) {
            for (int u = 0; u < jarUrls.length; ++u) {
                contextIDs.add(this.ejbService.getContainerContextID(jarUrls[u].getFile()));
            }
        }
    }

    private void addWebBContextIdToList(URL[] warUrls, String[] contextRoots, List contextIDs, boolean resetPolicyConfiguration) throws EarServiceException {
        if (warUrls != null) {
            for (int u = 0; u < warUrls.length; ++u) {
                String ctxId = warUrls[u].getFile() + contextRoots[u];
                if (resetPolicyConfiguration) {
                    try {
                        this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId, true);
                    }
                    catch (PolicyContextException pce) {
                        String err = "Cannot retrieve a policy configuration";
                        logger.log(BasicLevel.ERROR, (Object)(err + "': " + pce.getMessage()));
                        throw new EarServiceException(err, (Throwable)pce);
                    }
                }
                contextIDs.add(ctxId);
            }
        }
    }

    private void linkPolicyObjects(Map userToRoleMapping, URL[] jarUrls, URL[] warUrls, String[] contextRoots) throws EarServiceException {
        LinkedList ctxIDs = new LinkedList();
        this.addEjbContextIdToList(jarUrls, ctxIDs);
        this.addWebBContextIdToList(warUrls, contextRoots, ctxIDs, true);
        try {
            for (String toBeLinkedCtxId : ctxIDs) {
                PolicyConfiguration toBeLinkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(toBeLinkedCtxId, false);
                for (String linkedCtxId : ctxIDs) {
                    if (toBeLinkedCtxId.equals(linkedCtxId)) continue;
                    PolicyConfiguration linkedPC = this.getPolicyConfigurationFactory().getPolicyConfiguration(linkedCtxId, false);
                    toBeLinkedPC.linkConfiguration(linkedPC);
                }
            }
        }
        catch (PolicyContextException pce) {
            String err = "Cannot retrieve a policy configuration";
            logger.log(BasicLevel.ERROR, (Object)(err + "': " + pce.getMessage()));
            throw new EarServiceException(err, (Throwable)pce);
        }
        if (userToRoleMapping != null) {
            for (String contextId : ctxIDs) {
                for (String principalName : userToRoleMapping.keySet()) {
                    List roles = (List)userToRoleMapping.get(principalName);
                    String[] roleNames = roles.toArray(new String[roles.size()]);
                    JPolicyUserRoleMapping.addUserToRoleMapping((String)contextId, (String)principalName, (String[])roleNames);
                }
            }
        }
    }

    private void commitEJBPolicyObjects(URL[] jarUrls) {
        LinkedList ctxIDs = new LinkedList();
        this.addEjbContextIdToList(jarUrls, ctxIDs);
        this.commitPolicyObjects(ctxIDs);
    }

    private void commitWebBPolicyObjects(URL[] warUrls, String[] contextRoots) {
        LinkedList ctxIDs = new LinkedList();
        this.addWebBContextIdToList(warUrls, contextRoots, ctxIDs, false);
        this.commitPolicyObjects(ctxIDs);
    }

    private void commitPolicyObjects(List ctxIDs) {
        String ctxId2 = null;
        try {
            for (String ctxId2 : ctxIDs) {
                PolicyConfiguration pc = this.getPolicyConfigurationFactory().getPolicyConfiguration(ctxId2, false);
                pc.commit();
            }
        }
        catch (PolicyContextException pce) {
            String err = "Cannot commit policy configuration with Id '" + ctxId2 + "'";
            logger.log(BasicLevel.ERROR, (Object)(err + "': " + pce.getMessage()));
            throw new EarServiceException(err, (Throwable)pce);
        }
        Policy.getPolicy().refresh();
    }

    private void registerEarServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.earService((String)domainName);
        this.jmxService.registerMBean(service, on);
    }

    private void unregisterEarServiceMBean(String domainName) {
        ObjectName on = JonasObjectName.earService((String)domainName);
        this.jmxService.unregisterMBean(on);
    }

    private void registerAppClientModuleMBean(String domainName, String serverName, String j2eeappName, String moduleName, String moduleFileName, String moduleDD, String moduleJonasDD) {
        String mbeanName = J2eeObjectName.getAppClientModuleName((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
        AppClientModule mbean = new AppClientModule(mbeanName, moduleFileName, moduleDD, moduleJonasDD);
        try {
            this.jmxService.registerModelMBean((Object)mbean, mbeanName);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register AppClientModule MBean " + moduleName), (Throwable)e);
        }
    }

    private void registerAppClientModuleMBeans(String domainName, String serverName, String j2eeappName, AppClientModuleInfo[] appClientModules) {
        if (appClientModules.length == 0) {
            return;
        }
        for (int i = 0; i < appClientModules.length; ++i) {
            AppClientModuleInfo appClientModule = appClientModules[i];
            this.registerAppClientModuleMBean(domainName, serverName, j2eeappName, appClientModule.getModuleName(), appClientModule.getFileName(), appClientModule.getDeploymentDesc(), appClientModule.getJonasDeploymentDesc());
        }
    }

    private void unregisterAppClientModuleMBeans(String domainName, String serverName, String j2eeappName) {
        MBeanServer mbeanServer = this.jmxService.getJmxServer();
        ObjectName appClientModuleOns = J2eeObjectName.getAppClientModules((String)domainName, (String)serverName, (String)j2eeappName);
        for (ObjectName on : mbeanServer.queryNames(appClientModuleOns, null)) {
            this.jmxService.unregisterModelMBean(on);
        }
    }

    private Ear registerJ2EEApplicationModule(String domainName, String serverName, String j2eeApplicationName, String unpackDir, URL earUrl, String ddXmlContent, URL[] jarUrls, URL[] warUrls, URL[] connectorUrls) {
        String name = J2eeObjectName.J2EEApplicationName((String)domainName, (String)serverName, (String)j2eeApplicationName);
        Ear mbean = new Ear(name, j2eeApplicationName, unpackDir, earUrl, ddXmlContent, jarUrls, warUrls, connectorUrls, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)mbean, name);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Cannot register MBean for J2EEApplicationModule MBean " + j2eeApplicationName), (Throwable)e);
            return null;
        }
        return mbean;
    }

    private void unregisterJ2EEApplicationModule(String domainName, String serverName, String j2eeApplicationName) {
        ObjectName on = J2eeObjectName.J2EEApplication((String)domainName, (String)serverName, (String)j2eeApplicationName);
        this.jmxService.unregisterModelMBean(on);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setEjbService(EJBService ejbService) {
        this.ejbService = ejbService;
        this.earDeployer.setEjb21Service(ejbService);
    }

    public void unsetEjbService() {
        this.ejbService = null;
        this.earDeployer.setEjb21Service(null);
    }

    public void setWebContainerService(JWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
        this.earDeployer.setWebContainerService(webContainerService);
    }

    public void unsetWebContainerService() {
        this.webContainerService = null;
        this.earDeployer.setWebContainerService(null);
    }

    public void setWsService(WebServicesService wsService) {
        this.wsService = wsService;
        this.earDeployer.setWsService(wsService);
    }

    public void unsetWsService() {
        this.wsService = null;
        this.earDeployer.setWsService(null);
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
        this.earDeployer.setResourceService(resourceService);
    }

    public void unsetResourceService() {
        this.resourceService = null;
        this.earDeployer.setResourceService(null);
    }

    public void setEasyBeansService(IEasyBeansService service) {
        this.easyBeansService = service;
        this.earDeployer.setEmbedded(this.easyBeansService.getEasyBeansServer());
    }

    public void unsetEasyBeansService() {
        this.easyBeansService = null;
        this.earDeployer.setEmbedded(null);
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void unsetDeployerManager() {
        this.deployerManager = null;
    }
}

