/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ear.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.ow2.jonas.deployment.ear.wrapper.EarManagerWrapper;
import org.ow2.jonas.ear.EarService;
import org.ow2.jonas.ear.internal.EarCleanTask;
import org.ow2.jonas.ear.internal.EarDeployer;
import org.ow2.jonas.ear.internal.JOnASEARServiceMBean;
import org.ow2.jonas.ejb2.EJBService;
import org.ow2.jonas.ejb3.IEasyBeansService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.WorkCleanerService;
import org.ow2.jonas.ws.jaxrpc.IJAXRPCService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.EARDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASEARService
extends AbsServiceImpl
implements EarService,
JOnASEARServiceMBean {
    private Log logger = LogFactory.getLog(JOnASEARService.class);
    protected static final String WORK_DIR = JProp.getWorkDir();
    protected static final String WORK_APPS_DIR = WORK_DIR + File.separator + "apps";
    private JmxService jmxService = null;
    private EJBService ejbService = null;
    private JWebContainerService webContainerService = null;
    private IJAXRPCService jaxrpcService = null;
    private ResourceService resourceService = null;
    private IEasyBeansService easyBeansService = null;
    private ClassLoader extClassLoader;
    private EarDeployer earDeployer = new EarDeployer();
    private IDeployerManager deployerManager;
    private File workAppsFile = null;
    private boolean genStub = false;
    private boolean useEJB3ChildClassloader = false;

    public void setParsingwithvalidation(boolean validate) {
        EarManagerWrapper.setParsingWithValidation((boolean)validate);
        if (!validate) {
            this.logger.debug((Object)"EAR XML parsing without validation", new Object[0]);
        } else {
            this.logger.debug((Object)"EAR XML parsing with validation", new Object[0]);
        }
    }

    public void setGenstub(boolean isEnabled) {
        this.genStub = isEnabled;
    }

    public void useEJB3ChildClassloader(boolean isEnabled) {
        this.useEJB3ChildClassloader = isEnabled;
    }

    protected void doStop() throws ServiceException {
        this.earDeployer.stop();
        if (this.deployerManager != null) {
            this.deployerManager.unregister((IDeployer)this.earDeployer);
        }
        if (this.jmxService != null) {
            this.unregisterEarServiceMBean(this.getDomainName());
        }
        this.logger.info((Object)"EAR Service stopped", new Object[0]);
    }

    protected void doStart() throws ServiceException {
        this.initWorkingDirectory();
        if (this.easyBeansService != null) {
            this.earDeployer.setEmbedded(this.easyBeansService.getEasyBeansServer());
        }
        try {
            LoaderManager lm = LoaderManager.getInstance();
            this.extClassLoader = lm.getExternalLoader();
        }
        catch (Exception e) {
            this.logger.error((Object)("Cannot get the Applications ClassLoader from EAR Container Service: " + e), new Object[0]);
            throw new ServiceException("Cannot get the Applications ClassLoader from EAR Container Service", (Throwable)e);
        }
        this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        this.earDeployer.setAppsClassLoader(this.extClassLoader);
        this.earDeployer.setJMXService(this.jmxService);
        this.earDeployer.setServerProperties(this.getServerProperties());
        if (this.genStub) {
            this.earDeployer.enableGenClientStub();
        }
        if (this.useEJB3ChildClassloader) {
            this.earDeployer.useEJB3ChildClassloader();
        }
        this.deployerManager.register((IDeployer)this.earDeployer);
        this.registerEarServiceMBean(this, this.getDomainName());
        this.logger.info((Object)"EAR Service started", new Object[0]);
    }

    protected void initWorkingDirectory() {
        if (this.workAppsFile == null) {
            this.workAppsFile = new File(WORK_APPS_DIR + File.separator + this.getServerProperties().getServerName());
            this.workAppsFile.mkdirs();
        }
    }

    protected void setWorkCleanerService(WorkCleanerService workCleanerService) {
        this.initWorkingDirectory();
        File fileLog = new File(this.workAppsFile.getPath() + File.separator + this.getServerProperties().getServerName() + ".log");
        if (!fileLog.exists()) {
            try {
                fileLog.getParentFile().mkdirs();
                fileLog.createNewFile();
            }
            catch (IOException e) {
                this.logger.error((Object)("cannot create the log file" + fileLog), new Object[]{e});
            }
        }
        try {
            DeployerLog deployerLog = new DeployerLog(fileLog);
            this.earDeployer.setDeployerLog(deployerLog);
            EarCleanTask cleanTask = new EarCleanTask(this, deployerLog);
            workCleanerService.registerTask((CleanTask)cleanTask);
            workCleanerService.executeTasks();
        }
        catch (DeployerLogException e) {
            this.logger.error((Object)"Cannot register the clean task", new Object[]{e});
        }
    }

    @Override
    public List<String> getDeployedEars() {
        ArrayList<String> names = new ArrayList<String>();
        Map<URL, EARDeployable> ears = this.earDeployer.getEars();
        for (URL earURL : ears.keySet()) {
            names.add(earURL.getFile());
        }
        return names;
    }

    @Override
    public Integer getDeployedEARsNumber() {
        return new Integer(this.earDeployer.getEars().size());
    }

    @Override
    public boolean isEarLoaded(String fileName) {
        URL url = null;
        boolean isLoaded = false;
        try {
            try {
                url = new File(fileName).getCanonicalFile().toURL();
                if (this.earDeployer.getEars().get(url) != null) {
                    isLoaded = true;
                }
            }
            catch (Exception e) {
                url = null;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Can not found if the ear is deployed or not", new Object[0]);
            return false;
        }
        return isLoaded;
    }

    public boolean isEarDeployedByWorkName(String unpackName) {
        Map<URL, EARDeployable> ears = this.earDeployer.getEars();
        for (EARDeployable earDeployable : ears.values()) {
            try {
                File unpackedFile = URLUtils.urlToFile((URL)earDeployable.getArchive().getURL());
                if (!unpackName.equals(unpackedFile.getName())) continue;
                return true;
            }
            catch (ArchiveException e) {
                this.logger.debug((Object)"Cannot retrieve the name of the unpacked ear {0}", new Object[]{unpackName});
            }
        }
        return false;
    }

    private void registerEarServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.earService((String)domainName);
        this.jmxService.registerMBean(service, on);
    }

    private void unregisterEarServiceMBean(String domainName) {
        ObjectName on = JonasObjectName.earService((String)domainName);
        this.jmxService.unregisterMBean(on);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setEjbService(EJBService ejbService) {
        this.ejbService = ejbService;
        this.earDeployer.setEjb21Service(ejbService);
    }

    public void unsetEjbService() {
        this.ejbService = null;
        this.earDeployer.setEjb21Service(null);
    }

    public void setWebContainerService(JWebContainerService webContainerService) {
        this.webContainerService = webContainerService;
        this.earDeployer.setWebContainerService(webContainerService);
    }

    public void unsetWebContainerService() {
        this.webContainerService = null;
        this.earDeployer.setWebContainerService(null);
    }

    public void setJAXRPCService(IJAXRPCService jaxrpcService) {
        this.jaxrpcService = jaxrpcService;
        this.earDeployer.setJAXRPCService(jaxrpcService);
    }

    public void unsetJAXRPCService() {
        this.jaxrpcService = null;
        this.earDeployer.setJAXRPCService(null);
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
        this.earDeployer.setResourceService(resourceService);
    }

    public void unsetResourceService() {
        this.resourceService = null;
        this.earDeployer.setResourceService(null);
    }

    public void setEasyBeansService(IEasyBeansService service) {
        this.easyBeansService = service;
        this.earDeployer.setEasyBeansService(this.easyBeansService);
        this.earDeployer.setEmbedded(this.easyBeansService.getEasyBeansServer());
    }

    public void unsetEasyBeansService() {
        this.easyBeansService = null;
        this.earDeployer.setEasyBeansService(null);
        this.earDeployer.setEmbedded(null);
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void unsetDeployerManager() {
        this.deployerManager = null;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.earDeployer.setVersioningService(versioningService);
    }

    public void unsetVersioningService() {
        this.earDeployer.unsetVersioningService();
    }

    public VersioningService getVersioningService() {
        return this.earDeployer.getVersioningService();
    }
}

