/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.internal.mbean;

import org.ow2.jonas.ejb.internal.mbean.EJB;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.ejb21.EntityCounters;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JFactory;

public class EntityBean
extends EJB {
    private String persistency;

    public EntityBean(String objectName, JEntityFactory factoryToManage, String persistency, JmxService jmx) {
        super(objectName, (JFactory)factoryToManage, jmx);
        this.persistency = persistency;
    }

    public String getPersistency() {
        return this.persistency;
    }

    public int getPassivationTimeOut() {
        return ((JEntityFactory)this.ejbToManage).getPassivationTimeout();
    }

    public void setPassivationTimeOut(int timeOut) {
        ((JEntityFactory)this.ejbToManage).setPassivationTimeout(timeOut);
    }

    public int getInactivityTimeOut() {
        return ((JEntityFactory)this.ejbToManage).getInactivityTimeout();
    }

    public int getDeadlockTimeOut() {
        return ((JEntityFactory)this.ejbToManage).getDeadlockTimeout();
    }

    public int getReadTimeOut() {
        return ((JEntityFactory)this.ejbToManage).getReadTimeout();
    }

    public boolean getShared() {
        return ((JEntityFactory)this.ejbToManage).isShared();
    }

    public boolean getHardLimit() {
        return ((JEntityFactory)this.ejbToManage).isHardLimit();
    }

    public int getMinPoolSize() {
        return ((JEntityFactory)this.ejbToManage).getMinPoolSize();
    }

    public int getMaxCacheSize() {
        return ((JEntityFactory)this.ejbToManage).getMaxCacheSize();
    }

    public int getPoolSize() {
        return ((JEntityFactory)this.ejbToManage).getPoolSize();
    }

    public int getCurrentWaiters() {
        return ((JEntityFactory)this.ejbToManage).getCurrentWaiters();
    }

    public String getLockPolicy() {
        int lockPolicy = ((JEntityFactory)this.ejbToManage).getLockPolicy();
        String sLockPolicy = null;
        switch (lockPolicy) {
            case 0: {
                sLockPolicy = "container-read-uncommitted";
                break;
            }
            case 1: {
                sLockPolicy = "container-serialized";
                break;
            }
            case 6: {
                sLockPolicy = "container-serialized-transacted";
                break;
            }
            case 2: {
                sLockPolicy = "container-read-committed";
                break;
            }
            case 3: {
                sLockPolicy = "database";
                break;
            }
            case 4: {
                sLockPolicy = "read-only";
                break;
            }
            case 5: {
                sLockPolicy = "container-read-write";
            }
        }
        return sLockPolicy;
    }

    public boolean getPrefetch() {
        return ((JEntityFactory)this.ejbToManage).isPrefetch();
    }

    public int getCacheSize() {
        return ((JEntityFactory)this.ejbToManage).getCacheSize();
    }

    public Integer[] getEntityCounters() {
        EntityCounters ec = ((JEntityFactory)this.ejbToManage).getEntityCounters();
        Integer[] result = new Integer[]{new Integer(ec.inTx), new Integer(ec.outTx), new Integer(ec.idle), new Integer(ec.passive), new Integer(ec.removed), new Integer(ec.pk)};
        return result;
    }

    public void synchronize() {
        ((JEntityFactory)this.ejbToManage).syncDirty(true);
    }

    public void reduceCache() {
        ((JEntityFactory)this.ejbToManage).reduceCache();
    }
}

