/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2006 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial developer(s): ____________________________________.
 * Contributor(s): Michel Bruno and Guillaume Riviere
 *
 * --------------------------------------------------------------------------
 * $Id: JOnASEJBServiceMBean.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ejb.internal;

import java.util.List;
import java.util.Set;

/**
 * MBean Interface for EJB Service Management.
 * MBean type: Standard
 * MBean model: Inheritance (EJBServiceImpl)
 */
public interface JOnASEJBServiceMBean {

    /**
     * @return Integer Total Number of Container actually in JOnAS
     */
    Integer getCurrentNumberOfContainer();

    /**
     * @return Integer Total Number of Bean Type actually in JOnAS
     */
    Integer getTotalCurrentNumberOfBeanType();

    /**
     * @return Integer Total Number of Bmp Type actually in JOnAS
     */
    Integer getTotalCurrentNumberOfBMPType();

    /**
     * @return Integer Total Number of Cmp Type actually in JOnAS
     */
    Integer getTotalCurrentNumberOfCMPType();

    /**
     * @return Integer Total Number of Sbf Type actually in JOnAS
     */
    Integer getTotalCurrentNumberOfSBFType();

    /**
     * @return Integer Total Number of Sbl Type actually in JOnAS
     */
    Integer getTotalCurrentNumberOfSBLType();

    /**
     * @return Integer Total Number of Mdb Type actually in JOnAS
     */
    Integer getTotalCurrentNumberOfMDBType();

    /**
     * @return the ObjectName of all the ejbs using this datasource
     */
    Set getDataSourceDependence(String dsName);

    /**
     * @return the ObjectName of all the ejb using this destination.
     */
    Set getJmsDestinationDependence(String dsName);

    /**
     * @return the ObjectName of all the ejb using this Connection Factory.
     */
    Set getJmsConnectionFactoryDependence(String cfName);

    /**
     * @return the ObjectName of all the ejb using a given Mail Factory.
     */
    Set getMailFactoryDependence(String mfName);

    /**
     * Return the list of installed EJB containers.
     * The JAR files or the directories with expanded EJB container are searched
     * in JONAS_BASE/ejbjars and all ejbjar directories 'autoload'.
     * @return The list of JAR files or the directories with expanded EJB container found
     * @throws Exception if the list can't be retrieved
     */
    List getInstalledJars() throws Exception;

    List getDeployedJars();
    List getDeployableJars() throws Exception;
    String getJarsDirectory();
    /**
     * Synchronized all entity bean containers.
     * @param passivate passivate instances after synchronization.
     */
    void syncAllEntities(boolean passivate);

    /**
     * Test if the specified filename is already deployed or not.
     * @param fileName the name of the jar file.
     * @return true if the jar is deployed, else false.
     */
    boolean isJarLoaded(String fileName);

}
