/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.work.WorkManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.jonas.Version;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.EntityBmpDesc;
import org.ow2.jonas.deployment.ejb.EntityCmpDesc;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.ejb.EJBService;
import org.ow2.jonas.ejb.JTimerHandleInfo;
import org.ow2.jonas.ejb.internal.EJB21Deployer;
import org.ow2.jonas.ejb.internal.JOnASEJBServiceMBean;
import org.ow2.jonas.ejb.internal.JarCleanTask;
import org.ow2.jonas.ejb.internal.PrincipalFactoryImpl;
import org.ow2.jonas.ejb.internal.delegate.HandleDelegateCCFDelegate;
import org.ow2.jonas.ejb.internal.delegate.JTimerHandleDelegate;
import org.ow2.jonas.ejb.internal.mbean.EJBModule;
import org.ow2.jonas.ejb.internal.mbean.EntityBean;
import org.ow2.jonas.ejb.internal.mbean.MessageDrivenBean;
import org.ow2.jonas.ejb.internal.mbean.StatefulSessionBean;
import org.ow2.jonas.ejb.internal.mbean.StatelessSessionBean;
import org.ow2.jonas.generators.genic.wrapper.GenicServiceWrapper;
import org.ow2.jonas.generators.wsgen.wrapper.WsGenWrapper;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.ejb21.BeanFactory;
import org.ow2.jonas.lib.ejb21.Container;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JStatelessFactory;
import org.ow2.jonas.lib.ejb21.JTimerService;
import org.ow2.jonas.lib.ejb21.PermissionManager;
import org.ow2.jonas.lib.ejb21.PrincipalFactory;
import org.ow2.jonas.lib.ejb21.Protocols;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.loader.EjbJarClassLoader;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.timer.TraceTimer;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.lib.work.AbsCleanTask;
import org.ow2.jonas.lib.work.CleanerException;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.lib.work.FileManager;
import org.ow2.jonas.lib.work.WorkCleaner;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JComponentContextFactoryDelegate;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.workmanager.WorkManagerService;
import org.ow2.jonas.ws.WebServicesService;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;

public class JOnASEJBService
extends AbsServiceImpl
implements EJBService,
JOnASEJBServiceMBean {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ejb");
    private static Logger loaderlog = Log.getLogger((String)"org.ow2.jonas.loader");
    private TransactionManager tm = null;
    private JmxService jmxService = null;
    private SecurityService securityService = null;
    private WebServicesService wsService = null;
    private RegistryService registryService = null;
    private static WorkCleaner workCleaner = null;
    private List<String> ejbNames = new Vector<String>();
    private Vector<Container> containers = new Vector();
    private WorkManager workManager;
    protected static final String JONAS_BASE = JProp.getJonasBase();
    protected static final String EJBJARS_DIR = JONAS_BASE + File.separator + "ejbjars";
    private ArrayList<String> autoloadDirectories = new ArrayList();
    public static final String BMP = "Bean-Managed";
    public static final String CMP = "Container-Managed";
    private ClassLoader appsClassLoader = null;
    private static final String WORK_DIR = JProp.getWorkDir();
    private static final String WORK_EJBJARS_DIR = WORK_DIR + File.separator + "ejbjars";
    private static String ejbjarsDir = null;
    private DeployerLog jarDeployerLog = null;
    private boolean autoGenIC = true;
    private List<String> autoGenICArgsList = new ArrayList<String>();
    private JComponentContextFactory componentContextFactory = null;
    private HandleDelegateCCFDelegate ccfd = null;
    private TransactionService transactionService;
    private WorkManagerService workManagerService;
    private JNamingManager naming;
    private EJB21Deployer ejb21Deployer = new EJB21Deployer();
    private CmiService cmiService = null;
    private HaService haService = null;
    private ResourceService resService = null;
    private IDeployerManager deployerManager;
    static final int DATASOURCE = 1;
    static final int JMS_DESTINATION = 2;
    static final int JMS_FACTORY = 3;
    static final int MAIL_FACTORY = 4;

    public void setAutoGenic(boolean autoGenIC) {
        this.autoGenIC = autoGenIC;
        if (!autoGenIC) {
            logger.log(BasicLevel.INFO, (Object)"Auto GenIC has been disabled");
        }
    }

    public void setParsingwithvalidation(boolean validate) {
        EjbDeploymentDescManager.setParsingWithValidation((boolean)validate);
        if (!validate && logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"XML parsing without validation");
        }
    }

    public void setDescriptors(String descriptors) {
        List descriptorList;
        this.ejbNames = descriptorList = JOnASEJBService.convertToList((String)descriptors);
    }

    public void setAutoloaddir(String directories) {
        List directoryList = JOnASEJBService.convertToList((String)directories);
        for (String directory : directoryList) {
            String dirName = directory.trim();
            this.addEjbjars(dirName);
            File file = new File(EJBJARS_DIR, dirName);
            if (!file.exists()) continue;
            try {
                this.autoloadDirectories.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                String err = "Error when trying to verify Ejbjar autoload directory : " + dirName;
                logger.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            }
        }
    }

    public void setAutoGenicArgs(String args) {
        this.autoGenICArgsList = JOnASEJBService.convertToList((String)args);
        if (!this.autoGenICArgsList.isEmpty()) {
            logger.log(BasicLevel.INFO, (Object)("Auto GenIC args are set to '" + this.autoGenICArgsList + "'."));
        }
    }

    public void checkRequirements() throws ServiceException {
        if (this.jmxService == null) {
            this.throwRequirementException("Missing reference on " + JmxService.class);
        }
        if (this.transactionService == null) {
            this.throwRequirementException("Missing reference on " + TransactionService.class);
        }
        if (this.workManagerService == null) {
            this.throwRequirementException("Missing reference on " + WorkManagerService.class);
        }
    }

    public void doStart() throws ServiceException {
        if (this.transactionService == null) {
            logger.log(BasicLevel.ERROR, (Object)"Transaction Service not injected");
            throw new ServiceException("Transaction Service not injected");
        }
        this.tm = this.transactionService.getTransactionManager();
        if (this.workManagerService == null) {
            logger.log(BasicLevel.ERROR, (Object)"WorkManager Service not injected");
            throw new ServiceException("WorkManager Service not injected");
        }
        this.workManager = this.workManagerService.getWorkManager();
        TraceTimer.configure((LoggerFactory)Log.getLoggerFactory());
        TraceEjb.configure((LoggerFactory)Log.getLoggerFactory());
        logger.log(BasicLevel.DEBUG, (Object)"");
        this.ejb21Deployer.setEjb21Service(this);
        if (this.deployerManager == null) {
            logger.log(BasicLevel.ERROR, (Object)"DeployerManager Service not injected");
            throw new ServiceException("DeployerManager Service not injected");
        }
        this.deployerManager.register((IDeployer)this.ejb21Deployer);
        try {
            LoaderManager lm = LoaderManager.getInstance();
            this.appsClassLoader = lm.getAppsLoader();
        }
        catch (Throwable e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get the Applications ClassLoader from EJB Container Service");
            throw new ServiceException("Cannot get the Applications ClassLoader from EJB Container Service", e);
        }
        if (!this.isOSGi()) {
            try {
                this.ccfd = new HandleDelegateCCFDelegate();
                if (this.componentContextFactory == null) {
                    logger.log(BasicLevel.ERROR, (Object)"componentContextFactory not set");
                    throw new ServiceException("Cannot get ComponentContextFactory");
                }
                this.componentContextFactory.addDelegate((JComponentContextFactoryDelegate)this.ccfd);
            }
            catch (NamingException e) {
                logger.log(BasicLevel.WARN, (Object)"Cannot get ComponentContextFactory:", (Throwable)e);
            }
        }
        if (!this.isOSGi()) {
            try {
                JTimerHandleDelegate tccfd = new JTimerHandleDelegate();
                tccfd.setEJBService(this);
                this.componentContextFactory.addDelegate((JComponentContextFactoryDelegate)tccfd);
            }
            catch (NamingException e) {
                logger.log(BasicLevel.WARN, (Object)"Cannot get ComponentContextFactory:", (Throwable)e);
            }
        }
        if (this.jmxService != null) {
            this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        }
        ejbjarsDir = WORK_EJBJARS_DIR + File.separator + this.getJonasServerName();
        URL ejbjarsUrl = null;
        try {
            ejbjarsUrl = new File(ejbjarsDir).toURL();
        }
        catch (MalformedURLException mue) {
            throw new ServiceException("Error when trying to get the URL of the jonasroot/apps directory", (Throwable)mue);
        }
        File fLog = new File(ejbjarsUrl.getFile() + File.separator + this.getJonasServerName() + ".log");
        if (!fLog.exists()) {
            try {
                fLog.getParentFile().mkdirs();
                fLog.createNewFile();
            }
            catch (IOException e) {
                throw new ServiceException("cannot create the log file" + fLog, (Throwable)e);
            }
        }
        try {
            this.jarDeployerLog = new DeployerLog(fLog);
        }
        catch (DeployerLogException e) {
            throw new ServiceException("Can not get an EarDeployerLog", (Throwable)e);
        }
        JarCleanTask jarCleanTask = new JarCleanTask(this.jarDeployerLog, this);
        workCleaner = WorkCleaner.getInstance();
        try {
            workCleaner.registerTask((AbsCleanTask)jarCleanTask);
        }
        catch (CleanerException ce) {
            throw new ServiceException("Cannot register the JAR clean task", (Throwable)ce);
        }
        workCleaner.executeTasks();
        String fileName = null;
        ComponentContext contctx = null;
        for (int i = 0; i < this.ejbNames.size(); ++i) {
            fileName = this.ejbNames.get(i);
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("filename", (Object)fileName);
            }
            catch (NamingException ne) {
                logger.log(BasicLevel.WARN, (Object)("Cannot create container for " + fileName + " because of a NamingException : " + ne.toString()));
            }
            try {
                this.createContainer((Context)contctx);
                continue;
            }
            catch (Throwable e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot create container for " + fileName), e);
                try {
                    contctx.close();
                    continue;
                }
                catch (NamingException nne) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Cannot close deploy context for " + fileName), (Throwable)nne);
                }
            }
        }
        this.registerEjbServiceMBean(this, this.getDomainName());
        logger.log(BasicLevel.INFO, (Object)"EJB 2.1 Service started");
    }

    public void doStop() {
        if (this.deployerManager != null) {
            this.deployerManager.unregister((IDeployer)this.ejb21Deployer);
        }
        if (!this.isOSGi() && this.componentContextFactory != null) {
            try {
                this.componentContextFactory.removeDelegate((JComponentContextFactoryDelegate)this.ccfd);
            }
            catch (NamingException e) {
                logger.log(BasicLevel.DEBUG, (Object)"Cannot remove the handle delegate", (Throwable)e);
            }
        }
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            Container cont = lc.nextElement();
            this.removeContainer(cont);
        }
        this.unregisterEjbServiceMBean(this.getDomainName());
        logger.log(BasicLevel.INFO, (Object)"EJB 2.1 Service stopped");
    }

    public String createContainer(Context ctx) throws Exception {
        String earFileName;
        URLClassLoader earClassLoader;
        URLClassLoader ejbClassLoader;
        URL[] url;
        String wkFileName;
        boolean isInEar;
        String fileName;
        block44: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"");
            }
            fileName = (String)ctx.lookup("filename");
            File f = new File(fileName);
            boolean isEjbJar = fileName.toLowerCase().endsWith(".jar");
            try {
                String ejbjarFileName;
                if (!f.exists() && isEjbJar && !(f = new File(ejbjarFileName = EJBJARS_DIR + File.separator + fileName).getCanonicalFile()).exists()) {
                    logger.log(BasicLevel.ERROR, (Object)("createContainer: " + fileName + " not found"));
                    throw new NamingException(fileName + " not found");
                }
            }
            catch (IOException e) {
                String err = "Invalid ejbjar file name '" + fileName;
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new Exception(err, e);
            }
            boolean isEjbJarFile = isEjbJar && f.isFile();
            boolean isEjbJarXml = fileName.toLowerCase().endsWith(".xml") && f.isFile();
            try {
                fileName = f.toURL().getPath();
            }
            catch (MalformedURLException e) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid ejb-jar file name '" + fileName + "'"), (Throwable)e);
            }
            if (f.isFile() && !isEjbJar && !isEjbJarXml) {
                throw new ServiceException("The ejbjar to deploy is not a jar file nor an xml file");
            }
            if (this.getContainer(fileName) != null) {
                logger.log(BasicLevel.ERROR, (Object)("createContainer: " + fileName + " already exists"));
                throw new Exception("Container already exists");
            }
            isInEar = true;
            try {
                ctx.lookup("earClassLoader");
            }
            catch (NamingException ne) {
                isInEar = false;
            }
            if (!isInEar && isEjbJar) {
                this.checkGenIC(fileName, null);
                String resultFilename = this.applyWSGenIfNeeded(fileName);
                if (resultFilename.endsWith(".ear")) {
                    return J2eeObjectName.getEJBModule((String)this.getDomainName(), (String)this.getJonasServerName(), (String)ModuleNamingUtils.fromFileName((String)resultFilename), (String)ModuleNamingUtils.fromFileName((String)fileName)).getCanonicalName();
                }
            }
            wkFileName = null;
            if (!isInEar && isEjbJarFile) {
                wkFileName = ejbjarsDir + File.separator + FileManager.fileToTimeStampDir((URL)f.toURL(), (String)".jar");
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("filename=" + fileName));
                    logger.log(BasicLevel.DEBUG, (Object)("wkFilename=" + wkFileName));
                }
                FileUtils.copyFile((String)fileName, (String)wkFileName);
                try {
                    this.jarDeployerLog.addEntry(f, new File(wkFileName));
                }
                catch (DeployerLogException e) {
                    String err = "Error while adding the " + fileName + " entry in the log file";
                    logger.log(BasicLevel.ERROR, (Object)(err + " : " + e.getMessage()));
                    throw new Exception(err, e);
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Create wk file :" + wkFileName));
                }
            } else {
                wkFileName = fileName;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("No needs wk file :" + wkFileName));
                }
            }
            url = null;
            try {
                url = new URL[]{new File(wkFileName).toURL()};
            }
            catch (MalformedURLException e) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid ejb-jar file name '" + wkFileName + "'"), (Throwable)e);
            }
            ejbClassLoader = null;
            earClassLoader = null;
            try {
                earClassLoader = (URLClassLoader)ctx.lookup("earClassLoader");
                ejbClassLoader = (URLClassLoader)ctx.lookup("ejbClassLoader");
                if (loaderlog.isLoggable(BasicLevel.DEBUG)) {
                    loaderlog.log(BasicLevel.DEBUG, (Object)("earClassLoader=" + earClassLoader));
                }
            }
            catch (NamingException ne) {
                ejbClassLoader = isEjbJar ? new EjbJarClassLoader(url, this.appsClassLoader) : (URLClassLoader)this.appsClassLoader;
                if (!loaderlog.isLoggable(BasicLevel.DEBUG)) break block44;
                loaderlog.log(BasicLevel.DEBUG, (Object)("parent Loader=" + this.appsClassLoader));
            }
        }
        if (loaderlog.isLoggable(BasicLevel.DEBUG)) {
            loaderlog.log(BasicLevel.DEBUG, (Object)("ejbClassLoader=" + ejbClassLoader));
        }
        DeploymentDesc dd = null;
        try {
            EjbDeploymentDescManager mgr = EjbDeploymentDescManager.getInstance();
            dd = mgr.getDeploymentDesc(url[0], (ClassLoader)ejbClassLoader, (ClassLoader)earClassLoader);
        }
        catch (DeploymentDescException e) {
            String err = "Cannot read the deployment descriptors '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            logger.log(BasicLevel.ERROR, (Object)("DeploymentDescException:" + (Object)((Object)e)));
            throw new ServiceException(err, (Throwable)e);
        }
        String cname = ModuleNamingUtils.fromFileName((String)fileName);
        if (cname == null) {
            cname = "EJB container ";
            if (dd.getDisplayName() != null) {
                cname = cname + dd.getDisplayName();
            }
        }
        JContainer cont = new JContainer(cname, fileName, wkFileName, (ClassLoader)ejbClassLoader, dd, this.cmiService, this.haService, this.wsService, this.jmxService.getJmxServer(), this.resService);
        cont.setContainerNaming(this.naming);
        if (this.componentContextFactory == null) {
            logger.log(BasicLevel.ERROR, (Object)"componentContextFactory has not been set");
        }
        cont.setComponentContextFactory(this.componentContextFactory);
        cont.setTransactionManager(this.tm);
        cont.setPrincipalFactory((PrincipalFactory)new PrincipalFactoryImpl());
        URL earUrl = null;
        try {
            earUrl = (URL)ctx.lookup("earURL");
            earFileName = earUrl.getFile();
            cont.setEarFileName(earFileName);
        }
        catch (NamingException ne) {
            earFileName = null;
        }
        if (this.securityService == null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"EJB Container Service: working without Security Service");
            }
            cont.setSecurity(false);
        } else {
            PermissionManager permissionManager = null;
            try {
                permissionManager = new PermissionManager(dd, cont.getContextId());
                permissionManager.translateEjbDeploymentDescriptor();
                if (!isInEar) {
                    permissionManager.commit();
                }
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Can't build permission manager object for the ejbjar '" + fileName + "'"), (Throwable)e);
            }
            cont.setPermissionManager(permissionManager);
        }
        cont.setWorkManager(this.workManager);
        BeanDesc[] beans = dd.getBeanDesc();
        ArrayList<BeanFactory> bflist = new ArrayList<BeanFactory>();
        HashMap<String, BeanFactory> factoryMap = new HashMap<String, BeanFactory>();
        HashMap<String, BeanDesc> beanDescMap = new HashMap<String, BeanDesc>();
        for (int i = 0; i < beans.length; ++i) {
            BeanDesc beanDesc = beans[i];
            String beanName = null;
            try {
                beanName = beanDesc.getEjbName();
                BeanFactory bf = cont.addBean(beanDesc);
                bflist.add(bf);
                factoryMap.put(beanName, bf);
                beanDescMap.put(beanName, beanDesc);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(BasicLevel.WARN, (Object)("Can't deploy beanName : " + beanName + "Exception: " + e));
            }
        }
        for (BeanFactory bf : bflist) {
            bf.initInstancePool();
        }
        this.containers.addElement((Container)cont);
        for (BeanFactory bf : bflist) {
            bf.restartTimers();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("created container for " + fileName));
        }
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String j2eeappName = ModuleNamingUtils.fromFileName((String)earFileName);
        String ejbModuleON = this.registerCompMBeans(domainName, serverName, j2eeappName, cname, cont, fileName, earUrl, dd, factoryMap, beanDescMap);
        return ejbModuleON;
    }

    private String applyWSGenIfNeeded(String filename) throws DeployerException {
        String nfile;
        block16: {
            if (this.wsService == null) {
                logger.log(BasicLevel.DEBUG, (Object)"The WS service is not present, no need to call WSGen");
                return filename;
            }
            if (!this.wsService.isAutoWsGenEngaged()) {
                logger.log(BasicLevel.DEBUG, (Object)"Automatic WsGen is not enabled, no need to call WSGen");
                return filename;
            }
            String jonasVersionWsGen = JOnASEJBService.getAttributeInManifest(filename, "WsGen-JOnAS-Version");
            if (Version.getNumber().equals(jonasVersionWsGen)) {
                logger.log(BasicLevel.DEBUG, (Object)"No change: no need to call WSGen");
                return filename;
            }
            WsGenWrapper wsgen = new WsGenWrapper();
            nfile = null;
            try {
                nfile = wsgen.callWsGenExecute(filename, Boolean.valueOf(false));
                if (!wsgen.callWsGenIsInputModifed()) break block16;
                if (nfile.endsWith(".ear")) {
                    logger.log(BasicLevel.DEBUG, (Object)("WsGen produced an EAR '" + nfile + "'"));
                    File source = new File(nfile);
                    File destination = new File(JProp.getJonasBase(), "apps" + File.separator + source.getName());
                    try {
                        FileUtils.copyFile((File)source, (File)destination);
                    }
                    catch (FileUtilsException e) {
                        throw new DeployerException("Cannot copy the file from '" + nfile + "' to '" + filename + "'", (Throwable)e);
                    }
                    logger.log(BasicLevel.DEBUG, (Object)("Deploying '" + nfile + "' (copied from '" + source.getPath() + "') ..."));
                    try {
                        ObjectName earServiceON = JonasObjectName.earService((String)this.getDomainName());
                        Object[] param = new Object[]{nfile, Boolean.FALSE};
                        String[] signature = new String[]{"java.lang.String", "java.lang.Boolean"};
                        MBeanServer mbeanServer = this.jmxService.getJmxServer();
                        mbeanServer.invoke(earServiceON, "deployEarMBean", param, signature);
                        break block16;
                    }
                    catch (InstanceNotFoundException e) {
                        throw new DeployerException("Ear Service not available. Cannot deploy : " + nfile, (Throwable)e);
                    }
                    catch (MBeanException e) {
                        throw new DeployerException("Cannot deploy the produced Application : " + nfile, (Throwable)e.getTargetException());
                    }
                    catch (ReflectionException e) {
                        throw new DeployerException("Cannot invoke deploy operation on Ear Service MBean for application : " + nfile, (Throwable)e);
                    }
                }
                logger.log(BasicLevel.DEBUG, (Object)("Archive updated, continuing deployment : " + nfile));
                try {
                    System.gc();
                    Thread.sleep(Long.getLong("jonas.wsgen.sleep", 100L));
                    if (!FileUtils.delete((String)filename)) {
                        throw new DeployerException("Cannot delete old application : " + filename);
                    }
                    FileUtils.copyFile((String)nfile, (String)filename);
                    FileUtils.delete((String)nfile);
                }
                catch (FileUtilsException e) {
                    throw new DeployerException("Cannot copy the ear from '" + nfile + "' to '" + filename + "'", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new DeployerException("Cannot sleep for the given time period", (Throwable)e);
                }
                return filename;
            }
            catch (Exception e) {
                throw new DeployerException("Cannot execute WSGen on '" + filename + "'", (Throwable)e);
            }
        }
        return nfile;
    }

    public Container getContainer(String fileName) {
        String pathEjbJarDirFile;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)fileName);
        }
        String ejbjarFileName = EJBJARS_DIR + File.separator + fileName;
        File f = null;
        String pathFile = "";
        try {
            f = new File(ejbjarFileName).getCanonicalFile();
            pathEjbJarDirFile = f.toURL().getPath();
        }
        catch (Exception e) {
            pathEjbJarDirFile = "";
        }
        try {
            f = new File(fileName);
            pathFile = f.toURL().getPath();
        }
        catch (Exception e) {
            String err = "Error while trying to get canonical file '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            return null;
        }
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            String contName = cont.getExternalFileName();
            if (contName.equals(pathFile)) {
                return cont;
            }
            if (contName.equals(pathEjbJarDirFile)) {
                return cont;
            }
            List lAlDirs = this.getAutoloadDirectories();
            for (int i = 0; i < lAlDirs.size(); ++i) {
                String alDir = (String)lAlDirs.get(i);
                String alFileName = alDir + File.separator + fileName;
                try {
                    f = new File(alFileName).getCanonicalFile();
                    alFileName = f.toURL().getPath();
                }
                catch (Exception e) {
                    alFileName = alDir + File.separator + fileName;
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("alFileName= " + alFileName));
                }
                if (!contName.equals(alFileName)) continue;
                return cont;
            }
        }
        return null;
    }

    public void removeContainer(Container cont) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)cont.getName());
        }
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String earFileName = cont.getEarFileName();
        String earName = null;
        if (earFileName != null) {
            earName = ModuleNamingUtils.fromFileName((String)earFileName);
        }
        String moduleName = cont.getName();
        this.unregisterCompMBeans(domainName, serverName, earName, moduleName);
        cont.remove();
        this.containers.removeElement(cont);
        Runtime.getRuntime().gc();
    }

    public Container[] listContainers() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("size= " + this.containers.size()));
        }
        Object[] ret = new Container[this.containers.size()];
        this.containers.copyInto(ret);
        return ret;
    }

    public void syncAllEntities(boolean passivate) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            cont.syncAll(true, passivate);
        }
    }

    public Integer getCurrentNumberOfContainer() {
        return new Integer(this.containers.size());
    }

    public Integer getTotalCurrentNumberOfBeanType() {
        int count = 0;
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            count += cont.getBeanNb();
        }
        return new Integer(count);
    }

    public Integer getTotalCurrentNumberOfBMPType() {
        int count = 0;
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            count += cont.getEntityBMPNb();
        }
        return new Integer(count);
    }

    public Integer getTotalCurrentNumberOfCMPType() {
        int count = 0;
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            count += cont.getEntityCMPNb();
        }
        return new Integer(count);
    }

    public Integer getTotalCurrentNumberOfSBFType() {
        int count = 0;
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            count += cont.getStatefulSessionNb();
        }
        return new Integer(count);
    }

    public Integer getTotalCurrentNumberOfSBLType() {
        int count = 0;
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            count += cont.getStatelessSessionNb();
        }
        return new Integer(count);
    }

    public Integer getTotalCurrentNumberOfMDBType() {
        int count = 0;
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            count += cont.getMessageDrivenNb();
        }
        return new Integer(count);
    }

    public void removeContainer(String fileName) throws Exception {
        Container cont = null;
        try {
            cont = this.getContainer(fileName);
        }
        catch (Exception e) {
            String err = "Error while trying to find file '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new Exception(err, e);
        }
        if (cont == null) {
            String err = "Cannot remove the non-existant container '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new Exception(err);
        }
        this.removeContainer(cont, false);
    }

    public String createContainer(String file) throws Exception {
        String ejbModuleObjectName = null;
        try {
            ComponentContext contctx = new ComponentContext(file);
            contctx.rebind("filename", (Object)file);
            ejbModuleObjectName = this.createContainer((Context)contctx);
        }
        catch (Exception e) {
            throw new Exception("Cannot create Container", e);
        }
        return ejbModuleObjectName;
    }

    public Boolean isJarDeployed(String fileName) {
        return new Boolean(this.isJarLoaded(fileName));
    }

    public boolean isJarDeployedByWorkName(String workFileName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)workFileName);
        }
        Enumeration<Container> lc = this.containers.elements();
        while (lc.hasMoreElements()) {
            JContainer cont = (JContainer)lc.nextElement();
            String contName = new File(cont.getFileName()).getName();
            if (!contName.equals(workFileName)) continue;
            return true;
        }
        return false;
    }

    Set getDependence(String name, int type) {
        Set resultObjectName = new HashSet();
        HashSet resultProperties = new HashSet();
        Enumeration<Container> lc = this.containers.elements();
        try {
            InitialContext ctx = new InitialContext();
            ctx.lookup(name);
            ctx.close();
            while (lc.hasMoreElements()) {
                JContainer cont = (JContainer)lc.nextElement();
                Set depProps = null;
                switch (type) {
                    case 1: {
                        depProps = cont.getDataSourceDependence(name);
                        break;
                    }
                    case 2: {
                        depProps = cont.getJmsDestinationDependence(name);
                        break;
                    }
                    case 3: {
                        depProps = cont.getJmsConnectionFactoryDependence(name);
                        break;
                    }
                    case 4: {
                        depProps = cont.getMailFactoryDependence(name);
                    }
                }
                resultProperties.addAll(depProps);
                try {
                    resultObjectName = this.convertToObjectNames(resultProperties);
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)"EjbServiceImpl: Object Name Error", (Throwable)e);
                }
            }
        }
        catch (NamingException ne) {
            resultObjectName = new HashSet();
        }
        return resultObjectName;
    }

    private Set convertToObjectNames(Set resultProperties) {
        HashSet<ObjectName> resultObjectName = new HashSet<ObjectName>();
        Iterator it = resultProperties.iterator();
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        Properties item = null;
        String ejbType = null;
        String ejbName = null;
        String earFileName = null;
        String moduleName = null;
        String j2eeAppName = null;
        while (it.hasNext()) {
            item = (Properties)it.next();
            ObjectName ejbObjectName = null;
            ejbType = item.getProperty("type");
            ejbName = item.getProperty("name");
            earFileName = item.getProperty("earFileName");
            moduleName = item.getProperty("cname");
            if (earFileName != null) {
                j2eeAppName = ModuleNamingUtils.fromFileName((String)earFileName);
            }
            if (ejbType.equals("ejbbmp") || ejbType.equals("ejbcmp")) {
                ejbObjectName = J2eeObjectName.getEntityBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbsbf")) {
                ejbObjectName = J2eeObjectName.getStatefulSessionBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbsbl")) {
                ejbObjectName = J2eeObjectName.getStatelessSessionBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbmdb")) {
                ejbObjectName = J2eeObjectName.getMessageDrivenBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            }
            if (ejbObjectName == null) continue;
            resultObjectName.add(ejbObjectName);
        }
        return resultObjectName;
    }

    public Set getDataSourceDependence(String dsName) {
        return this.getDependence(dsName, 1);
    }

    public Set getJmsDestinationDependence(String destName) {
        return this.getDependence(destName, 2);
    }

    public Set getJmsConnectionFactoryDependence(String cfName) {
        return this.getDependence(cfName, 3);
    }

    public Set getMailFactoryDependence(String mfName) {
        return this.getDependence(mfName, 4);
    }

    public List getInstalledJars() throws Exception {
        ArrayList al = JModule.getInstalledContainersInDir((String)EJBJARS_DIR, (String)"jar", (String)"META-INF", (String)"ejb-jar.xml");
        for (int i = 0; i < this.autoloadDirectories.size(); ++i) {
            al.addAll(JModule.getInstalledContainersInDir((String)this.autoloadDirectories.get(i).toString(), (String)"jar", (String)"META-INF", (String)"ejb-jar.xml"));
        }
        return al;
    }

    public void deployJars(Context ctx) throws ServiceException {
        URL earRootUrl = null;
        URL earUrl = null;
        ClassLoader earClassLoader = null;
        ClassLoader ejbClassLoader = null;
        URL[] jarURLs = null;
        String[] roleNames = null;
        try {
            earRootUrl = (URL)ctx.lookup("earRootUrl");
            earUrl = (URL)ctx.lookup("earUrl");
            earClassLoader = (ClassLoader)ctx.lookup("earClassLoader");
            ejbClassLoader = (ClassLoader)ctx.lookup("ejbClassLoader");
            jarURLs = (URL[])ctx.lookup("jarURLs");
            roleNames = (String[])ctx.lookup("roleNames");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param :" + e.getMessage();
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, (Throwable)e);
        }
        for (int i = 0; i < jarURLs.length; ++i) {
            String fileName = jarURLs[i].getFile();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Deploy '" + fileName + "' for the ear service."));
            }
            ComponentContext contctx = null;
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("filename", (Object)fileName);
                contctx.rebind("earClassLoader", (Object)earClassLoader);
                contctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
                contctx.rebind("earRoot", (Object)earRootUrl.getFile());
                contctx.rebind("earURL", (Object)earUrl);
                contctx.rebind("roleNames", (Object)roleNames);
                this.createContainer((Context)contctx);
                continue;
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Error when deploying '" + fileName + "'"), (Throwable)e);
                logger.log(BasicLevel.ERROR, (Object)"Undeploy ejb-jar of the ear application");
                for (int j = 0; j <= i; ++j) {
                    Container cont = this.getContainer(jarURLs[j].getFile());
                    if (cont != null) {
                        this.removeContainer(cont, true);
                        continue;
                    }
                    logger.log(BasicLevel.ERROR, (Object)("Cannot remove the non-existant container '" + fileName + "'"));
                }
                throw new ServiceException("Error during the deployment", (Throwable)e);
            }
        }
    }

    public void unDeployJars(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String fileName = urls[i].getFile();
            Container cont = this.getContainer(urls[i].getFile());
            if (cont != null) {
                this.removeContainer(cont, true);
                continue;
            }
            logger.log(BasicLevel.ERROR, (Object)("Cannot remove the non-existant container '" + fileName + "'"));
        }
    }

    public void removeContainer(Container cont, boolean isEarCase) {
        if (isEarCase == (cont.getEarFileName() != null)) {
            this.removeContainer(cont);
        } else {
            String err = "Cannot remove container '" + cont.getName() + "' it is in an ear application. You must undeploy the ear associated.";
            logger.log(BasicLevel.ERROR, (Object)err);
        }
    }

    public void removeCache(ClassLoader earClassLoader) {
        EjbDeploymentDescManager mgr = EjbDeploymentDescManager.getInstance();
        mgr.removeCache(earClassLoader);
    }

    private void addEjbjars(String dirPath) {
        boolean found = false;
        File dir = new File(EJBJARS_DIR + File.separator + dirPath);
        found = dir.isDirectory();
        if (found) {
            this.addEjbjarsFrom(dir);
        } else {
            String err = "Warning: Cannot load dir: '" + dirPath + "' ";
            err = err + "is not a directory or directory doesn't exist";
            logger.log(BasicLevel.WARN, (Object)err);
        }
    }

    private void addEjbjarsFrom(File dir) throws ServiceException {
        block5: {
            try {
                if (dir.isDirectory()) {
                    File[] files = dir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].getPath().toLowerCase().endsWith(".jar")) {
                            this.ejbNames.add(files[i].getCanonicalPath());
                            continue;
                        }
                        if (!files[i].isDirectory()) continue;
                        this.addEjbjarsFrom(files[i]);
                    }
                    break block5;
                }
                String err = "Cannot load dir: '" + dir.getPath();
                err = err + "' is not a directory";
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new ServiceException(err);
            }
            catch (IOException e) {
                String err = "Invalid file name '" + dir.getPath();
                logger.log(BasicLevel.ERROR, (Object)err);
                throw new ServiceException(err, (Throwable)e);
            }
        }
    }

    public boolean isJarLoaded(String fileName) {
        return this.getContainer(fileName) != null;
    }

    public List getDeployedJars() {
        ArrayList<String> al = new ArrayList<String>();
        Enumeration<Container> jars = this.containers.elements();
        while (jars.hasMoreElements()) {
            Container oContainer = jars.nextElement();
            try {
                al.add(new File(oContainer.getExternalFileName()).toURL().getPath());
            }
            catch (Exception e) {}
        }
        return al;
    }

    public List getDeployableJars() throws Exception {
        List al = this.getInstalledJars();
        al.removeAll(this.getDeployedJars());
        return al;
    }

    public List getAutoloadDirectories() {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < this.autoloadDirectories.size(); ++i) {
            try {
                al.add(new File(this.autoloadDirectories.get(i).toString()).toURL().getPath());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return al;
    }

    public String getJarsDirectory() {
        String sRet;
        try {
            sRet = new File(EJBJARS_DIR).toURL().getPath();
        }
        catch (Exception e) {
            sRet = null;
        }
        return sRet;
    }

    private static boolean checkCurrentProtocolIncludeIntoGenerated(String listProtocolGenerated, String listCurrentProtocol) {
        Protocols generated = new Protocols(listProtocolGenerated);
        Protocols current = new Protocols(listCurrentProtocol);
        return generated.isSupported(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAttributeInManifest(String jarName, String attributName) {
        ZipFile jar = null;
        try {
            File jarFile = new File(jarName);
            jar = new JarFile(jarFile);
            Manifest man = ((JarFile)jar).getManifest();
            Attributes atts = man.getMainAttributes();
            String string = atts.getValue(attributName);
            return string;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot read Manifest: " + e));
            String string = null;
            return string;
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot close the Jar File: " + e));
            }
        }
    }

    public void checkGenIC(String fileName, URL[] urls) {
        if (!this.autoGenIC) {
            return;
        }
        List protocols = this.registryService.getActiveProtocolNames();
        String[] genicArgsString = null;
        int argIndex = 0;
        if (urls != null && urls.length > 0) {
            genicArgsString = new String[4 + this.autoGenICArgsList.size()];
            StringBuffer classpath = new StringBuffer();
            for (int i = 0; i < urls.length; ++i) {
                classpath.append(urls[i].getPath());
                if (i == urls.length - 1) continue;
                classpath.append(File.pathSeparator);
            }
            genicArgsString[argIndex++] = "-classpath";
            genicArgsString[argIndex++] = classpath.toString();
        } else {
            genicArgsString = new String[2 + this.autoGenICArgsList.size()];
        }
        genicArgsString[argIndex++] = "-protocols";
        String listProtocols = "";
        Iterator i = protocols.iterator();
        while (i.hasNext()) {
            String protocol = (String)i.next();
            listProtocols = listProtocols + protocol;
            if (!i.hasNext()) continue;
            listProtocols = listProtocols + ",";
        }
        genicArgsString[argIndex++] = listProtocols;
        Iterator<String> itExtraArg = this.autoGenICArgsList.iterator();
        while (itExtraArg.hasNext()) {
            genicArgsString[argIndex++] = itExtraArg.next();
        }
        String jonasVersionGenic = JOnASEJBService.getAttributeInManifest(fileName, "Genic-Jonas-Version");
        String listProtocolGenerated = JOnASEJBService.getAttributeInManifest(fileName, "Genic-Jonas-protocols");
        boolean isCurrentProtocolIncludeIntoGenerated = JOnASEJBService.checkCurrentProtocolIncludeIntoGenerated(listProtocolGenerated, listProtocols);
        if (jonasVersionGenic == null || !jonasVersionGenic.equals(Version.getNumber()) || !isCurrentProtocolIncludeIntoGenerated) {
            if (jonasVersionGenic == null) {
                logger.log(BasicLevel.INFO, (Object)("JOnAS version was not found in the '" + fileName + "' manifest file. Auto-generating container classes..."));
            } else if (!jonasVersionGenic.equals(Version.getNumber())) {
                logger.log(BasicLevel.INFO, (Object)("JOnAS version found in the '" + fileName + "' manifest file :" + jonasVersionGenic + " is different of the current JOnAS version : " + Version.getNumber() + ". Auto-generating container classes..."));
            } else if (!isCurrentProtocolIncludeIntoGenerated) {
                logger.log(BasicLevel.INFO, (Object)("Current Carol protocol is not included in the protocols found in the '" + fileName + "' manifest file. Auto-generating container classes..."));
            }
            try {
                this.callGenic(fileName, genicArgsString);
            }
            catch (ServiceException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot apply GenIC on the file '" + fileName + "' with the args '" + Arrays.asList(genicArgsString) + "'."), (Throwable)e);
            }
        }
    }

    public String getContainerContextID(String containerFileName) {
        return this.getContainer(containerFileName).getContextId();
    }

    public Timer getTimer(JTimerHandleInfo info) {
        JTimerService timerservice = this.getJTimerService(info);
        Timer ret = timerservice.getTimerByTime(info.getDuration(), info.getPeriod(), info.getInfo());
        if (ret == null) {
            throw new NoSuchObjectLocalException("The Timer should have been canceled");
        }
        return ret;
    }

    public Timer restartTimer(JTimerHandleInfo info) {
        JTimerService timerservice = this.getJTimerService(info);
        long newDuration = info.getDuration() + info.getStartTime() - System.currentTimeMillis();
        if (newDuration < 100L) {
            newDuration = 100L;
        }
        info.setDuration(newDuration);
        Timer timer = timerservice.createTimer(info.getDuration(), info.getPeriod(), info.getInfo());
        if (timer.getTimeRemaining() > 0L) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"timer restarted");
        } else {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"timer terminated");
            timer.cancel();
        }
        return timer;
    }

    private JTimerService getJTimerService(JTimerHandleInfo info) {
        JContainer cont = (JContainer)this.getContainer(info.getContainerId());
        if (cont == null) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)("Cannot get container =" + info.getContainerId()));
            throw new IllegalStateException("Cannot get container");
        }
        JFactory bf = (JFactory)cont.getBeanFactory(info.getBeanId());
        JTimerService timerservice = null;
        if (bf instanceof JEntityFactory) {
            JEntitySwitch es;
            Serializable pk = info.getPk();
            JEntityFactory ef = (JEntityFactory)bf;
            Serializable pks = ef.decodePK(pk);
            if (TraceTimer.isDebug()) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("encoded PK=" + pk));
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("decoded PK=" + pks));
            }
            if ((es = ef.getEJB((Object)pks)) == null) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"No entity for this pk");
                throw new NoSuchObjectLocalException("No entity for this pk");
            }
            timerservice = (JTimerService)es.getEntityTimerService();
        } else {
            timerservice = (JTimerService)bf.getTimerService();
        }
        if (timerservice == null) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Cannot retrieve TimerService");
            throw new IllegalStateException("Cannot retrieve TimerService");
        }
        return timerservice;
    }

    private void registerEjbServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.ejbService((String)domainName);
        this.jmxService.registerMBean(service, on);
    }

    private void unregisterEjbServiceMBean(String domainName) {
        ObjectName on = JonasObjectName.ejbService((String)domainName);
        this.jmxService.unregisterMBean(on);
    }

    private EJBModule registerEJBModuleMBean(String domainName, String serverName, String j2eeappName, String moduleName, JContainer container, String fileName, URL earUrl) {
        ObjectName ejbModuleOn = J2eeObjectName.getEJBModule((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
        EJBModule ejbModuleMBean = new EJBModule(ejbModuleOn, container, fileName, moduleName, j2eeappName, earUrl);
        try {
            this.jmxService.registerModelMBean((Object)ejbModuleMBean, ejbModuleOn);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register EJBModule MBean", (Throwable)e);
        }
        return ejbModuleMBean;
    }

    private String registerEntityBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JEntityFactory jef, String persist) {
        String entityBeanON = J2eeObjectName.getEntityBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        EntityBean entityBeanMBean = new EntityBean(entityBeanON, jef, persist, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)entityBeanMBean, entityBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register EntityBean MBean", (Throwable)e);
            return null;
        }
        return entityBeanON;
    }

    private String registerStatefulSessionBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JSessionFactory jsf) {
        String ssBeanON = J2eeObjectName.getStatefulSessionBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        StatefulSessionBean ssBeanMBean = new StatefulSessionBean(ssBeanON, jsf, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)ssBeanMBean, ssBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register StatefulSessionBean MBean for " + beanName), (Throwable)e);
            return null;
        }
        return ssBeanON;
    }

    private String registerStatelessSessionBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JStatelessFactory jsf) {
        String ssBeanON = J2eeObjectName.getStatelessSessionBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        StatelessSessionBean ssBeanMBean = new StatelessSessionBean(ssBeanON, jsf, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)ssBeanMBean, ssBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register StatelessSessionBean MBean" + beanName), (Throwable)e);
            return null;
        }
        return ssBeanON;
    }

    private String registerMdbBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JFactory jsf) {
        String mdbBeanON = J2eeObjectName.getMessageDrivenBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        MessageDrivenBean mdbBeanMBean = new MessageDrivenBean(mdbBeanON, jsf, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)mdbBeanMBean, mdbBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register MessageDrivenBean MBean" + beanName), (Throwable)e);
            return null;
        }
        return mdbBeanON;
    }

    private String registerCompMBeans(String domainName, String serverName, String j2eeappName, String moduleName, JContainer container, String fileName, URL earUrl, DeploymentDesc dd, Map factoryMap, Map beanDescMap) {
        EJBModule ejbModuleMBean = this.registerEJBModuleMBean(domainName, serverName, j2eeappName, moduleName, container, fileName, earUrl);
        String ejbModuleON = J2eeObjectName.getEJBModuleName((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
        ejbModuleMBean.setDeploymentDescriptor(dd.getXmlContent());
        ejbModuleMBean.setJonasDeploymentDescriptor(dd.getJOnASXmlContent());
        Iterator it = factoryMap.keySet().iterator();
        while (it.hasNext()) {
            String beanON = null;
            String beanName = (String)it.next();
            BeanFactory bf = (BeanFactory)factoryMap.get(beanName);
            BeanDesc beanDesc = (BeanDesc)beanDescMap.get(beanName);
            if (beanDesc instanceof EntityBmpDesc) {
                beanON = this.registerEntityBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JEntityFactory)bf, BMP);
            } else if (beanDesc instanceof EntityCmpDesc) {
                beanON = this.registerEntityBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JEntityFactory)bf, CMP);
            } else if (beanDesc instanceof SessionStatefulDesc) {
                beanON = this.registerStatefulSessionBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JSessionFactory)bf);
            } else if (beanDesc instanceof SessionStatelessDesc) {
                beanON = this.registerStatelessSessionBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JStatelessFactory)bf);
            } else if (beanDesc instanceof MessageDrivenDesc) {
                beanON = this.registerMdbBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JFactory)bf);
            }
            ejbModuleMBean.addEjb(beanON);
        }
        return ejbModuleON;
    }

    private void unregisterCompMBeans(String domainName, String serverName, String j2eeappName, String moduleName) {
        ObjectName onEjbModule = J2eeObjectName.getEJBModule((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
        MBeanServer mbeanServer = this.jmxService.getJmxServer();
        ObjectName onEjb = null;
        try {
            String[] onEjbs = (String[])mbeanServer.getAttribute(onEjbModule, "ejbs");
            for (int i = 0; i < onEjbs.length; ++i) {
                onEjb = new ObjectName(onEjbs[i]);
                this.jmxService.unregisterModelMBean(onEjb);
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Could not unregsiter MBean " + onEjb.toString()), (Throwable)e);
        }
        this.jmxService.unregisterModelMBean(onEjbModule);
    }

    private void callGenic(String jarPath, String[] genicArgs) {
        String[] args;
        if (genicArgs != null) {
            args = new String[genicArgs.length + 1];
            for (int i = 0; i < genicArgs.length; ++i) {
                args[i] = genicArgs[i];
            }
            args[genicArgs.length] = jarPath;
        } else {
            args = new String[]{jarPath};
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Calling GenIC with arguments :" + Arrays.asList(args)));
        }
        GenicServiceWrapper.callGenic((String[])args);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setWorkManagerService(WorkManagerService workManagerService) {
        this.workManagerService = workManagerService;
    }

    public void setWebServicesService(WebServicesService webServicesService) {
        this.wsService = webServicesService;
    }

    public void setNaming(JNamingManager naming) {
        this.naming = naming;
    }

    public void setComponentContextFactory(JComponentContextFactory componentContextFactory) {
        this.componentContextFactory = componentContextFactory;
    }

    public void setRegistry(RegistryService registry) {
        this.registryService = registry;
    }

    public void setHaService(HaService haService) {
        this.haService = haService;
    }

    public void setResourceService(ResourceService resService) {
        this.resService = resService;
    }

    public CmiService getCmiService() {
        return this.cmiService;
    }

    public void setCmiService(CmiService cmiService) {
        this.cmiService = cmiService;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }
}

