/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2004 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JTimerHandleDelegate.java 13396 2008-03-27 15:53:27Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ejb2.internal.delegate;

import javax.ejb.Timer;
import javax.naming.Context;
import javax.naming.NamingException;

import org.ow2.jonas.ejb2.EJBService;
import org.ow2.jonas.ejb2.JTimerHandleInfo;
import org.ow2.jonas.ejb2.TimerHandleDelegate;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactoryDelegate;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

/**
 * Implementation for TimerHandleDelegate
 * Must be added to JComponentContextFactory by addDelegate().
 * @author durieuxp
 */
public class JTimerHandleDelegate implements TimerHandleDelegate, JComponentContextFactoryDelegate {

    /**
     * Logger used for traces.
     */
    private static Logger logger = Log.getLogger(Log.JONAS_NAMING_PREFIX);

    /**
     * JNDI Binding name.
     */
    private static final String JNDI_NAME = "TimerHandleDelegate";

    private transient EJBService ejbService = null;

    public void setEJBService(EJBService ejbserv) {
        this.ejbService = ejbserv;
    }

    /**
     * Retrieve the Timer in the ejbService
     */
    public Timer getTimer(JTimerHandleInfo info) {
        if (ejbService == null) {
            logger.log(BasicLevel.ERROR, "EJBService not set");
            return null;
        }
        return ejbService.getTimer(info);
    }

    /**
     * Retrieve the Timer in the ejbService and restart it.
     */
    public Timer restartTimer(JTimerHandleInfo info) {
        if (ejbService == null) {
            logger.log(BasicLevel.ERROR, "EJBService not set");
            return null;
        }
        return ejbService.restartTimer(info);
    }

    /**
     * called back from ccf.addDelegate
     */
    public void modify(Context componentContext) throws NamingException {
        try {
            // Bind me as java:comp/TimerHandleDalegate
            componentContext.rebind(JNDI_NAME, this);
        } catch (NamingException ne) {
            // Just log the error, then rethrow the original Exception
            String err = "Cannot bind java:comp/TimerHandleDelegate object : " + ne.getMessage();
            logger.log(BasicLevel.ERROR, err);
            throw ne;
        }
    }

    /**
     * called back from ccf.removeDelegate
     */
    public void undo(Context componentContext) throws NamingException {
            componentContext.unbind(JNDI_NAME);
    }

}