/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: EJBModule.java 13396 2008-03-27 15:53:27Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ejb2.internal.mbean;

// JOnAS Management
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

import javax.management.ObjectName;

import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.management.javaee.J2EEModule;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;


/**
 * MBean class for EJBModule management
 *
 * @author  Adriana Danes JSR 77 (J2EE Management Standard)
 */
public class EJBModule extends J2EEModule {

    protected JContainer cont;

    // JSR 77
    private ArrayList ejbs = new ArrayList();

    // private attributes
    String containerName = null;
    String fileName = null;
    /**
     * J2EEApplication MBean OBJECT_NAME in ear case
     */
    private String earON = null;
    /**
     * URL of the ear
     */
    private URL earURL = null;

    /**
     * We are in ear case or not ?
     */
    private boolean inEarCase = false;


    public EJBModule(ObjectName objectName, JContainer cont, String fileName, String containerName, String j2eeAppName, URL earUrl) {
        super(objectName.toString());
        this.cont = cont;
        this.fileName = fileName;
        this.containerName = containerName;
        if (j2eeAppName != null && earUrl != null) {
            ObjectName j2eeAppOn = J2eeObjectName.J2EEApplication(
                    objectName.getDomain(),
                    objectName.getKeyProperty("J2EEServer"),
                    j2eeAppName);
            earON = j2eeAppOn.toString();
            this.earURL = earUrl;
            inEarCase = true;
        }
    }

    public String[] getEjbs() {
        return ((String[]) ejbs.toArray(new String[ejbs.size()]));
    }

    public void addEjb(String ejbObjectName) {
        ejbs.add(ejbObjectName);
    }

    public int getCurrentNumberOfEJB() {
        return ejbs.size();
    }

    public int getCurrentNumberOfBMP() {
        return cont.getEntityBMPNb();
    }

    public int getCurrentNumberOfCMP() {
        return cont.getEntityCMPNb();
    }

    public int getCurrentNumberOfSBF() {
        return cont.getStatefulSessionNb();
    }

    public int getCurrentNumberOfSBL() {
        return cont.getStatelessSessionNb();
    }

    public int getCurrentNumberOfMDB() {
        return cont.getMessageDrivenNb();
    }

    public String getContainerName() {
        return containerName;
    }

    public String getFileName() {
        return fileName;
    }

    public URL getUrl() {
        //TODO: URL should be given instead of fileName in the constructor.
        try {
            return new File(fileName).toURI().toURL();
        } catch (MalformedURLException e) {
            throw new RuntimeException("Cannot get URL for fileName '" + fileName + "'.", e);
        }
    }


    public String getEarON() {
        return earON;
    }

    public URL getEarURL() {
        return earURL;
    }

    public boolean isInEarCase() {
        return inEarCase;
    }

}
