/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb2.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.work.WorkManager;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.jonas.Version;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.EntityBmpDesc;
import org.ow2.jonas.deployment.ejb.EntityCmpDesc;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.SessionStatefulDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.deployment.ejb.lib.EjbDeploymentDescManager;
import org.ow2.jonas.ejb2.EJBService;
import org.ow2.jonas.ejb2.JTimerHandleInfo;
import org.ow2.jonas.ejb2.internal.EJB21Deployer;
import org.ow2.jonas.ejb2.internal.JOnASEJBServiceMBean;
import org.ow2.jonas.ejb2.internal.JarCleanTask;
import org.ow2.jonas.ejb2.internal.PrincipalFactoryImpl;
import org.ow2.jonas.ejb2.internal.mbean.EJBModule;
import org.ow2.jonas.ejb2.internal.mbean.EntityBean;
import org.ow2.jonas.ejb2.internal.mbean.MessageDrivenBean;
import org.ow2.jonas.ejb2.internal.mbean.StatefulSessionBean;
import org.ow2.jonas.ejb2.internal.mbean.StatelessSessionBean;
import org.ow2.jonas.generators.genic.wrapper.GenicServiceWrapper;
import org.ow2.jonas.generators.wsgen.wrapper.WsGenWrapper;
import org.ow2.jonas.ha.HaService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.ejb21.BeanFactory;
import org.ow2.jonas.lib.ejb21.Container;
import org.ow2.jonas.lib.ejb21.JContainer;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntitySwitch;
import org.ow2.jonas.lib.ejb21.JFactory;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JStatelessFactory;
import org.ow2.jonas.lib.ejb21.JTimerService;
import org.ow2.jonas.lib.ejb21.PermissionManager;
import org.ow2.jonas.lib.ejb21.PrincipalFactory;
import org.ow2.jonas.lib.ejb21.Protocols;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.lib.loader.EjbJarClassLoader;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.timer.TraceTimer;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.ModuleNamingUtils;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.security.SecurityService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionManager;
import org.ow2.jonas.tm.TransactionService;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.WorkCleanerService;
import org.ow2.jonas.workmanager.WorkManagerService;
import org.ow2.jonas.ws.WebServicesService;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASEJBService
extends AbsServiceImpl
implements EJBService,
JOnASEJBServiceMBean {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.ejb");
    private static Logger loaderlog = Log.getLogger((String)"org.ow2.jonas.loader");
    protected static final String WORK_DIR = JProp.getWorkDir();
    protected static final String WORK_EJBJARS_DIR = WORK_DIR + File.separator + "ejbjars";
    private static final int DEFAULT_WSGEN_SLEEP_TIME = 100;
    private static final int MINIMUM_TIMER_DURATION = 100;
    private TransactionManager tm = null;
    private JmxService jmxService = null;
    private SecurityService securityService = null;
    private WebServicesService wsService = null;
    private RegistryService registryService = null;
    private List<String> ejbNames = new Vector<String>();
    private Vector<JContainer> containers = new Vector();
    private WorkManager workManager;
    private boolean monitoringEnabled = false;
    private int warningThreshold = 0;
    public static final String BMP = "Bean-Managed";
    public static final String CMP = "Container-Managed";
    private ClassLoader extClassLoader = null;
    private DeployerLog deployerLog = null;
    private boolean autoGenIC = true;
    private List<String> autoGenICArgsList = new ArrayList<String>();
    private JComponentContextFactory componentContextFactory = null;
    private TransactionService transactionService;
    private WorkManagerService workManagerService;
    private JNamingManager naming;
    private EJB21Deployer ejb21Deployer = null;
    private CmiService cmiService = null;
    private HaService haService = null;
    private ResourceService resService = null;
    private IDeployerManager deployerManager;
    private File workEjbjarsFile;
    private VersioningService versioningService;
    private IEventService eventService;
    private static final String MONITORING_DISPATCHER_NAME = "/jonas/service/ejb2/monitoring";
    private static final String CONTAINER_LIFECYCLE_DISPATCHER_NAME = "/beans/lifecycle/events";
    private IEventDispatcher monitoringDispatcher;
    private IEventDispatcher containerLifecycleDispatcher;
    private Map<String, BeanMonitoringStatistics> beanMonitoringStatistics = new HashMap<String, BeanMonitoringStatistics>();
    static final int DATASOURCE = 1;
    static final int JMS_DESTINATION = 2;
    static final int JMS_FACTORY = 3;
    static final int MAIL_FACTORY = 4;

    public JOnASEJBService() {
        this.ejb21Deployer = new EJB21Deployer();
    }

    public void setAutoGenic(boolean autoGenIC) {
        this.autoGenIC = autoGenIC;
        if (!autoGenIC) {
            logger.log(BasicLevel.INFO, (Object)"Auto GenIC has been disabled");
        }
    }

    public void setParsingwithvalidation(boolean validate) {
        EjbDeploymentDescManager.setParsingWithValidation((boolean)validate);
        if (!validate && logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"XML parsing without validation");
        }
    }

    public void setAutoGenicArgs(String args) {
        this.autoGenICArgsList = JOnASEJBService.convertToList((String)args);
        if (!this.autoGenICArgsList.isEmpty()) {
            logger.log(BasicLevel.INFO, (Object)("Auto GenIC args are set to '" + this.autoGenICArgsList + "'."));
        }
    }

    public void doStart() throws ServiceException {
        this.initWorkingDirectory();
        this.tm = this.transactionService.getTransactionManager();
        this.workManager = this.workManagerService.getWorkManager();
        TraceTimer.configure((LoggerFactory)Log.getLoggerFactory());
        TraceEjb.configure((LoggerFactory)Log.getLoggerFactory());
        this.ejb21Deployer.setEjb21Service(this);
        this.deployerManager.register((IDeployer)this.ejb21Deployer);
        try {
            this.monitoringDispatcher = new EventDispatcher();
            this.monitoringDispatcher.start();
            this.eventService.registerDispatcher(MONITORING_DISPATCHER_NAME, this.monitoringDispatcher);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot create the EJB monitoring dispatcher", (Throwable)e);
        }
        if (this.containerLifecycleDispatcher == null) {
            try {
                this.containerLifecycleDispatcher = new EventDispatcher();
                this.containerLifecycleDispatcher.start();
                this.eventService.registerDispatcher(CONTAINER_LIFECYCLE_DISPATCHER_NAME, this.containerLifecycleDispatcher);
            }
            catch (Exception e) {
                throw new ServiceException("Cannot create the EJB Container lifecycle dispatcher", (Throwable)e);
            }
        }
        try {
            LoaderManager lm = LoaderManager.getInstance();
            this.extClassLoader = lm.getExternalLoader();
        }
        catch (Throwable e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot get the Applications ClassLoader from EJB Container Service");
            throw new ServiceException("Cannot get the Applications ClassLoader from EJB Container Service", e);
        }
        if (this.jmxService != null) {
            this.jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        }
        String fileName = null;
        ComponentContext contctx = null;
        for (int i = 0; i < this.ejbNames.size(); ++i) {
            fileName = this.ejbNames.get(i);
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("filename", (Object)fileName);
            }
            catch (NamingException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot bind filename '" + fileName + "' in component context"), (Throwable)e);
            }
            try {
                this.createContainer((Context)contctx);
                continue;
            }
            catch (Throwable e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot create container for " + fileName), e);
                try {
                    contctx.close();
                    continue;
                }
                catch (NamingException nne) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Cannot close deploy context for " + fileName), (Throwable)nne);
                }
            }
        }
        this.registerEjbServiceMBean(this, this.getDomainName());
        logger.log(BasicLevel.INFO, (Object)"EJB 2.1 Service started");
    }

    public void doStop() {
        if (this.deployerManager != null) {
            this.deployerManager.unregister((IDeployer)this.ejb21Deployer);
        }
        ArrayList<JContainer> containers = new ArrayList<JContainer>(this.containers);
        for (JContainer cont : containers) {
            this.removeContainer((Container)cont);
        }
        containers = null;
        try {
            this.eventService.unregisterDispatcher(MONITORING_DISPATCHER_NAME);
            this.monitoringDispatcher.stop();
            this.monitoringDispatcher = null;
        }
        catch (Exception e) {
            throw new ServiceException("Cannot screate the EJB monitoring dispatcher", (Throwable)e);
        }
        if (this.cmiService != null) {
            try {
                this.eventService.unregisterDispatcher(CONTAINER_LIFECYCLE_DISPATCHER_NAME);
                this.containerLifecycleDispatcher.stop();
                this.containerLifecycleDispatcher = null;
            }
            catch (Exception e) {
                throw new ServiceException("Cannot screate the EJB container lifecycle dispatcher", (Throwable)e);
            }
        }
        this.unregisterEjbServiceMBean(this.getDomainName());
        logger.log(BasicLevel.INFO, (Object)"EJB 2.1 Service stopped");
    }

    protected void initWorkingDirectory() {
        if (this.workEjbjarsFile == null) {
            this.workEjbjarsFile = new File(WORK_EJBJARS_DIR + File.separator + this.getServerProperties().getServerName());
            this.workEjbjarsFile.mkdirs();
        }
    }

    protected void setWorkCleanerService(WorkCleanerService workCleanerService) {
        this.initWorkingDirectory();
        File fileLog = new File(this.workEjbjarsFile.getPath() + File.separator + this.getServerProperties().getServerName() + ".log");
        if (!fileLog.exists()) {
            try {
                fileLog.createNewFile();
            }
            catch (IOException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create the log file " + fileLog), (Throwable)e);
            }
        }
        try {
            this.deployerLog = new DeployerLog(fileLog);
            JarCleanTask cleanTask = new JarCleanTask(this, this.deployerLog);
            workCleanerService.registerTask((CleanTask)cleanTask);
            workCleanerService.executeTasks();
        }
        catch (DeployerLogException e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot register the clean task", (Throwable)e);
        }
    }

    public String createContainer(Context ctx) throws Exception {
        IDeployable originalDeployable;
        IArchive archive;
        File earFile;
        String earFileName;
        String earRoot;
        URL earUrl;
        URLClassLoader earClassLoader;
        URLClassLoader ejbClassLoader;
        URL[] url;
        String workFileName;
        boolean isInEar;
        File originalFile;
        String originalFileName;
        block48: {
            originalFileName = (String)ctx.lookup("filename");
            originalFile = new File(originalFileName);
            boolean isEjbJar = originalFileName.toLowerCase().endsWith(".jar");
            boolean isEjbJarXml = originalFileName.toLowerCase().endsWith(".xml") && originalFile.isFile();
            try {
                originalFileName = originalFile.toURL().getPath();
            }
            catch (MalformedURLException e) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid ejb-jar file name '" + originalFileName + "'"), (Throwable)e);
            }
            if (originalFile.isFile() && !isEjbJar && !isEjbJarXml) {
                throw new ServiceException("The ejbjar to deploy is not a jar file nor an xml file");
            }
            if (this.getContainer(originalFileName) != null) {
                logger.log(BasicLevel.ERROR, (Object)("createContainer: " + originalFileName + " already exists"));
                throw new Exception("Container already exists");
            }
            isInEar = true;
            try {
                ctx.lookup("earClassLoader");
            }
            catch (NamingException ne) {
                isInEar = false;
            }
            workFileName = originalFileName;
            if (!isInEar && isEjbJar) {
                workFileName = FileUtils.lastModifiedFileName((File)originalFile);
                workFileName = WORK_EJBJARS_DIR + File.separator + this.getServerProperties().getServerName() + File.separator + workFileName;
                File workDirectory = new File(workFileName);
                workDirectory.mkdirs();
                if (!workDirectory.isDirectory()) {
                    throw new FileNotFoundException("Cannot create work folder : " + workFileName);
                }
                if (!new File(workFileName = workFileName + File.separator + originalFile.getName()).exists()) {
                    FileUtils.copyFile((String)originalFileName, (String)workFileName);
                }
                this.checkGenIC(workFileName, null);
                String resultFilename = this.applyWSGenIfNeeded(workFileName);
                if (resultFilename.endsWith(".ear")) {
                    return J2eeObjectName.getEJBModule((String)this.getDomainName(), (String)this.getJonasServerName(), (String)ModuleNamingUtils.fromFileName((String)resultFilename), (String)ModuleNamingUtils.fromFileName((String)originalFileName)).getCanonicalName();
                }
                try {
                    if (this.deployerLog != null) {
                        this.deployerLog.addEntry(originalFile, workDirectory);
                    }
                }
                catch (DeployerLogException e) {
                    String err = "Error while adding the " + originalFileName + " entry in the log file";
                    logger.log(BasicLevel.ERROR, (Object)(err + " : " + e.getMessage()));
                    throw new Exception(err, e);
                }
            }
            url = new URL[]{URLUtils.fileToURL((File)new File(workFileName))};
            ejbClassLoader = null;
            earClassLoader = null;
            try {
                earClassLoader = (URLClassLoader)ctx.lookup("earClassLoader");
                ejbClassLoader = (URLClassLoader)ctx.lookup("ejbClassLoader");
                if (loaderlog.isLoggable(BasicLevel.DEBUG)) {
                    loaderlog.log(BasicLevel.DEBUG, (Object)("earClassLoader=" + earClassLoader));
                }
            }
            catch (NamingException ne) {
                ejbClassLoader = isEjbJar ? new EjbJarClassLoader(url, this.extClassLoader) : (URLClassLoader)this.extClassLoader;
                if (!loaderlog.isLoggable(BasicLevel.DEBUG)) break block48;
                loaderlog.log(BasicLevel.DEBUG, (Object)("parent Loader=" + this.extClassLoader));
            }
        }
        if (loaderlog.isLoggable(BasicLevel.DEBUG)) {
            loaderlog.log(BasicLevel.DEBUG, (Object)("ejbClassLoader=" + ejbClassLoader));
        }
        DeploymentDesc dd = null;
        try {
            EjbDeploymentDescManager mgr = EjbDeploymentDescManager.getInstance();
            dd = mgr.getDeploymentDesc(url[0], (ClassLoader)ejbClassLoader, (ClassLoader)earClassLoader);
        }
        catch (DeploymentDescException e) {
            String err = "Cannot read the deployment descriptors '" + originalFileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            logger.log(BasicLevel.ERROR, (Object)("DeploymentDescException:" + (Object)((Object)e)));
            throw new ServiceException(err, (Throwable)e);
        }
        String cname = ModuleNamingUtils.fromFileName((String)originalFileName);
        if (cname == null) {
            cname = "EJB container ";
            if (dd.getDisplayName() != null) {
                cname = cname + dd.getDisplayName();
            }
        }
        JContainer cont = new JContainer(cname, originalFileName, workFileName, (ClassLoader)ejbClassLoader, dd, this.cmiService, this.haService, this.wsService, this.jmxService.getJmxServer(), this.resService);
        cont.setContainerNaming(this.naming);
        if (this.componentContextFactory == null) {
            logger.log(BasicLevel.ERROR, (Object)"componentContextFactory has not been set");
        }
        cont.setComponentContextFactory(this.componentContextFactory);
        cont.setTransactionManager(this.tm);
        cont.setPrincipalFactory((PrincipalFactory)new PrincipalFactoryImpl());
        try {
            earUrl = (URL)ctx.lookup("earURL");
            earRoot = (String)ctx.lookup("earRoot");
            earFileName = URLUtils.urlToFile((URL)earUrl).getPath();
            cont.setEarFileName(earFileName);
            earFile = new File(earRoot);
        }
        catch (NamingException ne) {
            earUrl = null;
            earRoot = null;
            earFile = null;
            earFileName = null;
        }
        if (earFile != null) {
            archive = ArchiveManager.getInstance().getArchive(earFile);
            originalDeployable = DeployableHelper.getDeployable((IArchive)archive);
        } else {
            archive = ArchiveManager.getInstance().getArchive((Object)originalFile);
            originalDeployable = DeployableHelper.getDeployable((IArchive)archive);
        }
        String prefix = null;
        if (this.isVersioningEnabled()) {
            prefix = this.versioningService.getPrefix(originalDeployable);
        }
        String javaEEApplicationName = null;
        try {
            javaEEApplicationName = (String)ctx.lookup("j2eeApplicationName");
        }
        catch (NamingException ne) {
            javaEEApplicationName = null;
        }
        cont.setJavaEEApplicationName(javaEEApplicationName);
        if (this.securityService == null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"EJB Container Service: working without Security Service");
            }
            cont.setSecurity(false);
        } else {
            PermissionManager permissionManager = null;
            try {
                permissionManager = new PermissionManager(dd, cont.getContextId());
                permissionManager.translateEjbDeploymentDescriptor();
                if (!isInEar) {
                    permissionManager.commit();
                }
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Can't build permission manager object for the ejbjar '" + originalFileName + "'"), (Throwable)e);
            }
            cont.setPermissionManager(permissionManager);
        }
        cont.setWorkManager(this.workManager);
        BeanDesc[] beans = dd.getBeanDesc();
        ArrayList<BeanFactory> bflist = new ArrayList<BeanFactory>();
        HashMap<String, BeanFactory> factoryMap = new HashMap<String, BeanFactory>();
        HashMap<String, BeanDesc> beanDescMap = new HashMap<String, BeanDesc>();
        for (BeanDesc beanDesc : beans) {
            String beanName = null;
            try {
                beanName = beanDesc.getEjbName();
                if (prefix != null) {
                    beanName = prefix + beanName;
                    beanDesc.setJndiName(prefix + beanDesc.getJndiName());
                    beanDesc.setJndiLocalName(prefix + beanDesc.getJndiLocalName());
                }
                cont.setLifeCycleDispatcher(this.containerLifecycleDispatcher);
                BeanFactory bf = cont.addBean(beanDesc);
                if (beanDesc instanceof SessionDesc) {
                    BeanMonitoringStatistics bms;
                    JSessionFactory jsf = (JSessionFactory)bf;
                    jsf.setDispatcher(this.monitoringDispatcher);
                    this.eventService.registerListener((IEventListener)jsf, MONITORING_DISPATCHER_NAME);
                    if (!jsf.getMonitoringSettingsDefinedInDD()) {
                        jsf.setMonitoringEnabled(this.monitoringEnabled);
                        jsf.setWarningThreshold(this.warningThreshold);
                    }
                    if ((bms = this.beanMonitoringStatistics.get(jsf.getEJBName())) != null) {
                        jsf.setNumberOfCalls(bms.getNumberOfCalls());
                        jsf.setTotalProcessingTime(bms.getTotalProcessingTime());
                        jsf.setTotalBusinessProcessingTime(bms.getTotalBusinessProcessingTime());
                    }
                }
                bflist.add(bf);
                factoryMap.put(beanName, bf);
                beanDescMap.put(beanName, beanDesc);
            }
            catch (Exception e) {
                logger.log(BasicLevel.WARN, (Object)("Can't deploy bean '" + beanName + "'"), (Throwable)e);
            }
        }
        for (BeanFactory bf : bflist) {
            bf.initInstancePool();
        }
        this.containers.addElement(cont);
        for (BeanFactory bf : bflist) {
            bf.restartTimers();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("created container for " + originalFileName));
        }
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String ejbModuleON = this.registerCompMBeans(domainName, serverName, javaEEApplicationName, cname, cont, originalFileName, earUrl, dd, factoryMap, beanDescMap);
        if (prefix != null) {
            if (earRoot != null) {
                this.versioningService.createJNDIBindingMBeans(originalDeployable);
            } else {
                this.versioningService.createJNDIBindingMBeans(originalDeployable);
            }
        }
        return ejbModuleON;
    }

    private String applyWSGenIfNeeded(String filename) throws DeployerException {
        String nfile;
        block10: {
            if (this.wsService == null) {
                logger.log(BasicLevel.DEBUG, (Object)"The WS service is not present, no need to call WSGen");
                return filename;
            }
            if (!this.wsService.isAutoWsGenEngaged()) {
                logger.log(BasicLevel.DEBUG, (Object)"Automatic WsGen is not enabled, no need to call WSGen");
                return filename;
            }
            String jonasVersionWsGen = JOnASEJBService.getAttributeInManifest(filename, "WsGen-JOnAS-Version");
            if (Version.getNumber().equals(jonasVersionWsGen)) {
                logger.log(BasicLevel.DEBUG, (Object)"No change: no need to call WSGen");
                return filename;
            }
            WsGenWrapper wsgen = new WsGenWrapper();
            nfile = null;
            try {
                nfile = wsgen.callWsGenExecute(filename, Boolean.valueOf(false));
                if (!wsgen.callWsGenIsInputModifed()) break block10;
                if (nfile.endsWith(".ear")) {
                    throw new DeployerException("WSGen has changed archive type from EJB-JAR to EAR. WSGen tool needs to be launched on your EJB-JAR '" + filename + "' before deploying it on JOnAS.");
                }
                logger.log(BasicLevel.DEBUG, (Object)("Archive updated, continuing deployment : " + nfile));
                try {
                    System.gc();
                    Thread.sleep(Long.getLong("jonas.wsgen.sleep", 100L));
                    if (!FileUtils.delete((String)filename)) {
                        throw new DeployerException("Cannot delete old application : " + filename);
                    }
                    FileUtils.copyFile((String)nfile, (String)filename);
                    FileUtils.delete((String)nfile);
                }
                catch (FileUtilsException e) {
                    throw new DeployerException("Cannot copy the jar from '" + nfile + "' to '" + filename + "'", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new DeployerException("Cannot sleep for the given time period", (Throwable)e);
                }
                return filename;
            }
            catch (Exception e) {
                throw new DeployerException("Cannot execute WSGen on '" + filename + "'", (Throwable)e);
            }
        }
        return nfile;
    }

    public Container getContainer(String fileName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)fileName);
        }
        File f = null;
        String pathFile = "";
        try {
            f = new File(fileName);
            pathFile = f.toURL().getPath();
        }
        catch (Exception e) {
            String err = "Error while trying to get canonical file '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            return null;
        }
        for (JContainer cont : this.containers) {
            String contName = cont.getExternalFileName();
            if (!contName.equals(pathFile)) continue;
            return cont;
        }
        return null;
    }

    public void removeContainer(Container cont) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)cont.getName());
        }
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String javaEEApplicationName = cont.getJavaEEApplicationName();
        String moduleName = cont.getName();
        String[] beans = cont.listBeanNames();
        for (int i = 0; i < beans.length; ++i) {
            String bean = beans[i];
            BeanFactory bf = cont.getBeanFactory(bean);
            if (!(bf instanceof JSessionFactory)) continue;
            JSessionFactory jsf = (JSessionFactory)bf;
            BeanMonitoringStatistics bms = new BeanMonitoringStatistics(jsf.getNumberOfCalls(), jsf.getTotalProcessingTime(), jsf.getTotalBusinessProcessingTime());
            this.beanMonitoringStatistics.put(jsf.getEJBName(), bms);
            this.monitoringDispatcher.removeListener((IEventListener)jsf);
        }
        this.unregisterCompMBeans(domainName, serverName, javaEEApplicationName, moduleName);
        cont.remove();
        this.containers.removeElement(cont);
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            this.versioningService.garbageCollectJNDIBindingMBeans();
        }
        Runtime.getRuntime().gc();
    }

    public Container[] listContainers() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("size= " + this.containers.size()));
        }
        Object[] ret = new Container[this.containers.size()];
        this.containers.copyInto(ret);
        return ret;
    }

    @Override
    public void syncAllEntities(boolean passivate) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        for (JContainer cont : this.containers) {
            cont.syncAll(true, passivate);
        }
    }

    @Override
    public Integer getCurrentNumberOfContainer() {
        return new Integer(this.containers.size());
    }

    @Override
    public Integer getTotalCurrentNumberOfBeanType() {
        int count = 0;
        for (JContainer cont : this.containers) {
            count += cont.getBeanNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfBMPType() {
        int count = 0;
        for (JContainer cont : this.containers) {
            count += cont.getEntityBMPNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfCMPType() {
        int count = 0;
        for (JContainer cont : this.containers) {
            count += cont.getEntityCMPNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfSBFType() {
        int count = 0;
        for (JContainer cont : this.containers) {
            count += cont.getStatefulSessionNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfSBLType() {
        int count = 0;
        for (JContainer cont : this.containers) {
            count += cont.getStatelessSessionNb();
        }
        return new Integer(count);
    }

    @Override
    public Integer getTotalCurrentNumberOfMDBType() {
        int count = 0;
        for (JContainer cont : this.containers) {
            count += cont.getMessageDrivenNb();
        }
        return new Integer(count);
    }

    @Override
    public List<String> getDeployedJars() {
        ArrayList<String> al = new ArrayList<String>();
        for (JContainer oContainer : this.containers) {
            try {
                al.add(new File(oContainer.getExternalFileName()).toURL().getPath());
            }
            catch (Exception e) {}
        }
        return al;
    }

    public void removeContainer(String fileName) throws Exception {
        Container cont = null;
        try {
            cont = this.getContainer(fileName);
        }
        catch (Exception e) {
            String err = "Error while trying to find file '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new Exception(err, e);
        }
        if (cont == null) {
            String err = "Cannot remove the non-existant container '" + fileName + "'";
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new Exception(err);
        }
        this.removeContainer(cont, false);
    }

    public String createContainer(String fileName) throws Exception {
        String ejbModuleObjectName = null;
        try {
            ComponentContext contctx = new ComponentContext(fileName);
            contctx.rebind("filename", (Object)fileName);
            ejbModuleObjectName = this.createContainer((Context)contctx);
        }
        catch (Exception e) {
            throw new Exception("Cannot create Container", e);
        }
        return ejbModuleObjectName;
    }

    public Boolean isJarDeployed(String fileName) {
        return new Boolean(this.isJarLoaded(fileName));
    }

    public boolean isJarDeployedByWorkName(String workFileName) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)workFileName);
        }
        for (JContainer cont : this.containers) {
            String contName = new File(cont.getFileName()).getName();
            if (!contName.equals(workFileName)) continue;
            return true;
        }
        return false;
    }

    Set<ObjectName> getDependence(String name, int type) {
        Set<ObjectName> resultObjectName = new HashSet<ObjectName>();
        HashSet<Properties> resultProperties = new HashSet<Properties>();
        try {
            InitialContext ctx = new InitialContext();
            ctx.lookup(name);
            ctx.close();
            for (JContainer cont : this.containers) {
                Set depProps = null;
                switch (type) {
                    case 1: {
                        depProps = cont.getDataSourceDependence(name);
                        break;
                    }
                    case 2: {
                        depProps = cont.getJmsDestinationDependence(name);
                        break;
                    }
                    case 3: {
                        depProps = cont.getJmsConnectionFactoryDependence(name);
                        break;
                    }
                    case 4: {
                        depProps = cont.getMailFactoryDependence(name);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type : " + type);
                    }
                }
                resultProperties.addAll(depProps);
                try {
                    resultObjectName = this.convertToObjectNames(resultProperties);
                }
                catch (Exception e) {
                    logger.log(BasicLevel.ERROR, (Object)"EjbServiceImpl: Object Name Error", (Throwable)e);
                }
            }
        }
        catch (NamingException ne) {
            resultObjectName = new HashSet();
        }
        return resultObjectName;
    }

    private Set<ObjectName> convertToObjectNames(Set<Properties> resultProperties) {
        HashSet<ObjectName> resultObjectName = new HashSet<ObjectName>();
        String domainName = this.getDomainName();
        String serverName = this.getJonasServerName();
        String ejbType = null;
        String ejbName = null;
        String earFileName = null;
        String moduleName = null;
        String j2eeAppName = null;
        for (Properties item : resultProperties) {
            ObjectName ejbObjectName = null;
            ejbType = item.getProperty("type");
            ejbName = item.getProperty("name");
            earFileName = item.getProperty("earFileName");
            moduleName = item.getProperty("cname");
            if (earFileName != null) {
                j2eeAppName = ModuleNamingUtils.fromFileName((String)earFileName);
            }
            if (ejbType.equals("ejbbmp") || ejbType.equals("ejbcmp")) {
                ejbObjectName = J2eeObjectName.getEntityBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbsbf")) {
                ejbObjectName = J2eeObjectName.getStatefulSessionBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbsbl")) {
                ejbObjectName = J2eeObjectName.getStatelessSessionBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            } else if (ejbType.equals("ejbmdb")) {
                ejbObjectName = J2eeObjectName.getMessageDrivenBean((String)domainName, (String)moduleName, (String)serverName, (String)j2eeAppName, (String)ejbName);
            }
            if (ejbObjectName == null) continue;
            resultObjectName.add(ejbObjectName);
        }
        return resultObjectName;
    }

    @Override
    public Set<ObjectName> getDataSourceDependence(String dsName) {
        return this.getDependence(dsName, 1);
    }

    @Override
    public Set<ObjectName> getJmsDestinationDependence(String destName) {
        return this.getDependence(destName, 2);
    }

    @Override
    public Set<ObjectName> getJmsConnectionFactoryDependence(String cfName) {
        return this.getDependence(cfName, 3);
    }

    @Override
    public Set<ObjectName> getMailFactoryDependence(String mfName) {
        return this.getDependence(mfName, 4);
    }

    public void deployJars(Context ctx) throws ServiceException {
        URL earRootUrl = null;
        URL earUrl = null;
        ClassLoader earClassLoader = null;
        ClassLoader ejbClassLoader = null;
        URL[] jarURLs = null;
        String[] roleNames = null;
        String j2eeApplicationName = null;
        try {
            earRootUrl = (URL)ctx.lookup("earRootUrl");
            earUrl = (URL)ctx.lookup("earUrl");
            earClassLoader = (ClassLoader)ctx.lookup("earClassLoader");
            ejbClassLoader = (ClassLoader)ctx.lookup("ejbClassLoader");
            jarURLs = (URL[])ctx.lookup("jarURLs");
            j2eeApplicationName = (String)ctx.lookup("j2eeApplicationName");
            roleNames = (String[])ctx.lookup("roleNames");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param :" + e.getMessage();
            logger.log(BasicLevel.ERROR, (Object)err);
            throw new ServiceException(err, (Throwable)e);
        }
        for (int i = 0; i < jarURLs.length; ++i) {
            String fileName = URLUtils.urlToFile((URL)jarURLs[i]).getPath();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Deploy '" + fileName + "' for the ear service."));
            }
            ComponentContext contctx = null;
            try {
                contctx = new ComponentContext(fileName);
                contctx.rebind("filename", (Object)fileName);
                contctx.rebind("earClassLoader", (Object)earClassLoader);
                contctx.rebind("ejbClassLoader", (Object)ejbClassLoader);
                contctx.rebind("earRoot", (Object)URLUtils.urlToFile((URL)earRootUrl).getPath());
                contctx.rebind("earURL", (Object)earUrl);
                contctx.rebind("j2eeApplicationName", (Object)j2eeApplicationName);
                contctx.rebind("roleNames", (Object)roleNames);
                this.createContainer((Context)contctx);
                continue;
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Error when deploying '" + fileName + "'"), (Throwable)e);
                logger.log(BasicLevel.ERROR, (Object)"Undeploy ejb-jar of the ear application");
                for (int j = 0; j <= i; ++j) {
                    Container cont = this.getContainer(URLUtils.urlToFile((URL)jarURLs[j]).getPath());
                    if (cont != null) {
                        this.removeContainer(cont, true);
                        continue;
                    }
                    logger.log(BasicLevel.ERROR, (Object)("Cannot remove the non-existant container '" + fileName + "'"));
                }
                throw new ServiceException("Error during the deployment", (Throwable)e);
            }
        }
    }

    public void unDeployJars(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String fileName = URLUtils.urlToFile((URL)urls[i]).getPath();
            Container cont = this.getContainer(fileName);
            if (cont != null) {
                this.removeContainer(cont, true);
                continue;
            }
            logger.log(BasicLevel.ERROR, (Object)("Cannot remove the non-existant container '" + fileName + "'"));
        }
    }

    public void removeContainer(Container cont, boolean isEarCase) {
        if (isEarCase == (cont.getEarFileName() != null)) {
            this.removeContainer(cont);
        } else {
            String err = "Cannot remove container '" + cont.getName() + "' it is in an ear application. You must undeploy the ear associated.";
            logger.log(BasicLevel.ERROR, (Object)err);
        }
    }

    public void removeCache(ClassLoader earClassLoader) {
        EjbDeploymentDescManager mgr = EjbDeploymentDescManager.getInstance();
        mgr.removeCache(earClassLoader);
    }

    @Override
    public boolean isJarLoaded(String fileName) {
        return this.getContainer(fileName) != null;
    }

    private static boolean checkCurrentProtocolIncludeIntoGenerated(String listProtocolGenerated, String listCurrentProtocol) {
        Protocols generated = new Protocols(listProtocolGenerated);
        Protocols current = new Protocols(listCurrentProtocol);
        return generated.isSupported(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAttributeInManifest(String jarName, String attributName) {
        ZipFile jar = null;
        try {
            File jarFile = new File(jarName);
            jar = new JarFile(jarFile);
            Manifest man = ((JarFile)jar).getManifest();
            Attributes atts = man.getMainAttributes();
            String string = atts.getValue(attributName);
            return string;
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot read Manifest: " + e));
            String string = null;
            return string;
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot close the Jar File: " + e));
            }
        }
    }

    public void checkGenIC(String fileName, URL[] urls) {
        if (!this.autoGenIC) {
            return;
        }
        List protocols = this.registryService.getActiveProtocolNames();
        String[] genicArgsString = null;
        int argIndex = 0;
        if (urls != null && urls.length > 0) {
            genicArgsString = new String[4 + this.autoGenICArgsList.size()];
            StringBuffer classpath = new StringBuffer();
            for (int i = 0; i < urls.length; ++i) {
                classpath.append(urls[i].getPath());
                if (i == urls.length - 1) continue;
                classpath.append(File.pathSeparator);
            }
            genicArgsString[argIndex++] = "-classpath";
            genicArgsString[argIndex++] = classpath.toString();
        } else {
            genicArgsString = new String[2 + this.autoGenICArgsList.size()];
        }
        genicArgsString[argIndex++] = "-protocols";
        String listProtocols = "";
        Iterator i = protocols.iterator();
        while (i.hasNext()) {
            String protocol = (String)i.next();
            listProtocols = listProtocols + protocol;
            if (!i.hasNext()) continue;
            listProtocols = listProtocols + ",";
        }
        genicArgsString[argIndex++] = listProtocols;
        for (String argument : this.autoGenICArgsList) {
            genicArgsString[argIndex++] = argument;
        }
        String jonasVersionGenic = JOnASEJBService.getAttributeInManifest(fileName, "Genic-Jonas-Version");
        String listProtocolGenerated = JOnASEJBService.getAttributeInManifest(fileName, "Genic-Jonas-protocols");
        boolean isCurrentProtocolIncludeIntoGenerated = JOnASEJBService.checkCurrentProtocolIncludeIntoGenerated(listProtocolGenerated, listProtocols);
        if (jonasVersionGenic == null || !jonasVersionGenic.equals(Version.getNumber()) || !isCurrentProtocolIncludeIntoGenerated) {
            if (jonasVersionGenic == null) {
                logger.log(BasicLevel.INFO, (Object)("JOnAS version was not found in the '" + fileName + "' manifest file. Auto-generating container classes..."));
            } else if (!jonasVersionGenic.equals(Version.getNumber())) {
                logger.log(BasicLevel.INFO, (Object)("JOnAS version found in the '" + fileName + "' manifest file :" + jonasVersionGenic + " is different of the current JOnAS version : " + Version.getNumber() + ". Auto-generating container classes..."));
            } else if (!isCurrentProtocolIncludeIntoGenerated) {
                logger.log(BasicLevel.INFO, (Object)("Current Carol protocol is not included in the protocols found in the '" + fileName + "' manifest file. Auto-generating container classes..."));
            }
            try {
                this.callGenic(fileName, genicArgsString);
            }
            catch (ServiceException e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot apply GenIC on the file '" + fileName + "' with the args '" + Arrays.asList(genicArgsString) + "'."), (Throwable)e);
            }
        }
    }

    public String getContainerContextID(String containerFileName) {
        return this.getContainer(containerFileName).getContextId();
    }

    public Timer getTimer(JTimerHandleInfo info) {
        JTimerService timerservice = this.getJTimerService(info);
        Timer ret = timerservice.getTimerByTime(info.getDuration(), info.getPeriod(), info.getInfo());
        if (ret == null) {
            throw new NoSuchObjectLocalException("The Timer should have been canceled");
        }
        return ret;
    }

    public Timer restartTimer(JTimerHandleInfo info) {
        JTimerService timerservice = this.getJTimerService(info);
        long newDuration = info.getDuration() + info.getStartTime() - System.currentTimeMillis();
        if (newDuration < 100L) {
            newDuration = 100L;
        }
        info.setDuration(newDuration);
        Timer timer = timerservice.createTimer(info.getDuration(), info.getPeriod(), info.getInfo());
        if (timer.getTimeRemaining() > 0L) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"timer restarted");
        } else {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"timer terminated");
            timer.cancel();
        }
        return timer;
    }

    private JTimerService getJTimerService(JTimerHandleInfo info) {
        JContainer cont = (JContainer)this.getContainer(info.getContainerId());
        if (cont == null) {
            TraceTimer.logger.log(BasicLevel.ERROR, (Object)("Cannot get container =" + info.getContainerId()));
            throw new IllegalStateException("Cannot get container");
        }
        JFactory bf = (JFactory)cont.getBeanFactory(info.getBeanId());
        JTimerService timerservice = null;
        if (bf instanceof JEntityFactory) {
            JEntitySwitch es;
            Serializable pk = info.getPk();
            JEntityFactory ef = (JEntityFactory)bf;
            Serializable pks = ef.decodePK(pk);
            if (TraceTimer.isDebug()) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("encoded PK=" + pk));
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)("decoded PK=" + pks));
            }
            if ((es = ef.getEJB((Object)pks)) == null) {
                TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"No entity for this pk");
                throw new NoSuchObjectLocalException("No entity for this pk");
            }
            timerservice = (JTimerService)es.getEntityTimerService();
        } else {
            timerservice = (JTimerService)bf.getTimerService();
        }
        if (timerservice == null) {
            TraceTimer.logger.log(BasicLevel.DEBUG, (Object)"Cannot retrieve TimerService");
            throw new IllegalStateException("Cannot retrieve TimerService");
        }
        return timerservice;
    }

    private void registerEjbServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.ejbService((String)domainName);
        this.jmxService.registerMBean(service, on);
    }

    private void unregisterEjbServiceMBean(String domainName) {
        if (this.jmxService != null) {
            ObjectName on = JonasObjectName.ejbService((String)domainName);
            this.jmxService.unregisterMBean(on);
        }
    }

    private EJBModule registerEJBModuleMBean(String domainName, String serverName, String j2eeappName, String moduleName, JContainer container, String fileName, URL earUrl) {
        ObjectName ejbModuleOn = J2eeObjectName.getEJBModule((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
        EJBModule ejbModuleMBean = new EJBModule(this.jmxService.getJmxServer(), ejbModuleOn, container, fileName, moduleName, j2eeappName, earUrl);
        ejbModuleMBean.setServer(J2eeObjectName.J2EEServerName((String)domainName, (String)serverName));
        try {
            this.jmxService.registerModelMBean((Object)ejbModuleMBean, ejbModuleOn);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register EJBModule MBean", (Throwable)e);
        }
        return ejbModuleMBean;
    }

    private String registerEntityBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JEntityFactory jef, String persist) {
        String entityBeanON = J2eeObjectName.getEntityBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        EntityBean entityBeanMBean = new EntityBean(entityBeanON, jef, persist, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)entityBeanMBean, entityBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)"Could not register EntityBean MBean", (Throwable)e);
            return null;
        }
        return entityBeanON;
    }

    private String registerStatefulSessionBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JSessionFactory jsf) {
        String ssBeanON = J2eeObjectName.getStatefulSessionBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        StatefulSessionBean ssBeanMBean = new StatefulSessionBean(ssBeanON, jsf, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)ssBeanMBean, ssBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register StatefulSessionBean MBean for " + beanName), (Throwable)e);
            return null;
        }
        return ssBeanON;
    }

    private String registerStatelessSessionBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JStatelessFactory jsf) {
        String ssBeanON = J2eeObjectName.getStatelessSessionBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        StatelessSessionBean ssBeanMBean = new StatelessSessionBean(ssBeanON, jsf, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)ssBeanMBean, ssBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register StatelessSessionBean MBean" + beanName), (Throwable)e);
            return null;
        }
        return ssBeanON;
    }

    private String registerMdbBeanMBean(String domainName, String serverName, String j2eeappName, String moduleName, String beanName, JFactory jsf) {
        String mdbBeanON = J2eeObjectName.getMessageDrivenBeanName((String)domainName, (String)moduleName, (String)serverName, (String)j2eeappName, (String)beanName);
        MessageDrivenBean mdbBeanMBean = new MessageDrivenBean(mdbBeanON, jsf, this.jmxService);
        try {
            this.jmxService.registerModelMBean((Object)mdbBeanMBean, mdbBeanON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.WARN, (Object)("Could not register MessageDrivenBean MBean" + beanName), (Throwable)e);
            return null;
        }
        return mdbBeanON;
    }

    private String registerCompMBeans(String domainName, String serverName, String j2eeappName, String moduleName, JContainer container, String fileName, URL earUrl, DeploymentDesc dd, Map<String, BeanFactory> factoryMap, Map<String, BeanDesc> beanDescMap) {
        EJBModule ejbModuleMBean = this.registerEJBModuleMBean(domainName, serverName, j2eeappName, moduleName, container, fileName, earUrl);
        String ejbModuleON = J2eeObjectName.getEJBModuleName((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
        ejbModuleMBean.setDeploymentDescriptor(dd.getXmlContent());
        ejbModuleMBean.setJonasDeploymentDescriptor(dd.getJOnASXmlContent());
        for (String beanName : factoryMap.keySet()) {
            String beanON = null;
            BeanFactory bf = factoryMap.get(beanName);
            BeanDesc beanDesc = beanDescMap.get(beanName);
            if (beanDesc instanceof EntityBmpDesc) {
                beanON = this.registerEntityBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JEntityFactory)bf, BMP);
            } else if (beanDesc instanceof EntityCmpDesc) {
                beanON = this.registerEntityBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JEntityFactory)bf, CMP);
            } else if (beanDesc instanceof SessionStatefulDesc) {
                beanON = this.registerStatefulSessionBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JSessionFactory)bf);
            } else if (beanDesc instanceof SessionStatelessDesc) {
                beanON = this.registerStatelessSessionBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JStatelessFactory)bf);
            } else if (beanDesc instanceof MessageDrivenDesc) {
                beanON = this.registerMdbBeanMBean(domainName, serverName, j2eeappName, moduleName, beanName, (JFactory)bf);
            }
            ejbModuleMBean.addEjb(beanON);
        }
        return ejbModuleON;
    }

    private void unregisterCompMBeans(String domainName, String serverName, String j2eeappName, String moduleName) {
        if (this.jmxService != null) {
            ObjectName onEjbModule = J2eeObjectName.getEJBModule((String)domainName, (String)serverName, (String)j2eeappName, (String)moduleName);
            MBeanServer mbeanServer = this.jmxService.getJmxServer();
            ObjectName onEjb = null;
            try {
                String[] onEjbs = (String[])mbeanServer.getAttribute(onEjbModule, "ejbs");
                for (int i = 0; i < onEjbs.length; ++i) {
                    onEjb = new ObjectName(onEjbs[i]);
                    this.jmxService.unregisterModelMBean(onEjb);
                }
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Could not unregister MBean " + onEjb.toString()), (Throwable)e);
            }
            this.jmxService.unregisterModelMBean(onEjbModule);
        }
    }

    private void callGenic(String jarPath, String[] genicArgs) {
        String[] args;
        if (genicArgs != null) {
            args = new String[genicArgs.length + 1];
            for (int i = 0; i < genicArgs.length; ++i) {
                args[i] = genicArgs[i];
            }
            args[genicArgs.length] = jarPath;
        } else {
            args = new String[]{jarPath};
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Calling GenIC with arguments :" + Arrays.asList(args)));
        }
        GenicServiceWrapper.callGenic((String[])args);
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setWorkManagerService(WorkManagerService workManagerService) {
        this.workManagerService = workManagerService;
    }

    public void setWebServicesService(WebServicesService webServicesService) {
        this.wsService = webServicesService;
    }

    public void setNaming(JNamingManager naming) {
        this.naming = naming;
    }

    public void setComponentContextFactory(JComponentContextFactory componentContextFactory) {
        this.componentContextFactory = componentContextFactory;
    }

    public void setRegistry(RegistryService registry) {
        this.registryService = registry;
    }

    public void setHaService(HaService haService) {
        this.haService = haService;
    }

    public void setResourceService(ResourceService resService) {
        this.resService = resService;
    }

    public CmiService getCmiService() {
        return this.cmiService;
    }

    public void setCmiService(CmiService cmiService) {
        this.cmiService = cmiService;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public boolean isVersioningEnabled() {
        return this.versioningService != null && this.versioningService.isVersioningEnabled();
    }

    @Override
    public boolean getMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    @Override
    public void setMonitoringEnabled(boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
    }

    @Override
    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    @Override
    public void setWarningThreshold(int warningThreshold) {
        if (warningThreshold < 0) {
            throw new IllegalArgumentException("warningThreshold must be positive or 0");
        }
        this.warningThreshold = warningThreshold;
    }

    @Override
    public int getNumberOfCalls() {
        int numberOfCalls = 0;
        try {
            for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                try {
                    numberOfCalls += ((Integer)this.jmxService.getJmxServer().getAttribute(on, "numberOfCalls")).intValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
            for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                try {
                    numberOfCalls += ((Integer)this.jmxService.getJmxServer().getAttribute(on, "numberOfCalls")).intValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'numberOfCalls'", (Throwable)e);
        }
        return numberOfCalls;
    }

    @Override
    public long getTotalProcessingTime() {
        long totalProcessingTime = 0L;
        try {
            for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                try {
                    totalProcessingTime += ((Long)this.jmxService.getJmxServer().getAttribute(on, "totalProcessingTime")).longValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
            for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                try {
                    totalProcessingTime += ((Long)this.jmxService.getJmxServer().getAttribute(on, "totalProcessingTime")).longValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'totalProcessingTime'", (Throwable)e);
        }
        return totalProcessingTime;
    }

    @Override
    public long getTotalBusinessProcessingTime() {
        long totalBusinessProcessingTime = 0L;
        try {
            for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                try {
                    totalBusinessProcessingTime += ((Long)this.jmxService.getJmxServer().getAttribute(on, "totalBusinessProcessingTime")).longValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
            for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                try {
                    totalBusinessProcessingTime += ((Long)this.jmxService.getJmxServer().getAttribute(on, "totalBusinessProcessingTime")).longValue();
                }
                catch (AttributeNotFoundException ignored) {}
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"Failed getting attribute 'totalBusinessProcessingTime'", (Throwable)e);
        }
        return totalBusinessProcessingTime;
    }

    @Override
    public long getAverageProcessingTime() {
        if (this.getNumberOfCalls() > 0) {
            return this.getTotalProcessingTime() / (long)this.getNumberOfCalls();
        }
        return 0L;
    }

    @Override
    public long getAverageBusinessProcessingTime() {
        if (this.getNumberOfCalls() > 0) {
            return this.getTotalBusinessProcessingTime() / (long)this.getNumberOfCalls();
        }
        return 0L;
    }

    @Override
    public void applyMonitorSettings(String scope) {
        Attribute monitoringEnabled = new Attribute("monitoringEnabled", new Boolean(this.monitoringEnabled));
        Attribute warningThreshold = new Attribute("warningThreshold", new Integer(this.warningThreshold));
        try {
            if ("all".equals(scope)) {
                for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                    this.jmxService.getJmxServer().setAttribute(on, monitoringEnabled);
                    this.jmxService.getJmxServer().setAttribute(on, warningThreshold);
                }
                for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                    this.jmxService.getJmxServer().setAttribute(on, monitoringEnabled);
                    this.jmxService.getJmxServer().setAttribute(on, warningThreshold);
                }
            } else if ("nonDD".equals(scope)) {
                for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatefulSessionBean,*"), null)) {
                    try {
                        if (((Boolean)this.jmxService.getJmxServer().getAttribute(on, "monitoringSettingsDefinedInDD")).booleanValue()) continue;
                        this.jmxService.getJmxServer().setAttribute(on, monitoringEnabled);
                        this.jmxService.getJmxServer().setAttribute(on, warningThreshold);
                    }
                    catch (AttributeNotFoundException ignored) {}
                }
                for (ObjectName on : this.jmxService.getJmxServer().queryNames(new ObjectName(this.getDomainName() + ":j2eeType=StatelessSessionBean,*"), null)) {
                    try {
                        if (((Boolean)this.jmxService.getJmxServer().getAttribute(on, "monitoringSettingsDefinedInDD")).booleanValue()) continue;
                        this.jmxService.getJmxServer().setAttribute(on, monitoringEnabled);
                        this.jmxService.getJmxServer().setAttribute(on, warningThreshold);
                    }
                    catch (AttributeNotFoundException ignored) {}
                }
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)("Cannot apply monitor settings: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setEventService(IEventService eventService) {
        this.eventService = eventService;
    }

    public IEventService getEventService() {
        return this.eventService;
    }

    private class BeanMonitoringStatistics {
        private int numberOfCalls;
        private long totalProcessingTime;
        private long totalBusinessProcessingTime;

        public BeanMonitoringStatistics(int numberOfCalls, long totalProcessingTime, long totalBusinessProcessingTime) {
            this.numberOfCalls = numberOfCalls;
            this.totalProcessingTime = totalProcessingTime;
            this.totalBusinessProcessingTime = totalBusinessProcessingTime;
        }

        public int getNumberOfCalls() {
            return this.numberOfCalls;
        }

        public long getTotalProcessingTime() {
            return this.totalProcessingTime;
        }

        public long getTotalBusinessProcessingTime() {
            return this.totalBusinessProcessingTime;
        }
    }
}

