/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.net.URL;
import javax.naming.Context;
import org.objectweb.jonas.service.AbsServiceImpl;
import org.objectweb.jonas.service.ServiceException;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.naming.interceptors.ENCManager;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.server.EmbeddedConfigurator;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.easybeans.server.ServerConfig;
import org.ow2.jonas.deployer.DeployerManagerService;
import org.ow2.jonas.ejb.easybeans.EasyBeansDeployer;
import org.ow2.jonas.ejb.easybeans.JOnASENCInterceptor;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class EasyBeansService
extends AbsServiceImpl {
    public static final String EASYBEANS_CONFIG_FILE = "easybeans-jonas.xml";
    private static Log logger = LogFactory.getLog(EasyBeansService.class);
    private URL xmlConfigurationURL = null;
    private Embedded embedded = null;
    private EasyBeansDeployer easyBeansDeployer = null;

    protected void doInit(Context ctx) throws ServiceException {
        ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
        logger.debug((Object)"Using ''{0}'' as classloader to load the resource named ''{1}''", new Object[]{threadCL, EASYBEANS_CONFIG_FILE});
        this.xmlConfigurationURL = threadCL.getResource(EASYBEANS_CONFIG_FILE);
        if (this.xmlConfigurationURL == null) {
            throw new ServiceException("The configuration file 'easybeans-jonas.xml' was not found in the classloader");
        }
        ENCManager.setInterceptorClass(JOnASENCInterceptor.class);
    }

    protected void doStart() throws ServiceException {
        try {
            this.embedded = EmbeddedConfigurator.create((URL)this.xmlConfigurationURL);
        }
        catch (EmbeddedException e) {
            throw new ServiceException("Cannot create the EasyBeans server", (Throwable)e);
        }
        ServerConfig serverConfig = this.embedded.getServerConfig();
        serverConfig.setShouldWait(false);
        serverConfig.setUseMBeans(true);
        serverConfig.setUseNaming(false);
        serverConfig.setInitJACC(false);
        serverConfig.setDirectoryScanningEnabled(false);
        serverConfig.setStartJMXConnector(false);
        try {
            this.embedded.start();
        }
        catch (EmbeddedException e) {
            throw new ServiceException("Cannot start the EasyBeans Server", (Throwable)e);
        }
        this.easyBeansDeployer = new EasyBeansDeployer();
        this.easyBeansDeployer.setEmbedded(this.embedded);
        DeployerManagerService.register((IDeployer)this.easyBeansDeployer);
    }

    protected void doStop() throws ServiceException {
        DeployerManagerService.unregister((IDeployer)this.easyBeansDeployer);
        if (this.embedded != null) {
            try {
                this.embedded.stop();
            }
            catch (EmbeddedException e) {
                throw new ServiceException("Cannot stop the EasyBeans component", (Throwable)e);
            }
        }
    }

    public EZBServer getEasyBeansServer() {
        return this.embedded;
    }
}

