/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.util.Map;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.server.Embedded;
import org.ow2.util.ee.deploy.api.archive.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(EasyBeansDeployer.class);
    private Embedded easybeansServer = null;

    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EJB3Deployable) {
            this.deployEJB3((EJB3Deployable)deployable);
        }
    }

    protected void deployEJB3(EJB3Deployable ejb3Deployable) throws DeployerException {
        this.logger.info((Object)"Deploying ''{0}''...", new Object[]{ejb3Deployable});
        EZBContainer container = this.easybeansServer.createContainer(ejb3Deployable.getArchive());
        try {
            container.start();
        }
        catch (EZBContainerException e) {
            this.easybeansServer.removeContainer(container);
            throw new DeployerException("Cannot deploy the given EJB '" + ejb3Deployable + "'.", (Throwable)e);
        }
        this.logger.info((Object)"''{0}'' EJB3 Deployable is now deployed", new Object[]{ejb3Deployable});
    }

    protected void undeployEJB3(EJB3Deployable ejb3Deployable) throws DeployerException {
        this.logger.info((Object)"Undeploying ''{0}''...", new Object[]{ejb3Deployable});
        IArchive archive = ejb3Deployable.getArchive();
        Map containers = this.easybeansServer.getContainers();
        EZBContainer foundContainer = null;
        for (EZBContainer container : containers.values()) {
            IArchive foundArchive = container.getArchive();
            if (!archive.equals(foundArchive)) continue;
            foundContainer = container;
            this.logger.debug((Object)"Found a matching container ''{0}'' for the archive ''{1}''", new Object[]{foundContainer, archive});
            break;
        }
        if (foundContainer == null) {
            throw new DeployerException("Cannot undeploy the deployable '" + ejb3Deployable + "' as this container is not deployed");
        }
        try {
            foundContainer.stop();
        }
        catch (Exception e) {
            throw new DeployerException("Cannot undeploy the deployable '" + ejb3Deployable + "'", (Throwable)e);
        }
        this.logger.info((Object)"''{0}'' EJB3 Deployable is now undeployed", new Object[]{ejb3Deployable});
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EJB3Deployable) {
            this.undeployEJB3((EJB3Deployable)deployable);
        }
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        throw new UnsupportedOperationException("IsDeployed not yet supported");
    }

    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof EJB3Deployable;
    }

    public void setEmbedded(Embedded easybeansServer) {
        this.easybeansServer = easybeansServer;
    }
}

