/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IEasyBeansService.java 12385 2007-12-13 23:10:24Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ejb.easybeans;

import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.jonas.service.Service;

/**
 * EZB Service interface.
 * @author Guillaume Sauthier
 */
public interface IEasyBeansService extends Service {

    /**
     * TODO Remove it when EarDeployer will use EasyBeans Deployer.
     * @return the Embedded instance used by this service.
     */
    EZBServer getEasyBeansServer();

    /**
     * Adds the given container.
     * @param ejbContainer
     */
    void addContainer(final EZBContainer ejbContainer);

    /**
     * Remove the given container.
     * @param ejbContainer the given container
     */
    void removeContainer(final EZBContainer ejbContainer);
}
