/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.container.mdb.helper.IResourceAdapterFinder;
import org.ow2.easybeans.container.mdb.helper.MDBResourceAdapterHelper;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.easybeans.naming.interceptors.ENCManager;
import org.ow2.easybeans.osgi.archive.BundleArchiveFactory;
import org.ow2.easybeans.osgi.extension.EasyBeansOSGiExtension;
import org.ow2.easybeans.security.api.EZBSecurityCurrent;
import org.ow2.easybeans.security.propagation.context.SecurityCurrent;
import org.ow2.easybeans.server.EasyBeansConfigurationExtension;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.server.EmbeddedConfigurator;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.ejb.easybeans.EasyBeansDeployer;
import org.ow2.jonas.ejb.easybeans.IEasyBeansService;
import org.ow2.jonas.ejb.easybeans.JOnASENCInterceptor;
import org.ow2.jonas.ejb.easybeans.JOnASResourceAdapterFinder;
import org.ow2.jonas.ejb.easybeans.JOnASSecurityCurrent;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.jmbeans.ServiceManagerUpdater;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.util.archive.api.IArchiveFactory;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

public class EasyBeansService
extends AbsServiceImpl
implements IEasyBeansService,
NotificationListener {
    public static final String EASYBEANS_CONFIG_FILE = "easybeans-jonas.xml";
    public static final String EASYBEANS_CLUSTER_CONFIG_FILE = "easybeans-cluster-jonas.xml";
    protected static final String JONAS_BASE = JProp.getJonasBase();
    private static Log logger = LogFactory.getLog(EasyBeansService.class);
    private URL xmlConfigurationURL = null;
    private URL cmiXMLConfigurationURL = null;
    private Embedded embedded = null;
    private EasyBeansDeployer easyBeansDeployer = null;
    private JmxService jmxService = null;
    private ServiceManagerUpdater serviceManagerUpdater = null;
    private ResourceService resourceService = null;
    private IDeployerManager deployerManager;
    private CmiService cmiService = null;
    private BundleContext bundleContext = null;
    private static JNamingManager namingManager = null;
    private ServiceRegistration embeddedServiceRegistration = null;
    private BundleArchiveFactory bundleArchiveFactory = null;

    public EasyBeansService() {
    }

    public EasyBeansService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected void doStart() throws ServiceException {
        MBeansHelper.setDomainName((String)this.jmxService.getDomainName());
        MBeansHelper.setServerName((String)this.jmxService.getJonasServerName());
        File configurationFile = new File(JONAS_BASE + File.separator + "conf" + File.separator + EASYBEANS_CONFIG_FILE);
        if (!configurationFile.exists()) {
            throw new ServiceException("The configuration file '" + configurationFile + "' was not found in the classloader");
        }
        this.xmlConfigurationURL = URLUtils.fileToURL((File)configurationFile);
        if (this.cmiService != null && this.cmiService.isStarted()) {
            this.cmiXMLConfigurationURL = this.bundleContext.getBundle().getResource(EASYBEANS_CLUSTER_CONFIG_FILE);
            if (this.cmiXMLConfigurationURL == null) {
                throw new ServiceException("The configuration file 'easybeans-cluster-jonas.xml' was not found in the classloader");
            }
        }
        JOnASResourceAdapterFinder resourceAdapterFinder = new JOnASResourceAdapterFinder();
        resourceAdapterFinder.setEasyBeansService(this);
        try {
            MDBResourceAdapterHelper.setResourceAdapterFinder((IResourceAdapterFinder)resourceAdapterFinder);
            ENCManager.setInterceptorClass(JOnASENCInterceptor.class);
        }
        catch (IllegalStateException e) {
            logger.debug((Object)"Interceptor class may have already be initialized before", new Object[]{e});
        }
        try {
            SecurityCurrent.setSecurityCurrent((EZBSecurityCurrent)new JOnASSecurityCurrent());
        }
        catch (IllegalStateException e) {
            logger.debug((Object)"SecurityCurrent may have already be initialized before", new Object[]{e});
        }
        this.configureExtraDialects();
        IExecution<Void> startExec = new IExecution<Void>(){

            public Void execute() throws EmbeddedException {
                EasyBeansService.this.embedded = EmbeddedConfigurator.create((URL)EasyBeansService.this.xmlConfigurationURL);
                if (EasyBeansService.this.cmiXMLConfigurationURL != null) {
                    EmbeddedConfigurator.init((Embedded)EasyBeansService.this.embedded, (URL)EasyBeansService.this.cmiXMLConfigurationURL);
                }
                EasyBeansService.this.embedded.start();
                return null;
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            logger.error((Object)"Cannot start the EasyBeans server", new Object[]{startExecResult.getException()});
            throw new ServiceException("Cannot start the EasyBeans Server", (Throwable)startExecResult.getException());
        }
        if (this.bundleContext != null) {
            IExecution<Void> addOSGiExtension = new IExecution<Void>(){

                public Void execute() throws EmbeddedException {
                    EasyBeansOSGiExtension extension = new EasyBeansOSGiExtension();
                    extension.setBundleContext(EasyBeansService.this.bundleContext);
                    EasyBeansService.this.embedded.getServerConfig().addExtensionFactory((EasyBeansConfigurationExtension)extension);
                    ArchiveManager am = ArchiveManager.getInstance();
                    EasyBeansService.this.bundleArchiveFactory = new BundleArchiveFactory();
                    am.addFactory((IArchiveFactory)EasyBeansService.this.bundleArchiveFactory);
                    return null;
                }
            };
            ExecutionResult addOSGiExtensionResult = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)addOSGiExtension);
            if (addOSGiExtensionResult.hasException()) {
                logger.error((Object)"Cannot start the EasyBeans server", new Object[]{startExecResult.getException()});
                throw new ServiceException("Cannot start the EasyBeans Server", (Throwable)startExecResult.getException());
            }
        }
        try {
            ObjectName j2eeServerName = J2eeObjectName.J2EEServer((String)this.getDomainName(), (String)this.getJonasServerName());
            String serverState = (String)this.jmxService.getJmxServer().getAttribute(j2eeServerName, "state");
            if (serverState.equals("RUNNING")) {
                this.registerEmbeddedService();
            } else {
                this.jmxService.getJmxServer().addNotificationListener(j2eeServerName, this, null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.easyBeansDeployer = new EasyBeansDeployer();
        this.easyBeansDeployer.setEmbedded(this.embedded);
        this.easyBeansDeployer.setServerProperties(this.getServerProperties());
        this.deployerManager.register((IDeployer)this.easyBeansDeployer);
    }

    protected void doStop() throws ServiceException {
        if (this.deployerManager != null) {
            this.deployerManager.unregister((IDeployer)this.easyBeansDeployer);
        }
        if (this.bundleContext != null) {
            IExecution<Void> removeOSGiExtension = new IExecution<Void>(){

                public Void execute() throws EmbeddedException {
                    if (EasyBeansService.this.bundleArchiveFactory != null) {
                        ArchiveManager am = ArchiveManager.getInstance();
                        am.removeFactory((IArchiveFactory)EasyBeansService.this.bundleArchiveFactory);
                        EasyBeansService.this.bundleArchiveFactory = null;
                    }
                    if (EasyBeansService.this.embeddedServiceRegistration != null) {
                        EasyBeansService.this.embeddedServiceRegistration.unregister();
                        EasyBeansService.this.embeddedServiceRegistration = null;
                    }
                    return null;
                }
            };
            ExecutionResult removeOSGiExtensionResult = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)removeOSGiExtension);
            if (removeOSGiExtensionResult.hasException()) {
                throw new ServiceException("Cannot stop EasyBeans", (Throwable)removeOSGiExtensionResult.getException());
            }
        }
        if (this.embedded != null) {
            try {
                IExecution<Void> stopExec = new IExecution<Void>(){

                    public Void execute() throws EmbeddedException {
                        EasyBeansService.this.embedded.stop();
                        return null;
                    }
                };
                ExecutionResult stopExecResult = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)stopExec);
                if (stopExecResult.hasException()) {
                    throw new EmbeddedException((Throwable)stopExecResult.getException());
                }
            }
            catch (EmbeddedException e) {
                throw new ServiceException("Cannot stop the EasyBeans component", (Throwable)e);
            }
        }
    }

    protected void configureExtraDialects() {
        try {
            Class<?> hibernateDialectClass = Embedded.class.getClassLoader().loadClass("org.hibernate.dialect.DialectFactory");
            Field mapper = hibernateDialectClass.getDeclaredField("MAPPERS");
            mapper.setAccessible(true);
            Map map = null;
            map = (Map)mapper.get(null);
            Class<?> versionInsensitiveMapperClass = Embedded.class.getClassLoader().loadClass("org.hibernate.dialect.DialectFactory$VersionInsensitiveMapper");
            Constructor<?> c = versionInsensitiveMapperClass.getConstructor(String.class);
            Object dialect = c.newInstance("org.hibernate.dialect.Oracle9Dialect");
            map.put("Oracle9i Enterprise Edition", dialect);
            mapper.setAccessible(false);
        }
        catch (Exception e) {
            logger.debug((Object)"Cannot configure some dialects used by Hibernate", new Object[]{e});
        }
    }

    public EZBServer getEasyBeansServer() {
        return this.embedded;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public static JNamingManager getNamingManager() {
        return namingManager;
    }

    public void setNamingManager(JNamingManager naming) {
        namingManager = naming;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public ResourceService getResourceService() {
        return this.resourceService;
    }

    public void setCmiService(CmiService cmiService) {
        this.cmiService = cmiService;
    }

    public CmiService getCmiService() {
        return this.cmiService;
    }

    public void addContainer(EZBContainer ejbContainer) {
        this.embedded.addContainer(ejbContainer);
    }

    public void removeContainer(EZBContainer ejbContainer) {
        this.embedded.removeContainer(ejbContainer);
    }

    public void handleNotification(Notification notification, Object handback) {
        if (this.embeddedServiceRegistration == null && notification.getType().equals("j2ee.state.running")) {
            this.registerEmbeddedService();
        }
    }

    private void registerEmbeddedService() {
        this.embeddedServiceRegistration = this.bundleContext.registerService(Embedded.class.getName(), (Object)this.embedded, null);
    }

    public void setVersioningService(VersioningService versioningService) {
        this.easyBeansDeployer.setVersioningService(versioningService);
    }

    public void unsetVersioningService() {
        this.easyBeansDeployer.unsetVersioningService();
    }

    public VersioningService getVersioningService() {
        return this.easyBeansDeployer.getVersioningService();
    }

    public void setServiceManagerUpdater(ServiceManagerUpdater serviceManagerUpdater) {
        this.serviceManagerUpdater = serviceManagerUpdater;
    }
}

