/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.container.mdb.helper.IResourceAdapterFinder;
import org.ow2.easybeans.container.mdb.helper.MDBResourceAdapterHelper;
import org.ow2.easybeans.jmx.MBeansHelper;
import org.ow2.easybeans.naming.interceptors.ENCManager;
import org.ow2.easybeans.osgi.archive.BundleArchiveFactory;
import org.ow2.easybeans.osgi.extension.EasyBeansOSGiExtension;
import org.ow2.easybeans.security.api.EZBSecurityCurrent;
import org.ow2.easybeans.security.propagation.context.SecurityCurrent;
import org.ow2.easybeans.server.EasyBeansConfigurationExtension;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.server.EmbeddedConfigurator;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.jonas.cmi.CmiService;
import org.ow2.jonas.ejb.easybeans.EJB3CleanTask;
import org.ow2.jonas.ejb.easybeans.EasyBeansDeployer;
import org.ow2.jonas.ejb.easybeans.JOnASENCInterceptor;
import org.ow2.jonas.ejb.easybeans.JOnASResourceAdapterFinder;
import org.ow2.jonas.ejb.easybeans.JOnASSecurityCurrent;
import org.ow2.jonas.ejb3.IEasyBeansService;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.naming.JNamingManager;
import org.ow2.jonas.resource.ResourceService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.WorkCleanerService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchiveFactory;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

public class EasyBeansService
extends AbsServiceImpl
implements IEasyBeansService {
    public static final String EASYBEANS_CONFIG_FILE = "easybeans-jonas.xml";
    public static final String EASYBEANS_CLUSTER_CONFIG_FILE = "easybeans-cluster-jonas.xml";
    protected static final String JONAS_BASE = JProp.getJonasBase();
    protected static final String WORK_DIR = JProp.getWorkDir();
    protected static final String WORK_EJB3S_DIR = WORK_DIR + File.separator + "ejb3s";
    private static Log logger = LogFactory.getLog(EasyBeansService.class);
    private URL xmlConfigurationURL = null;
    private URL cmiXMLConfigurationURL = null;
    private Embedded embedded = null;
    private EasyBeansDeployer easyBeansDeployer = null;
    private JmxService jmxService = null;
    private File workEjb3sFile;
    private J2EEServerService j2eeServer = null;
    private ResourceService resourceService = null;
    private IDeployerManager deployerManager;
    private DeployerLog deployerLog = null;
    private CmiService cmiService = null;
    private BundleContext bundleContext = null;
    private static JNamingManager namingManager = null;
    private ServiceRegistration embeddedServiceRegistration = null;
    private BundleArchiveFactory bundleArchiveFactory = null;

    public EasyBeansService(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.easyBeansDeployer = new EasyBeansDeployer();
    }

    protected void doStart() throws ServiceException {
        this.initWorkingDirectory();
        MBeansHelper.setDomainName((String)this.jmxService.getDomainName());
        MBeansHelper.setServerName((String)this.jmxService.getJonasServerName());
        File configurationFile = new File(JONAS_BASE + File.separator + "conf" + File.separator + EASYBEANS_CONFIG_FILE);
        if (!configurationFile.exists()) {
            throw new ServiceException("The configuration file '" + configurationFile + "' was not found in the classloader");
        }
        this.xmlConfigurationURL = URLUtils.fileToURL((File)configurationFile);
        if (this.cmiService != null && this.cmiService.isStarted()) {
            this.cmiXMLConfigurationURL = this.bundleContext.getBundle().getResource(EASYBEANS_CLUSTER_CONFIG_FILE);
            if (this.cmiXMLConfigurationURL == null) {
                throw new ServiceException("The configuration file 'easybeans-cluster-jonas.xml' was not found in the classloader");
            }
        }
        JOnASResourceAdapterFinder resourceAdapterFinder = new JOnASResourceAdapterFinder();
        resourceAdapterFinder.setEasyBeansService(this);
        try {
            MDBResourceAdapterHelper.setResourceAdapterFinder((IResourceAdapterFinder)resourceAdapterFinder);
            ENCManager.setInterceptorClass(JOnASENCInterceptor.class);
        }
        catch (IllegalStateException e) {
            logger.debug((Object)"Interceptor class may have already be initialized before", new Object[]{e});
        }
        try {
            SecurityCurrent.setSecurityCurrent((EZBSecurityCurrent)new JOnASSecurityCurrent());
        }
        catch (IllegalStateException e) {
            logger.debug((Object)"SecurityCurrent may have already be initialized before", new Object[]{e});
        }
        this.configureExtraDialects();
        IExecution<Void> startExec = new IExecution<Void>(){

            public Void execute() throws EmbeddedException {
                EasyBeansService.this.embedded = EmbeddedConfigurator.create((URL)EasyBeansService.this.xmlConfigurationURL);
                if (EasyBeansService.this.cmiXMLConfigurationURL != null) {
                    EmbeddedConfigurator.init((Embedded)EasyBeansService.this.embedded, (URL)EasyBeansService.this.cmiXMLConfigurationURL);
                }
                EasyBeansService.this.embedded.start();
                return null;
            }
        };
        ExecutionResult startExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)startExec);
        if (startExecResult.hasException()) {
            logger.error((Object)"Cannot start the EasyBeans server", new Object[]{startExecResult.getException()});
            throw new ServiceException("Cannot start the EasyBeans Server", (Throwable)startExecResult.getException());
        }
        if (this.bundleContext != null) {
            IExecution<Void> addOSGiExtension = new IExecution<Void>(){

                public Void execute() throws EmbeddedException {
                    EasyBeansOSGiExtension extension = new EasyBeansOSGiExtension();
                    extension.setBundleContext(EasyBeansService.this.bundleContext);
                    EasyBeansService.this.embedded.getServerConfig().addExtensionFactory((EasyBeansConfigurationExtension)extension);
                    ArchiveManager am = ArchiveManager.getInstance();
                    EasyBeansService.this.bundleArchiveFactory = new BundleArchiveFactory();
                    am.addFactory((IArchiveFactory)EasyBeansService.this.bundleArchiveFactory);
                    return null;
                }
            };
            ExecutionResult addOSGiExtensionResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)addOSGiExtension);
            if (addOSGiExtensionResult.hasException()) {
                logger.error((Object)"Cannot start the EasyBeans server", new Object[]{startExecResult.getException()});
                throw new ServiceException("Cannot start the EasyBeans Server", (Throwable)startExecResult.getException());
            }
        }
        if (this.j2eeServer.isRunning()) {
            this.registerEmbeddedService();
        }
        this.easyBeansDeployer.setEmbedded(this.embedded);
        this.easyBeansDeployer.setServerProperties(this.getServerProperties());
        this.deployerManager.register((IDeployer)this.easyBeansDeployer);
    }

    protected void doStop() throws ServiceException {
        if (this.deployerManager != null) {
            this.deployerManager.unregister((IDeployer)this.easyBeansDeployer);
        }
        if (this.bundleContext != null) {
            IExecution<Void> removeOSGiExtension = new IExecution<Void>(){

                public Void execute() throws EmbeddedException {
                    if (EasyBeansService.this.bundleArchiveFactory != null) {
                        ArchiveManager am = ArchiveManager.getInstance();
                        am.removeFactory((IArchiveFactory)EasyBeansService.this.bundleArchiveFactory);
                        EasyBeansService.this.bundleArchiveFactory = null;
                    }
                    if (EasyBeansService.this.embeddedServiceRegistration != null) {
                        EasyBeansService.this.embeddedServiceRegistration.unregister();
                        EasyBeansService.this.embeddedServiceRegistration = null;
                    }
                    return null;
                }
            };
            ExecutionResult removeOSGiExtensionResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)removeOSGiExtension);
            if (removeOSGiExtensionResult.hasException()) {
                throw new ServiceException("Cannot stop EasyBeans", (Throwable)removeOSGiExtensionResult.getException());
            }
        }
        if (this.embedded != null) {
            try {
                IExecution<Void> stopExec = new IExecution<Void>(){

                    public Void execute() throws EmbeddedException {
                        EasyBeansService.this.embedded.stop();
                        return null;
                    }
                };
                ExecutionResult stopExecResult = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)stopExec);
                if (stopExecResult.hasException()) {
                    throw new EmbeddedException((Throwable)stopExecResult.getException());
                }
            }
            catch (EmbeddedException e) {
                throw new ServiceException("Cannot stop the EasyBeans component", (Throwable)e);
            }
        }
    }

    protected void configureExtraDialects() {
        try {
            Class<?> hibernateDialectClass = Embedded.class.getClassLoader().loadClass("org.hibernate.dialect.DialectFactory");
            Field mapper = hibernateDialectClass.getDeclaredField("MAPPERS");
            mapper.setAccessible(true);
            Map map = null;
            map = (Map)mapper.get(null);
            Class<?> versionInsensitiveMapperClass = Embedded.class.getClassLoader().loadClass("org.hibernate.dialect.DialectFactory$VersionInsensitiveMapper");
            Constructor<?> c = versionInsensitiveMapperClass.getConstructor(String.class);
            Object dialect = c.newInstance("org.hibernate.dialect.Oracle9Dialect");
            map.put("Oracle9i Enterprise Edition", dialect);
            mapper.setAccessible(false);
        }
        catch (Exception e) {
            logger.debug((Object)"Cannot configure some dialects used by Hibernate", new Object[]{e});
        }
    }

    public EZBServer getEasyBeansServer() {
        return this.embedded;
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public static JNamingManager getNamingManager() {
        return namingManager;
    }

    public void setNamingManager(JNamingManager naming) {
        namingManager = naming;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public ResourceService getResourceService() {
        return this.resourceService;
    }

    public void setCmiService(CmiService cmiService) {
        this.cmiService = cmiService;
    }

    public CmiService getCmiService() {
        return this.cmiService;
    }

    public void addContainer(EZBContainer ejbContainer) {
        this.embedded.addContainer(ejbContainer);
    }

    public void removeContainer(EZBContainer ejbContainer) {
        this.embedded.removeContainer(ejbContainer);
    }

    protected void initWorkingDirectory() {
        if (this.workEjb3sFile == null) {
            this.workEjb3sFile = new File(WORK_EJB3S_DIR + File.separator + this.getServerProperties().getServerName());
            this.workEjb3sFile.mkdirs();
        }
    }

    protected void setWorkCleanerService(WorkCleanerService workCleanerService) {
        this.initWorkingDirectory();
        File fileLog = new File(this.workEjb3sFile.getPath() + File.separator + this.getServerProperties().getServerName() + ".log");
        if (!fileLog.exists()) {
            try {
                fileLog.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)("Cannot create the log file " + fileLog), new Object[0]);
            }
        }
        try {
            this.deployerLog = new DeployerLog(fileLog);
            this.easyBeansDeployer.setDeployerLog(this.deployerLog);
            EJB3CleanTask cleanTask = new EJB3CleanTask(this, this.deployerLog);
            workCleanerService.registerTask((CleanTask)cleanTask);
            workCleanerService.executeTasks();
        }
        catch (DeployerLogException e) {
            logger.error((Object)"Cannot register the clean task", new Object[]{e});
        }
    }

    public boolean isEJB3DeployedByWorkName(String unpackName) {
        Map<URL, EJB3Deployable> ejb3s = this.easyBeansDeployer.getEJB3s();
        for (EJB3Deployable ejb3Deployable : ejb3s.values()) {
            try {
                File unpackedFile = URLUtils.urlToFile((URL)ejb3Deployable.getArchive().getURL());
                if (!unpackName.equals(unpackedFile.getName())) continue;
                return true;
            }
            catch (ArchiveException e) {
                logger.debug((Object)"Cannot retrieve the name of the unpacked ear {0}", new Object[]{unpackName});
            }
        }
        return false;
    }

    public void registerEmbeddedService() {
        if (this.embeddedServiceRegistration == null) {
            this.embeddedServiceRegistration = this.bundleContext.registerService(Embedded.class.getName(), (Object)this.embedded, null);
        }
    }

    public void setVersioningService(VersioningService versioningService) {
        this.easyBeansDeployer.setVersioningService(versioningService);
    }

    public void unsetVersioningService() {
        this.easyBeansDeployer.unsetVersioningService();
    }

    public VersioningService getVersioningService() {
        return this.easyBeansDeployer.getVersioningService();
    }

    public void setJ2EEServer(J2EEServerService j2eeServer) {
        this.j2eeServer = j2eeServer;
    }
}

