/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: PrefixedNamingStrategy.java 13830 2008-04-22 13:56:31Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.ejb.easybeans;

import org.ow2.easybeans.api.bean.info.EZBBeanNamingInfo;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;

/**
 * JNDI naming strategy with prefixes. In this strategy, the JNDI name is
 * rewritten by adding a prefix in front of it.
 *
 * @author S. Ali Tokmen
 */
public class PrefixedNamingStrategy implements EZBNamingStrategy {
    /**
     * JNDI prefix.
     */
    private String prefix;

    /**
     * Old naming strategy.
     */
    private EZBNamingStrategy oldNamingStrategy;

    /**
     * Saves the arguments.
     *
     * @param prefix JNDI prefix.
     * @param oldNamingStrategy Old naming strategy.
     */
    public PrefixedNamingStrategy(final String prefix, final EZBNamingStrategy oldNamingStrategy) {
        this.prefix = prefix;
        this.oldNamingStrategy = oldNamingStrategy;
    }

    /**
     * Returns the prefixed JNDI name.
     *
     * @param info Bean naming information.
     *
     * @return Prefixed JNDI name.
     */
    public String getJNDIName(final EZBBeanNamingInfo info) {
        String oldName = this.oldNamingStrategy.getJNDIName(info);
        if (prefix == null) {
            return oldName;
        }
        return prefix + oldName;
    }
}
