/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.server.Embedded;
import org.ow2.jonas.ejb.easybeans.PrefixedNamingStrategy;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.util.Env;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployer;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansDeployer
implements IDeployer {
    private Log logger = LogFactory.getLog(EasyBeansDeployer.class);
    private Embedded easybeansServer = null;
    private Map<URL, EJB3Deployable> ejb3s = new HashMap<URL, EJB3Deployable>();
    private static final String WORK_EJB3S_DIR = JProp.getWorkDir() + File.separator + "ejb3s";
    private ServerProperties serverProperties = null;
    private VersioningService versioningService;
    private DeployerLog deployerLog;

    public void deploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EJB3Deployable) {
            EJB3Deployable ejb3Deployable = (EJB3Deployable)deployable;
            if (Env.isOsWindows()) {
                File folder = new File(WORK_EJB3S_DIR, this.getServerProperties().getServerName());
                folder.mkdirs();
                try {
                    ejb3Deployable = (EJB3Deployable)UnpackDeployableHelper.unpack((IDeployable)((EJB3Deployable)deployable), (File)folder, (String)FileUtils.lastModifiedFileName((File)URLUtils.urlToFile((URL)deployable.getArchive().getURL())));
                }
                catch (ArchiveException e) {
                    throw new DeployerException("Cannot get archive while deploying EJB3Deployable", (Throwable)e);
                }
                catch (FileUtilsException e) {
                    throw new DeployerException("Cannot get file last modified date while deploying EJB3Deployable", (Throwable)e);
                }
            }
            this.deployEJB3(ejb3Deployable);
        }
    }

    protected void deployEJB3(EJB3Deployable ejb3Deployable) throws DeployerException {
        EJB3Deployable originalDeployable = (EJB3Deployable)ejb3Deployable.getOriginalDeployable();
        if (originalDeployable == null) {
            originalDeployable = ejb3Deployable;
        }
        this.logger.info((Object)"Deploying ''{0}''...", new Object[]{originalDeployable});
        EZBContainer container = this.easybeansServer.createContainer(ejb3Deployable.getArchive());
        String prefix = null;
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            prefix = this.versioningService.getPrefix((IDeployable)originalDeployable);
        }
        if (prefix != null) {
            container.getConfiguration().setNamingStrategy((EZBNamingStrategy)new PrefixedNamingStrategy(prefix, container.getConfiguration().getNamingStrategy()));
        }
        try {
            container.start();
        }
        catch (EZBContainerException e) {
            this.easybeansServer.removeContainer(container);
            throw new DeployerException("Cannot deploy the given EJB '" + originalDeployable + "'.", (Throwable)e);
        }
        try {
            URL initialURL = originalDeployable.getArchive().getURL();
            this.ejb3s.put(initialURL, ejb3Deployable);
            if (this.deployerLog != null) {
                this.deployerLog.addEntry(URLUtils.urlToFile((URL)initialURL), URLUtils.urlToFile((URL)ejb3Deployable.getArchive().getURL()));
            }
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get  the url of the initial deployable for the EJB3 Module '" + originalDeployable + "'.", (Throwable)e);
        }
        if (prefix != null) {
            this.versioningService.createJNDIBindingMBeans((IDeployable)originalDeployable);
        }
        this.logger.info((Object)"''{0}'' EJB3 Deployable is now deployed", new Object[]{originalDeployable});
    }

    protected void undeployEJB3(EJB3Deployable ejb3Deployable) throws DeployerException {
        EJB3Deployable originalDeployable = (EJB3Deployable)ejb3Deployable.getOriginalDeployable();
        if (originalDeployable == null) {
            originalDeployable = ejb3Deployable;
        }
        URL ejb3URL = null;
        try {
            ejb3URL = originalDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL on the EJB3 deployable '" + originalDeployable + "'.", (Throwable)e);
        }
        IArchive archive = null;
        EJB3Deployable unpackedDeployable = (EJB3Deployable)ejb3Deployable.getUnpackedDeployable();
        archive = unpackedDeployable != null ? unpackedDeployable.getArchive() : (this.ejb3s.containsKey(ejb3URL) ? this.ejb3s.get(ejb3URL).getArchive() : ejb3Deployable.getArchive());
        this.logger.info((Object)"Undeploying ''{0}''...", new Object[]{originalDeployable});
        Map containers = this.easybeansServer.getContainers();
        EZBContainer foundContainer = null;
        for (EZBContainer container : containers.values()) {
            IArchive containerArchive = container.getArchive();
            if (!archive.equals(containerArchive)) continue;
            foundContainer = container;
            break;
        }
        if (foundContainer == null) {
            throw new DeployerException("Cannot undeploy the deployable '" + originalDeployable + "' as this container is not deployed");
        }
        this.ejb3s.remove(ejb3URL);
        this.logger.debug((Object)"Found a matching container ''{0}'' for the archive ''{1}''", new Object[]{foundContainer, originalDeployable.getArchive()});
        try {
            foundContainer.stop();
            this.easybeansServer.removeContainer(foundContainer);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot undeploy the deployable '" + originalDeployable + "'", (Throwable)e);
        }
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            this.versioningService.garbageCollectJNDIBindingMBeans();
        }
        this.logger.info((Object)"''{0}'' EJB3 Deployable is now undeployed", new Object[]{originalDeployable});
    }

    private void check(IDeployable<?> deployable) throws DeployerException {
        if (!this.supports(deployable)) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not supported by this deployer.");
        }
    }

    public void undeploy(IDeployable<?> deployable) throws DeployerException {
        this.check(deployable);
        if (deployable instanceof EJB3Deployable) {
            this.undeployEJB3((EJB3Deployable)deployable);
        }
    }

    public boolean isDeployed(IDeployable<?> deployable) throws DeployerException {
        throw new UnsupportedOperationException("IsDeployed not yet supported");
    }

    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof EJB3Deployable;
    }

    public Map<URL, EJB3Deployable> getEJB3s() {
        return this.ejb3s;
    }

    public void setEmbedded(Embedded easybeansServer) {
        this.easybeansServer = easybeansServer;
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setDeployerLog(DeployerLog deployerLog) {
        this.deployerLog = deployerLog;
    }
}

