/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.ee.jdbc.ConnectionRequestInfoImpl;
import org.ow2.jonas.ee.jdbc.MCFData;
import org.ow2.jonas.ee.jdbc.ManagedConnectionFactoryImpl;

public class Utility {
    static synchronized Object getDataSource(ManagedConnectionFactoryImpl mcf, PasswordCredential pc, Logger trace) throws ResourceException {
        MCFData prop = mcf.mcfData;
        if (prop.getMCFData(0) == null) {
            ResourceException re = new ResourceException("A DataSource (dsClass) value must be specified");
            trace.log(BasicLevel.INFO, (Object)re.getMessage());
        }
        String clsName = prop.getMCFData(0);
        Class<?> dsClass = null;
        Object dsObj = null;
        try {
            dsClass = Class.forName(clsName, true, Thread.currentThread().getContextClassLoader());
            dsObj = dsClass.newInstance();
            if (trace.isLoggable(BasicLevel.DEBUG)) {
                trace.log(BasicLevel.DEBUG, (Object)("dsClass(" + clsName + ") is " + dsObj));
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ResourceException("Class Name not found:" + clsName, (Throwable)cnfe);
        }
        catch (Exception ex) {
            throw new ResourceException("Error in class: " + clsName + " " + ex.getMessage(), (Throwable)ex);
        }
        Object[] param = new Object[1];
        String methodName = null;
        String paramVal = null;
        Method meth = null;
        Enumeration e = prop.getProperties();
        while (e.hasMoreElements()) {
            int offset = Integer.parseInt((String)e.nextElement());
            methodName = MCFData.dsMethodNames[offset];
            if (!methodName.equals("setDSClass") && !methodName.equals("setDbSpecificMethods") && offset <= 17) {
                try {
                    paramVal = prop.getProperty("" + offset);
                    if (trace.isLoggable(BasicLevel.DEBUG)) {
                        trace.log(BasicLevel.DEBUG, (Object)("calling method " + methodName + " with String " + paramVal));
                    }
                    meth = dsClass.getMethod(methodName, String.class);
                    param[0] = paramVal;
                    meth.invoke(dsObj, param);
                }
                catch (NoSuchMethodException ns) {
                    try {
                        if (trace.isLoggable(BasicLevel.DEBUG)) {
                            trace.log(BasicLevel.DEBUG, (Object)("calling method " + methodName + " with int " + paramVal));
                        }
                        meth = dsClass.getMethod(methodName, Integer.TYPE);
                        param[0] = new Integer(paramVal);
                        meth.invoke(dsObj, param);
                    }
                    catch (NoSuchMethodException nsme) {
                    }
                    catch (NumberFormatException nfm) {
                    }
                    catch (Exception ex0) {
                        ex0.printStackTrace();
                        throw new ResourceException("Error on method: " + methodName + " " + ex0.getMessage(), (Throwable)ex0);
                    }
                }
                catch (IllegalArgumentException iae) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ResourceException("Error on method: " + methodName + " " + ex.getMessage(), (Throwable)ex);
                }
            }
            if (!methodName.equals("setDbSpecificMethods")) continue;
            Vector meths = new Vector();
            Vector methParams = new Vector();
            Vector methTypes = new Vector();
            try {
                Utility.parseValues(prop.getProperty("" + offset), meths, methParams, methTypes, trace);
            }
            catch (Exception ex1) {
                throw new ResourceException("Error parsing dbSpecificMethods: " + ex1.getMessage());
            }
            if (meths == null || meths.size() <= 0) continue;
            for (int i = 0; i < meths.size(); ++i) {
                try {
                    methodName = (String)meths.elementAt(i);
                    Class toPass = null;
                    String curMethType = (String)methTypes.elementAt(i);
                    if (curMethType.equalsIgnoreCase("String")) {
                        toPass = String.class;
                        param[0] = (String)methParams.elementAt(i);
                    } else if (curMethType.equalsIgnoreCase("Integer")) {
                        toPass = Integer.class;
                        param[0] = Integer.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equalsIgnoreCase("int")) {
                        toPass = Integer.TYPE;
                        param[0] = Integer.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("Float")) {
                        toPass = Float.class;
                        param[0] = Float.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("float")) {
                        toPass = Float.TYPE;
                        param[0] = Float.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("Boolean")) {
                        toPass = Boolean.class;
                        param[0] = Boolean.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("boolean")) {
                        toPass = Boolean.TYPE;
                        param[0] = Boolean.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equalsIgnoreCase("Character")) {
                        toPass = Character.class;
                        param[0] = new Character(((String)methParams.elementAt(i)).charAt(0));
                    } else if (curMethType.equalsIgnoreCase("char")) {
                        toPass = Character.TYPE;
                        param[0] = new Character(((String)methParams.elementAt(i)).charAt(0));
                    } else if (curMethType.equals("Double")) {
                        toPass = Double.class;
                        param[0] = Double.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("double")) {
                        toPass = Double.TYPE;
                        param[0] = Double.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("Byte")) {
                        toPass = Byte.class;
                        param[0] = Byte.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("byte")) {
                        toPass = Byte.TYPE;
                        param[0] = Byte.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("Short")) {
                        toPass = Short.class;
                        param[0] = Short.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("short")) {
                        toPass = Short.TYPE;
                        param[0] = Short.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("Long")) {
                        toPass = Long.class;
                        param[0] = Long.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("long")) {
                        toPass = Long.TYPE;
                        param[0] = Long.valueOf((String)methParams.elementAt(i));
                    } else if (curMethType.equals("Properties") || curMethType.equals("java.lang.Properties")) {
                        toPass = Properties.class;
                        param[0] = Utility.buildProperties((String)methParams.elementAt(i), trace);
                    }
                    if (trace.isLoggable(BasicLevel.DEBUG)) {
                        trace.log(BasicLevel.DEBUG, (Object)("calling method " + methodName + " with " + param[0]));
                    }
                    meth = dsClass.getMethod(methodName, toPass);
                    meth.invoke(dsObj, param);
                    continue;
                }
                catch (NoSuchMethodException ns) {
                    throw new ResourceException("No such method: " + methodName + " " + ns.getMessage(), (Throwable)ns);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new ResourceException("Error on method: " + methodName + " " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
        if (pc != null) {
            try {
                param[0] = pc.getUserName();
                meth = dsClass.getMethod("setUserName", Class.forName("String"));
                meth.invoke(dsObj, param);
                param[0] = new String(pc.getPassword());
                meth = dsClass.getMethod("setPassword", Class.forName("String"));
                meth.invoke(dsObj, param);
            }
            catch (Exception ex) {
                throw new ResourceException("Error on method: " + methodName + " " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (trace.isLoggable(BasicLevel.DEBUG)) {
            try {
                meth = dsClass.getMethod("getURL", null);
                trace.log(BasicLevel.DEBUG, (Object)("URL is " + meth.invoke(dsObj, (Object[])null)));
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return dsObj;
    }

    private static Properties buildProperties(String val, Logger trace) throws Exception {
        if (trace.isLoggable(BasicLevel.DEBUG)) {
            trace.log(BasicLevel.DEBUG, (Object)("" + val));
        }
        Properties ret = new Properties();
        if (val.length() == 0) {
            return ret;
        }
        String pairs = val.substring(1, val.length() - 1);
        String parseVal = pairs.replace(',', '\n');
        try {
            ByteArrayInputStream valStream = new ByteArrayInputStream(parseVal.getBytes());
            ret.load(valStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Invalid value specified for Properties parameter in dbSpecificMethods");
        }
        return ret;
    }

    private static void parseValues(String val, Vector vMeth, Vector vValues, Vector vTypes, Logger trace) throws Exception {
        if (trace.isLoggable(BasicLevel.DEBUG)) {
            trace.log(BasicLevel.DEBUG, (Object)"");
        }
        char delim = ':';
        boolean done = false;
        String methName = null;
        int offset = 0;
        boolean parsed = false;
        String parseVal = val.trim();
        String typeVal = "";
        String valVal = "";
        if (parseVal.length() == 0) {
            return;
        }
        if (parseVal.startsWith(":")) {
            delim = parseVal.charAt(1);
            parseVal = parseVal.substring(2);
        }
        while (!parsed) {
            offset = parseVal.indexOf(61);
            if (offset < 0) {
                throw new Exception("Invalid value specified for dbSpecificMethods");
            }
            methName = parseVal.substring(0, offset);
            vMeth.add(methName);
            parseVal = parseVal.substring(offset + 1);
            if (parseVal.charAt(0) == delim) {
                valVal = "";
            } else {
                offset = parseVal.indexOf(delim);
                if (offset < 0) {
                    valVal = parseVal;
                    offset = valVal.length() - 1;
                } else {
                    valVal = parseVal.substring(0, offset);
                }
            }
            vValues.add(valVal);
            if (offset < 0) {
                parsed = true;
            } else if ((parseVal = parseVal.substring(offset + 1)).length() == 0) {
                parsed = true;
            }
            if (parseVal.startsWith("" + delim)) {
                offset = (parseVal = parseVal.substring(1)).indexOf(delim);
                typeVal = offset < 0 ? parseVal : parseVal.substring(0, offset);
                vTypes.add(typeVal);
                if (offset < 0) {
                    parsed = true;
                } else if ((parseVal = parseVal.substring(offset + 1)).length() == 0) {
                    parsed = true;
                }
            } else {
                vTypes.add("String");
            }
            if (!trace.isLoggable(BasicLevel.DEBUG)) continue;
            trace.log(BasicLevel.DEBUG, (Object)("Parsed: method(" + methName + ") value(" + valVal + ") type(" + typeVal + ")"));
        }
    }

    static synchronized PasswordCredential getPasswordCredential(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, PrintWriter out) throws ResourceException {
        if (subject == null) {
            if (info == null) {
                return null;
            }
            ConnectionRequestInfoImpl crii = (ConnectionRequestInfoImpl)info;
            PasswordCredential pc = new PasswordCredential(crii.user, crii.password.toCharArray());
            pc.setManagedConnectionFactory(mcf);
            return pc;
        }
        Set<PasswordCredential> cred = subject.getPrivateCredentials(PasswordCredential.class);
        PasswordCredential pc = null;
        for (PasswordCredential tmpPc : cred) {
            if (!tmpPc.getManagedConnectionFactory().equals(mcf)) continue;
            pc = tmpPc;
            break;
        }
        if (pc == null) {
            SecurityException se = new SecurityException("No PasswordCredential found");
            out.println("" + se);
            throw se;
        }
        return pc;
    }
}

