/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2005 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DataSourceImpl.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.ee.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;

import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.Reference;

import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;

import org.objectweb.util.monolog.api.BasicLevel;

/**
 * Description of the DataSourceImpl. This is the dataSource for the JDBC RA.
 * @author Eric Hardesty
 * @created 22 May 2003
 */
public class DataSourceImpl implements javax.sql.DataSource, Serializable, Referenceable {

    private ConnectionManager cm;

    private ManagedConnectionFactoryImpl mcf;

    private PrintWriter pw;

    private Reference reference;

    int loginTimeout = 0;

    /**
     * Logging (debug enabled)
     */
    private final boolean isDebugOn;

    public DataSourceImpl(ManagedConnectionFactoryImpl _mcf, ConnectionManager _cm) {
        if (_cm == null) {
            cm = new ConnectionManagerImpl();
        } else {
            cm = _cm;
        }
        mcf = _mcf;
        isDebugOn = mcf.trace.isLoggable(BasicLevel.DEBUG);
    }

    public Connection getConnection() throws SQLException {
        if (isDebugOn) {
            mcf.trace.log(BasicLevel.DEBUG, "");
        }
        try {
            Connection con = (Connection) cm.allocateConnection(mcf, null);
            if (con == null) {
                SQLException se = new SQLException("Null connection object returned");
                throw se;
            }
            return con;
        } catch (ResourceException re) {
            throw new SQLException(re.getMessage());
        }
    }

    public Connection getConnection(String user, String pwd) throws SQLException {
        if (isDebugOn) {
            mcf.trace.log(BasicLevel.DEBUG, "" + user);
        }
        try {
            ConnectionRequestInfoImpl info = new ConnectionRequestInfoImpl(user, pwd);
            Connection con = (Connection) cm.allocateConnection(mcf, info);
            if (con == null) {
                SQLException se = new SQLException("Null connection object returned");
                throw se;
            }
            return con;
        } catch (ResourceException re) {
            throw new SQLException(re.getMessage());
        }
    }

    public int getLoginTimeout() throws SQLException {
        return loginTimeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return pw;
    }

    public Reference getReference() {
        return reference;
    }

    public void setLoginTimeout(int _loginTimeout) throws SQLException {
        loginTimeout = _loginTimeout;
    }

    public void setLogWriter(PrintWriter _pw) throws SQLException {
        pw = _pw;
    }

    public void setReference(Reference _ref) {
        reference = _ref;
    }

    /* JOnAS JDBC implementation for CMP */

    public String getMapperName() {
        String mn = mcf.getMapperName();
        if (isDebugOn) {
            mcf.trace.log(BasicLevel.DEBUG, mn);
        }
        return mn;
    }

}
