/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.wrapper.printwriter.LoggerImpl;
import org.ow2.jonas.ee.jdbc.DataSourceImpl;
import org.ow2.jonas.ee.jdbc.MCFData;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;
import org.ow2.jonas.ee.jdbc.Utility;
import org.ow2.jonas.lib.util.Log;

public abstract class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
ValidatingManagedConnectionFactory,
Serializable {
    MCFData mcfData = new MCFData();
    int hashcode = 0;
    PrintWriter pw = null;
    String logTopic = "";
    protected static final String LOGGER_FACTORY = "org.objectweb.util.monolog.loggerFactory";
    public Logger trace = null;
    private boolean isEnabledDebug = false;
    private int checkLevel = 0;
    private String testStmt = null;
    public static final int JDBC_NO_TEST = 0;
    public static final int JDBC_CHECK_CONNECTION = 1;
    public static final int JDBC_SEND_STATEMENT = 2;
    public static final int JDBC_KEEP_ALIVE = 3;

    public abstract ManagedConnection createManagedConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract boolean equals(Object var1);

    public Object createConnectionFactory() throws ResourceException {
        return new DataSourceImpl(this, null);
    }

    public Object createConnectionFactory(ConnectionManager cxMgr) throws ResourceException {
        return new DataSourceImpl(this, cxMgr);
    }

    public void getLogger(String _logTopic) throws Exception {
        if (this.trace == null || !this.logTopic.equals(_logTopic)) {
            this.logTopic = _logTopic;
            try {
                LoggerFactory mf = Log.getLoggerFactory();
                this.trace = this.logTopic != null && this.logTopic.length() > 0 ? mf.getLogger(this.logTopic) : (this.pw != null ? new LoggerImpl(this.pw) : mf.getLogger("org.ow2.jonas.ee.jdbc.RA"));
            }
            catch (Exception ex) {
                try {
                    if (this.pw != null) {
                        this.trace = new LoggerImpl(this.pw);
                    }
                }
                catch (Exception e3) {
                    throw new Exception("Cannot get logger");
                }
            }
        }
        this.isEnabledDebug = this.trace.isLoggable(BasicLevel.DEBUG);
        if (this.isEnabledDebug) {
            this.trace.log(BasicLevel.DEBUG, (Object)("getLogger(" + _logTopic + ")"));
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.pw;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.mcfData.hashCode();
            try {
                this.getLogger(this.mcfData.getMCFData(19));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.hashcode;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxReq) throws ResourceException {
        if (this.isEnabledDebug) {
            this.trace.log(BasicLevel.DEBUG, (Object)("matchManagedConnection(" + connectionSet + "," + subject + "," + cxReq + ")"));
        }
        if (connectionSet == null) {
            return null;
        }
        PasswordCredential pc = Utility.getPasswordCredential(this, subject, cxReq, this.pw);
        Iterator it = connectionSet.iterator();
        Object obj = null;
        ManagedConnectionImpl mc = null;
        while (it.hasNext()) {
            try {
                obj = it.next();
                if (!(obj instanceof ManagedConnectionImpl)) continue;
                ManagedConnectionImpl mc1 = obj;
                if (pc == null && this.equals(mc1.mcf)) {
                    mc = mc1;
                    break;
                }
                if (pc == null || !pc.equals((Object)mc.pc)) continue;
                mc = mc1;
                break;
            }
            catch (Exception ex) {
                throw new ResourceException(ex.getMessage());
            }
        }
        if (this.isEnabledDebug) {
            this.trace.log(BasicLevel.DEBUG, (Object)("matchManagedConnection returns(" + mc + ")"));
        }
        return mc;
    }

    public void setLogWriter(PrintWriter _pw) throws ResourceException {
        this.pw = _pw;
    }

    public String getDbSpecificMethods() {
        return this.mcfData.getMCFData(1);
    }

    public void setDbSpecificMethods(String val) {
        this.mcfData.setMCFData(1, val);
    }

    public String getDsClass() {
        return this.mcfData.getMCFData(0);
    }

    public void setDsClass(String val) {
        this.mcfData.setMCFData(0, val);
    }

    public String getIsolationLevel() {
        int isolationLevel;
        String str = this.mcfData.getMCFData(11);
        String retStr = "default";
        if (str.length() == 0 || str.equals("-1")) {
            return retStr;
        }
        try {
            isolationLevel = Integer.parseInt(str);
        }
        catch (Exception ex) {
            return retStr;
        }
        if (isolationLevel == 8) {
            retStr = "serializable";
        } else if (isolationLevel == 0) {
            retStr = "none";
        } else if (isolationLevel == 2) {
            retStr = "read_committed";
        } else if (isolationLevel == 1) {
            retStr = "read_uncommitted";
        } else if (isolationLevel == 4) {
            retStr = "repeatable_read";
        }
        return retStr;
    }

    public void setIsolationLevel(String val) {
        int isolationLevel = -1;
        if (val.equals("serializable")) {
            isolationLevel = 8;
        } else if (val.equals("none")) {
            isolationLevel = 0;
        } else if (val.equals("read_committed")) {
            isolationLevel = 2;
        } else if (val.equals("read_uncommitted")) {
            isolationLevel = 1;
        } else if (val.equals("repeatable_read")) {
            isolationLevel = 4;
        }
        this.mcfData.setMCFData(11, "" + isolationLevel);
    }

    public String getLoginTimeout() {
        return this.mcfData.getMCFData(10);
    }

    public void setLoginTimeout(String val) {
        this.mcfData.setMCFData(10, val);
    }

    public String getLogTopic() {
        return this.mcfData.getMCFData(19);
    }

    public void setLogTopic(String val) {
        this.mcfData.setMCFData(19, val);
        try {
            this.getLogger(val.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMapperName() {
        return this.mcfData.getMCFData(18);
    }

    public void setMapperName(String val) {
        this.mcfData.setMCFData(18, val);
    }

    public String getPassword() {
        return this.mcfData.getMCFData(9);
    }

    public void setPassword(String val) {
        this.mcfData.setMCFData(9, val);
    }

    public String getUser() {
        return this.mcfData.getMCFData(8);
    }

    public void setUser(String val) {
        this.mcfData.setMCFData(8, val);
    }

    public void setJdbcConnLevel(int lev) {
        if (this.isEnabledDebug) {
            this.trace.log(BasicLevel.DEBUG, (Object)("checkLevel =" + this.checkLevel));
        }
        this.checkLevel = lev;
    }

    public int getJdbcConnLevel() {
        return this.checkLevel;
    }

    public void setJdbcConnTestStmt(String stmt) {
        if (this.isEnabledDebug) {
            this.trace.log(BasicLevel.DEBUG, (Object)("testStmt =" + this.testStmt));
        }
        this.testStmt = stmt;
    }

    public String getJdbcConnTestStmt() {
        return this.testStmt;
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        HashSet<ManagedConnectionImpl> ret = new HashSet<ManagedConnectionImpl>();
        if (this.checkLevel != 3) {
            return ret;
        }
        if (this.testStmt == null || this.testStmt.length() == 0) {
            this.trace.log(BasicLevel.WARN, (Object)"jdbc-test-statement not set in jonas-ra.xml");
            return ret;
        }
        if (this.isEnabledDebug) {
            this.trace.log(BasicLevel.DEBUG, (Object)"Keep Alive Connections");
        }
        Iterator it = connectionSet.iterator();
        while (it.hasNext()) {
            try {
                ManagedConnectionImpl mci = (ManagedConnectionImpl)it.next();
                if (mci.isValid()) continue;
                ret.add(mci);
            }
            catch (ClassCastException e) {
                this.trace.log(BasicLevel.DEBUG, (Object)"ClassCastException");
            }
            catch (Exception e) {
                this.trace.log(BasicLevel.DEBUG, (Object)("exc:" + e));
            }
        }
        return ret;
    }
}

