/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;
import org.ow2.jonas.resource.internal.IJDBCConnection;
import org.ow2.jonas.resource.internal.SQLManager;
import org.ow2.jonas.resource.internal.cm.ManagedConnectionInfo;

public class ConnectionImpl
implements IJDBCConnection {
    public Logger trace = null;
    ManagedConnectionImpl mc = null;
    Connection connection = null;
    PrintWriter pw = null;
    long key = 0L;
    String user = "";
    private SQLManager conman = null;
    private ManagedConnectionInfo mci = null;
    private final boolean isDebugging;

    protected ConnectionImpl(ManagedConnectionImpl _mc, Connection _con, long _key, PrintWriter _pw) {
        this.mc = _mc;
        this.connection = _con;
        this.key = _key;
        this.pw = _pw;
        this.trace = this.mc.trace;
        this.isDebugging = this.trace.isLoggable(BasicLevel.DEBUG);
        if (this.connection == null) {
            this.trace.log(BasicLevel.ERROR, (Object)"Init ConnectionImpl with a null Connection");
        }
    }

    public boolean isPhysicallyClosed() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.connection.isClosed();
    }

    public void setJonasInfo(ManagedConnectionInfo _mci, SQLManager _conman) {
        this.mci = _mci;
        this.conman = _conman;
    }

    public void setUser() {
        try {
            this.user = this.mc.getMetaData().getUserName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        this.connection.clearWarnings();
    }

    public void close() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            if (this.key != 0L) {
                this.mc.close(this);
                this.key = 0L;
            }
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"error");
            e.printStackTrace();
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public void commit() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
            this.connection.commit();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public Statement createStatement() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"checkContext error", (Throwable)e, (Object)"ConnectionImpl", (Object)"createStatement");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.createStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
            return this.connection.getAutoCommit();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.getAC error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public String getCatalog() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.getCatalog: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.getCatalog();
    }

    public int getHoldability() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.getHoldability: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.getMetaData: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.getTransactionIsolation: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.getTypeMap: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.getWarnings: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.key == 0L;
    }

    public boolean isReadOnly() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.isReadOnly: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.nativeSQL: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareCall: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareCall: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        if (this.conman != null && this.conman.getMaxPstmtPoolSize() >= 0) {
            return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql);
        }
        return this.connection.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int rsettype, int rsetconcurrency) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        if (this.conman != null && this.conman.getMaxPstmtPoolSize() >= 0) {
            return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql, rsettype, rsetconcurrency);
        }
        return this.connection.prepareStatement(sql, rsettype, rsetconcurrency);
    }

    public void rollback() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
            this.connection.rollback();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)e.getMessage());
            e.printStackTrace();
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public PreparedStatement prepareStatement(String sql, int rsettype, int rsetconcurrency, int holdability) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        if (this.conman != null && this.conman.getMaxPstmtPoolSize() >= 0) {
            return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql, rsettype, rsetconcurrency, holdability);
        }
        return this.connection.prepareStatement(sql, rsettype, rsetconcurrency, holdability);
    }

    public PreparedStatement prepareStatement(String sql, int[] t) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        if (this.conman != null && this.conman.getMaxPstmtPoolSize() >= 0) {
            return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql, t);
        }
        return this.connection.prepareStatement(sql, t);
    }

    public PreparedStatement prepareStatement(String sql, String[] t) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        if (this.conman != null && this.conman.getMaxPstmtPoolSize() >= 0) {
            return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql, t);
        }
        return this.connection.prepareStatement(sql, t);
    }

    public PreparedStatement prepareStatement(String sql, int autoGenKeys) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        if (this.conman != null && this.conman.getMaxPstmtPoolSize() >= 0) {
            return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql, autoGenKeys);
        }
        return this.connection.prepareStatement(sql, autoGenKeys);
    }

    public CallableStatement prepareCall(String sql, int rsettype, int rsetconcurrency, int holdability) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.prepareCall(sql, rsettype, rsetconcurrency, holdability);
    }

    public Statement createStatement(int rsettype, int rsetconcurrency, int holdability) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.prepareStatement: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        return this.connection.createStatement(rsettype, rsetconcurrency, holdability);
    }

    public void releaseSavepoint(Savepoint sp) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
            this.connection.releaseSavepoint(sp);
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)e.getMessage());
            e.printStackTrace();
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public void rollback(Savepoint sp) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
            this.connection.rollback(sp);
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)e.getMessage());
            e.printStackTrace();
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
            return this.connection.setSavepoint();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)e.getMessage());
            e.printStackTrace();
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
            return this.connection.setSavepoint(name);
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)e.getMessage());
            e.printStackTrace();
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public void setAutoCommit(boolean value) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)("value=" + value));
        }
        if (this.connection == null) {
            this.trace.log(BasicLevel.ERROR, (Object)"No Connection yet !");
            return;
        }
        try {
            this.checkContext();
            this.connection.setAutoCommit(value);
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)("Could not set AutoCommit:" + e));
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.setCatalog: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        this.connection.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.setCatalog: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        this.connection.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.setReadOnly: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        this.connection.setReadOnly(readOnly);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.setTransactionIsolation: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        this.connection.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"ConnectionImpl.setTypeMap: checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        this.connection.setTypeMap(map);
    }

    private void checkContext() throws Exception {
        if (this.key == 0L) {
            this.trace.log(BasicLevel.ERROR, (Object)"Connection is closed");
            throw new Exception("Connection is closed");
        }
        if (this.key != this.mc.getSignature()) {
            if (this.mc.getSignature() == 0L) {
                this.mc.setSignature(this.key);
            } else {
                this.trace.log(BasicLevel.ERROR, (Object)"not current active Connection ");
                throw new Exception("Connection w/sig(" + this.key + ") is not current active Connection (" + this.mc.getSignature() + ")");
            }
        }
    }

    public void setSignature(long sig) {
        this.key = sig;
    }
}

