/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.ee.jdbc.ConnectionImpl;
import org.ow2.jonas.ee.jdbc.DriverWrapper;
import org.ow2.jonas.ee.jdbc.ManagedConnectionFactoryImpl;
import org.ow2.jonas.ee.jdbc.MetaDataImpl;
import org.ow2.jonas.ee.jdbc.XAResourceImpl;

public class ManagedConnectionImpl
implements ManagedConnection,
LocalTransaction {
    public Logger trace = null;
    protected PrintWriter out = null;
    protected DataSource factory = null;
    protected HashSet cels = null;
    protected boolean inLocalTransaction = false;
    ManagedConnectionFactoryImpl mcf = null;
    Connection connection = null;
    PooledConnection poolCon = null;
    XAConnection xaCon = null;
    PasswordCredential pc = null;
    DriverWrapper wrapper = null;
    private XAResource xares;
    private boolean isAutoCommit = true;
    private boolean closed = false;
    private long[] sigList;
    private int maxSigs;
    private long signature;
    private long lastSig;
    private final boolean isDebugOn;

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl _mcf, PasswordCredential _pc, Connection _con, PooledConnection _pcon, XAConnection _xa, DriverWrapper wrp) {
        this.mcf = _mcf;
        this.pc = _pc;
        this.connection = _con;
        this.poolCon = _pcon;
        this.xaCon = _xa;
        this.wrapper = wrp;
        this.xares = null;
        this.out = this.mcf.pw;
        this.cels = new HashSet();
        this.maxSigs = 50;
        this.sigList = new long[this.maxSigs];
        this.signature = 0L;
        this.lastSig = 0L;
        this.trace = this.mcf.trace;
        this.isDebugOn = this.trace.isLoggable(BasicLevel.DEBUG);
        if (this.connection == null) {
            this.trace.log(BasicLevel.ERROR, (Object)"Null Connection");
        } else {
            this.trace.log(BasicLevel.DEBUG, (Object)("New Connection: " + this.connection));
        }
    }

    public void signalEvent(int code, Object ch, Exception ex) {
        ConnectionEvent ce = null;
        ce = ex == null ? new ConnectionEvent((ManagedConnection)this, code) : new ConnectionEvent((ManagedConnection)this, code, ex);
        if (ch != null) {
            ce.setConnectionHandle(ch);
        }
        block7: for (ConnectionEventListener cel : this.cels) {
            switch (code) {
                case 1: {
                    cel.connectionClosed(ce);
                    continue block7;
                }
                case 2: {
                    cel.localTransactionStarted(ce);
                    continue block7;
                }
                case 3: {
                    cel.localTransactionCommitted(ce);
                    continue block7;
                }
                case 4: {
                    cel.localTransactionRolledback(ce);
                    continue block7;
                }
                case 5: {
                    cel.connectionErrorOccurred(ce);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal eventType: " + code);
        }
    }

    public synchronized boolean getAutoCommit() throws ResourceException {
        return this.isAutoCommit;
    }

    public synchronized void setAutoCommit(boolean ac) throws ResourceException {
        try {
            if (this.connection != null) {
                this.connection.setAutoCommit(ac);
            }
            this.isAutoCommit = ac;
            if (this.isDebugOn) {
                this.trace.log(BasicLevel.DEBUG, (Object)("setAutoCommit " + ac));
            }
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.WARN, (Object)("Cannot set AutoCommit:" + e));
            throw new ResourceException(e.getMessage());
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.cels.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.cels.remove(listener);
    }

    public synchronized void associateConnection(Object con) throws ResourceException {
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)("connection:" + con));
        }
        if (!(con instanceof ConnectionImpl)) {
            throw new ResourceException("The managedConnection cannot associate this connection: " + con);
        }
        ConnectionImpl ci = (ConnectionImpl)con;
        long sig = this.getNewSignature(true);
        ci.setSignature(sig);
    }

    public void cleanup() throws ResourceException {
        if (this.inLocalTransaction) {
            this.trace.log(BasicLevel.WARN, (Object)"A local transaction is not complete");
            throw new IllegalStateException("A local transaction is not complete");
        }
        if (!this.isAutoCommit) {
            try {
                this.setAutoCommit(true);
            }
            catch (Exception exc) {
                this.trace.log(BasicLevel.WARN, (Object)"in global transaction");
                throw new IllegalStateException("in global transaction");
            }
        }
        this.clearSignature();
    }

    public synchronized void destroy() throws ResourceException {
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)("destroy mc=" + this + " with connection=" + this.connection));
        }
        this.cleanup();
        if (this.xaCon != null) {
            try {
                this.xaCon.close();
            }
            catch (Exception e) {
                this.trace.log(BasicLevel.ERROR, (Object)("Cannot close xaConnection:" + e));
            }
            this.xaCon = null;
        } else if (this.poolCon != null) {
            try {
                this.poolCon.close();
            }
            catch (Exception e) {
                this.trace.log(BasicLevel.ERROR, (Object)("Cannot close PoolConnection:" + e));
            }
            this.poolCon = null;
        } else {
            if (this.wrapper != null) {
                try {
                    DriverManager.deregisterDriver(this.wrapper);
                }
                catch (Exception e) {
                    this.trace.log(BasicLevel.ERROR, (Object)"Unable to deregister Driver wrapper", (Throwable)e);
                }
            }
            if (this.connection != null) {
                try {
                    try {
                        this.connection.close();
                    }
                    catch (Exception e) {
                        this.trace.log(BasicLevel.ERROR, (Object)"", (Throwable)e, (Object)"ManagedConnectionImpl", (Object)"destroy");
                        throw new ResourceException((Throwable)e);
                    }
                    Object var3_5 = null;
                    this.connection = null;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    this.connection = null;
                    throw throwable;
                }
            }
        }
        this.xares = null;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)("subject:" + subject + " connectionRequest:" + cxRequestInfo));
        }
        long sig = this.getNewSignature(true);
        if (this.connection == null) {
            this.trace.log(BasicLevel.ERROR, (Object)"null Connection");
            throw new ResourceException("Cannot create Handle on a null Connection");
        }
        try {
            return new ConnectionImpl(this, this.connection, sig, this.out);
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"", (Throwable)e, (Object)"ManagedConnectionImpl", (Object)"getConnection");
            throw new ResourceException(e.getMessage());
        }
    }

    public void close(ConnectionImpl ch) throws ResourceException {
        this.clearSignature(ch.key, true);
        this.signalEvent(1, ch, null);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new MetaDataImpl(this);
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.inLocalTransaction) {
            throw new ResourceException("The managedConnection is already in a local transaction and an XA resource cannot be obtained");
        }
        if (this.xares == null) {
            if (this.xaCon != null) {
                try {
                    this.xares = this.xaCon.getXAResource();
                }
                catch (Exception ex) {
                    throw new ResourceException("Unable to obtain XAResource: ", (Throwable)ex);
                }
            } else if (this.isDebugOn) {
                this.trace.log(BasicLevel.DEBUG, (Object)"JDBC driver doesn't support XA, simulate it");
            }
            this.xares = new XAResourceImpl(this, this.xares);
        }
        return this.xares;
    }

    public void setLogWriter(PrintWriter _out) {
        this.out = _out;
    }

    public void addSignature(long sig) {
        int off = -1;
        for (int i = 0; i < this.maxSigs; ++i) {
            if (this.sigList[i] != 0L) continue;
            off = i;
            break;
        }
        if (off > -1) {
            this.sigList[off] = sig;
        } else {
            this.maxSigs += 20;
            long[] tmp = new long[this.maxSigs];
            System.arraycopy(this.sigList, 0, tmp, 0, this.maxSigs - 20);
            this.sigList = tmp;
            this.sigList[this.maxSigs - 20] = sig;
        }
    }

    public void clearSignature() {
        for (int i = 0; i < this.maxSigs; ++i) {
            this.sigList[i] = 0L;
        }
        this.signature = 0L;
    }

    public void clearSignature(long sig, boolean clear) {
        for (int i = 0; i < this.maxSigs; ++i) {
            if (sig != this.sigList[i]) continue;
            this.sigList[i] = 0L;
            break;
        }
        if (clear) {
            this.signature = 0L;
        }
    }

    public void setSignature(long sig) {
        if (this.signature == 0L) {
            this.signature = sig;
        }
    }

    public long getSignature(long sig) {
        long retSig = 0L;
        if (sig > 0L) {
            for (int i = 0; i < this.maxSigs; ++i) {
                if (sig != this.sigList[i]) continue;
                retSig = sig;
                break;
            }
        }
        return retSig;
    }

    public long getSignature() {
        return this.signature;
    }

    public long getNewSignature(boolean setSig) {
        long sig = System.currentTimeMillis();
        if (sig <= this.lastSig && this.lastSig != 0L) {
            sig = this.lastSig++;
        }
        if (this.isDebugOn) {
            this.trace.log(BasicLevel.DEBUG, (Object)("Sig is " + sig + " last Sig was " + this.lastSig));
        }
        this.lastSig = sig;
        this.addSignature(sig);
        if (setSig) {
            this.signature = sig;
        }
        return sig;
    }

    public void begin() throws ResourceException {
        if (this.inLocalTransaction) {
            throw new ResourceException("The managedConnection is already in a LocalTransaction");
        }
        this.trace.log(BasicLevel.DEBUG, (Object)"");
        try {
            this.inLocalTransaction = true;
            this.connection.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit() throws ResourceException {
        block12: {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
            Exception commitException = null;
            this.connection.commit();
            Object var4_2 = null;
            try {
                this.connection.setAutoCommit(true);
                if (commitException != null) {
                    this.signalEvent(5, null, commitException);
                }
            }
            catch (Exception ex) {
                this.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
            }
            this.inLocalTransaction = false;
            {
                break block12;
                catch (Exception e) {
                    commitException = e;
                    this.trace.log(BasicLevel.WARN, (Object)("Could not commit local tx: " + e));
                    Object var4_3 = null;
                    try {
                        this.connection.setAutoCommit(true);
                        if (commitException != null) {
                            this.signalEvent(5, null, commitException);
                        }
                    }
                    catch (Exception ex) {
                        this.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                    }
                    this.inLocalTransaction = false;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.connection.setAutoCommit(true);
                    if (commitException != null) {
                        this.signalEvent(5, null, commitException);
                    }
                }
                catch (Exception ex) {
                    this.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                }
                this.inLocalTransaction = false;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void rollback() throws ResourceException {
        block12: {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
            Exception rbException = null;
            this.connection.rollback();
            Object var4_2 = null;
            try {
                this.connection.setAutoCommit(true);
                if (rbException != null) {
                    this.signalEvent(5, null, rbException);
                }
            }
            catch (Exception ex) {
                this.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
            }
            this.inLocalTransaction = false;
            {
                break block12;
                catch (Exception e) {
                    rbException = e;
                    this.trace.log(BasicLevel.WARN, (Object)("Could not rollback local tx: " + e));
                    Object var4_3 = null;
                    try {
                        this.connection.setAutoCommit(true);
                        if (rbException != null) {
                            this.signalEvent(5, null, rbException);
                        }
                    }
                    catch (Exception ex) {
                        this.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                    }
                    this.inLocalTransaction = false;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.connection.setAutoCommit(true);
                    if (rbException != null) {
                        this.signalEvent(5, null, rbException);
                    }
                }
                catch (Exception ex) {
                    this.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                }
                this.inLocalTransaction = false;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        boolean ret = true;
        if (this.connection == null) {
            this.trace.log(BasicLevel.WARN, (Object)"No connection");
            return false;
        }
        Statement stmt = null;
        stmt = this.connection.createStatement();
        stmt.execute(this.mcf.getJdbcConnTestStmt());
        Object var5_3 = null;
        if (stmt == null) return ret;
        try {
            stmt.close();
            return ret;
        }
        catch (Exception e) {}
        return ret;
        {
            catch (SQLException se) {
                this.trace.log(BasicLevel.WARN, (Object)"Connection not valid");
                ret = false;
                Object var5_4 = null;
                if (stmt == null) return ret;
                try {
                    stmt.close();
                    return ret;
                }
                catch (Exception e) {}
                return ret;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

