/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;
import org.ow2.jonas.ee.jdbc.XAExceptionUtils;

public class XAResourceImpl
implements XAResource {
    private Xid currentXid = null;
    boolean started = false;
    boolean ended = true;
    protected ManagedConnectionImpl mc = null;
    private XAResource xares = null;

    public XAResourceImpl(ManagedConnectionImpl mc, XAResource xares) {
        this.mc = mc;
        this.xares = xares;
        if (mc.trace.isLoggable(BasicLevel.DEBUG)) {
            mc.trace.log(BasicLevel.DEBUG, (Object)("" + mc + "," + xares));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block24: {
            Exception commitException;
            block21: {
                block20: {
                    if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
                        this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid + "," + onePhase));
                    }
                    commitException = null;
                    if (this.xares != null) {
                        this.xares.commit(xid, onePhase);
                        if (xid.equals(this.currentXid)) {
                            this.started = false;
                        }
                        break block20;
                    }
                    if (this.currentXid == null || !this.currentXid.equals(xid) || !this.started) {
                        this.mc.trace.log(BasicLevel.ERROR, (Object)("passed xid(" + xid + "),current Xid(" + this.currentXid + "),started(" + this.started + ")"));
                        throw new XAException("Commit: Must call correct XAResource for its started XID");
                    }
                    this.mc.connection.commit();
                    this.started = false;
                }
                Object var6_4 = null;
                try {
                    this.mc.setAutoCommit(true);
                }
                catch (Exception exc) {
                    if (this.xares != null || !this.mc.trace.isLoggable(BasicLevel.DEBUG)) break block21;
                    this.mc.trace.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
                }
            }
            if (commitException != null) {
                this.mc.trace.log(BasicLevel.ERROR, (Object)commitException.getMessage());
                try {
                    this.mc.signalEvent(5, null, commitException);
                }
                catch (Exception ex) {
                    this.mc.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                }
            }
            break block24;
            {
                catch (XAException xe) {
                    this.mc.trace.log(BasicLevel.ERROR, (Object)xe.getMessage());
                    commitException = xe;
                    throw xe;
                }
                catch (SQLException e) {
                    block22: {
                        commitException = e;
                        XAExceptionUtils.throwXAException("Error on commit", (Throwable)e);
                        Object var6_5 = null;
                        try {
                            this.mc.setAutoCommit(true);
                        }
                        catch (Exception exc) {
                            if (this.xares != null || !this.mc.trace.isLoggable(BasicLevel.DEBUG)) break block22;
                            this.mc.trace.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
                        }
                    }
                    if (commitException != null) {
                        this.mc.trace.log(BasicLevel.ERROR, (Object)commitException.getMessage());
                        try {
                            this.mc.signalEvent(5, null, commitException);
                        }
                        catch (Exception ex) {
                            this.mc.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block23: {
                    Object var6_6 = null;
                    try {
                        this.mc.setAutoCommit(true);
                    }
                    catch (Exception exc) {
                        if (this.xares != null || !this.mc.trace.isLoggable(BasicLevel.DEBUG)) break block23;
                        this.mc.trace.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
                    }
                }
                if (commitException != null) {
                    this.mc.trace.log(BasicLevel.ERROR, (Object)commitException.getMessage());
                    try {
                        this.mc.signalEvent(5, null, commitException);
                    }
                    catch (Exception ex) {
                        this.mc.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                    }
                }
                throw throwable;
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid + "," + flags));
        }
        if (this.currentXid == null || !this.currentXid.equals(xid)) {
            throw new XAException(105);
        }
        if (!this.started && this.ended) {
            throw new XAException(105);
        }
        this.ended = true;
        if (this.xares != null) {
            this.xares.end(xid, flags);
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid));
        }
        if (this.xares != null) {
            this.xares.forget(xid);
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (this.xares != null) {
            return this.xares.getTransactionTimeout();
        }
        return 0;
    }

    public boolean isSameRM(XAResource xaRes) throws XAException {
        boolean ret = false;
        if (xaRes.equals(this)) {
            ret = true;
        } else if (!(xaRes instanceof XAResourceImpl)) {
            ret = false;
        } else {
            XAResourceImpl xaResImpl = (XAResourceImpl)xaRes;
            if (this.mc == xaResImpl.mc) {
                ret = true;
            }
        }
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xaRes + "," + this + " is " + ret));
        }
        return ret;
    }

    public int prepare(Xid xid) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid));
        }
        if (this.xares != null) {
            int ret = this.xares.prepare(xid);
            if (ret == 3) {
                this.started = false;
                try {
                    this.mc.setAutoCommit(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ret;
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + flag));
        }
        if (this.xares != null) {
            return this.xares.recover(flag);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void rollback(Xid xid) throws XAException {
        block24: {
            Exception rbException;
            block21: {
                block20: {
                    if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
                        this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid));
                    }
                    rbException = null;
                    if (this.xares != null) {
                        this.xares.rollback(xid);
                        if (xid.equals(this.currentXid)) {
                            this.started = false;
                        }
                        break block20;
                    }
                    if (this.currentXid == null || !this.currentXid.equals(xid) || !this.started) {
                        this.mc.trace.log(BasicLevel.ERROR, (Object)("passed xid(" + xid + "),current Xid(" + this.currentXid + "),started(" + this.started + ")"));
                        throw new XAException("Rollback: Must call correct XAResource for its started XID");
                    }
                    this.mc.connection.rollback();
                    this.started = false;
                }
                Object var5_3 = null;
                try {
                    this.mc.setAutoCommit(true);
                }
                catch (Exception exc) {
                    if (this.xares != null || !this.mc.trace.isLoggable(BasicLevel.DEBUG)) break block21;
                    this.mc.trace.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
                }
            }
            if (rbException != null) {
                try {
                    this.mc.trace.log(BasicLevel.ERROR, (Object)rbException.getMessage());
                    this.mc.signalEvent(5, null, rbException);
                }
                catch (Exception ex) {
                    this.mc.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                }
            }
            break block24;
            {
                catch (XAException xe) {
                    this.mc.trace.log(BasicLevel.ERROR, (Object)xe.getMessage());
                    rbException = xe;
                    throw xe;
                }
                catch (SQLException e) {
                    block22: {
                        rbException = e;
                        XAExceptionUtils.throwXAException("Error on rollback", (Throwable)e);
                        Object var5_4 = null;
                        try {
                            this.mc.setAutoCommit(true);
                        }
                        catch (Exception exc) {
                            if (this.xares != null || !this.mc.trace.isLoggable(BasicLevel.DEBUG)) break block22;
                            this.mc.trace.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
                        }
                    }
                    if (rbException != null) {
                        try {
                            this.mc.trace.log(BasicLevel.ERROR, (Object)rbException.getMessage());
                            this.mc.signalEvent(5, null, rbException);
                        }
                        catch (Exception ex) {
                            this.mc.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block23: {
                    Object var5_5 = null;
                    try {
                        this.mc.setAutoCommit(true);
                    }
                    catch (Exception exc) {
                        if (this.xares != null || !this.mc.trace.isLoggable(BasicLevel.DEBUG)) break block23;
                        this.mc.trace.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
                    }
                }
                if (rbException != null) {
                    try {
                        this.mc.trace.log(BasicLevel.ERROR, (Object)rbException.getMessage());
                        this.mc.signalEvent(5, null, rbException);
                    }
                    catch (Exception ex) {
                        this.mc.trace.log(BasicLevel.WARN, (Object)ex.getMessage());
                    }
                }
                throw throwable;
            }
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.xares != null) {
            return this.xares.setTransactionTimeout(seconds);
        }
        return false;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.mc.trace.isLoggable(BasicLevel.DEBUG)) {
            this.mc.trace.log(BasicLevel.DEBUG, (Object)("" + xid + "," + flags));
        }
        try {
            this.mc.setAutoCommit(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.mc.trace.log(BasicLevel.ERROR, (Object)("Unable to set autoCommit to false:" + ex.getMessage()));
            XAExceptionUtils.throwXAException("Error : Unable to set autoCommit to false in start", (Throwable)ex);
        }
        if (this.xares != null) {
            this.xares.start(xid, flags);
        } else if (this.started && (this.currentXid == null || !this.currentXid.equals(xid))) {
            this.mc.trace.log(BasicLevel.ERROR, (Object)"Must call correct XAResource for its started XID");
            throw new XAException("XAResourceImpl.start : Must call correct XAResource for its started XID");
        }
        this.currentXid = xid;
        this.started = true;
        this.ended = false;
    }
}

