/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ee.jdbc.ConnectionRequestInfoImpl;
import org.ow2.jonas.ee.jdbc.ManagedConnectionFactoryImpl;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;

public class DataSourceMCFImpl
extends ManagedConnectionFactoryImpl {
    DataSource ds = null;

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxReq) throws ResourceException {
        PasswordCredential pc = DataSourceMCFImpl.getPasswordCredential(this, subject, cxReq, this.pw);
        if (this.ds == null) {
            try {
                this.ds = (DataSource)DataSourceMCFImpl.getDataSource(this, pc, this.trace);
            }
            catch (Exception ex) {
                throw new ResourceException(ex.getMessage(), (Throwable)ex);
            }
        }
        Connection connection = null;
        try {
            if (cxReq != null) {
                ConnectionRequestInfoImpl cx = (ConnectionRequestInfoImpl)cxReq;
                connection = this.ds.getConnection(cx.getUser(), cx.getPassword());
            } else {
                connection = pc != null ? this.ds.getConnection(pc.getUserName(), new String(pc.getPassword())) : (this.mcfData.getMCFData(8).length() > 0 ? this.ds.getConnection(this.mcfData.getMCFData(8), this.mcfData.getMCFData(9)) : this.ds.getConnection());
            }
            if (this.trace.isLoggable(BasicLevel.DEBUG)) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Connection object returned is " + connection));
            }
        }
        catch (SQLException sqle) {
            throw new ResourceAllocationException("The connection could not be allocated: " + sqle.getMessage(), (Throwable)sqle);
        }
        if (connection == null) {
            this.trace.log(BasicLevel.ERROR, (Object)("DataSource " + this.ds + " returned a null Connection"));
            throw new ResourceAllocationException("DataSource returned a null Connection");
        }
        return new ManagedConnectionImpl(this, pc, connection, null, null, null);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSourceMCFImpl) {
            return this.mcfData.equals(((DataSourceMCFImpl)obj).mcfData);
        }
        return false;
    }

    public String getDatabaseName() {
        return this.mcfData.getMCFData(2);
    }

    public void setDatabaseName(String val) {
        this.mcfData.setMCFData(2, val);
    }

    public String getDescription() {
        return this.mcfData.getMCFData(4);
    }

    public void setDescription(String val) {
        this.mcfData.setMCFData(4, val);
    }

    public String getPortNumber() {
        return this.mcfData.getMCFData(5);
    }

    public void setPortNumber(String val) {
        this.mcfData.setMCFData(5, val);
    }

    public String getServerName() {
        return this.mcfData.getMCFData(6);
    }

    public void setServerName(String val) {
        this.mcfData.setMCFData(6, val);
    }
}

