/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;
import org.ow2.jonas.resource.internal.IJDBCConnection;
import org.ow2.jonas.resource.internal.SQLManager;
import org.ow2.jonas.resource.internal.cm.ManagedConnectionInfo;

public class ConnectionImpl
implements InvocationHandler {
    public Logger trace = null;
    ManagedConnectionImpl mc = null;
    Connection connection = null;
    PrintWriter pw = null;
    long key = 0L;
    String user = "";
    private SQLManager conman = null;
    private ManagedConnectionInfo mci = null;
    private final boolean isDebugging;

    protected ConnectionImpl(ManagedConnectionImpl _mc, Connection _con, long _key, PrintWriter _pw) {
        this.mc = _mc;
        this.connection = _con;
        this.key = _key;
        this.pw = _pw;
        this.trace = this.mc.trace;
        this.isDebugging = this.trace.isLoggable(BasicLevel.DEBUG);
        if (this.connection == null) {
            this.trace.log(BasicLevel.ERROR, (Object)"Init ConnectionImpl with a null Connection");
        }
    }

    public boolean isPhysicallyClosed() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.connection.isClosed();
    }

    public void setJonasInfo(ManagedConnectionInfo _mci, SQLManager _conman) {
        this.mci = _mci;
        this.conman = _conman;
    }

    public void setUser() {
        try {
            this.user = this.mc.getMetaData().getUserName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
            return this.handleObjectMethods(method, args);
        }
        if ("setJonasInfo".equals(method.getName())) {
            this.setJonasInfo((ManagedConnectionInfo)args[0], (SQLManager)args[1]);
            return null;
        }
        if ("isClosed".equals(method.getName())) {
            return this.isClosed();
        }
        if ("getKey".equals(method.getName())) {
            return this.getKey();
        }
        if ("isPhysicallyClosed".equals(method.getName())) {
            return this.isPhysicallyClosed();
        }
        if ("close".equals(method.getName())) {
            this.close(proxy);
            return null;
        }
        if ("setSignature".equals(method.getName())) {
            this.setSignature((Long)args[0]);
            return null;
        }
        if ("setUser".equals(method.getName())) {
            this.setUser();
            return null;
        }
        if ("prepareStatement".equals(method.getName()) && this.conman != null && this.conman.getMaxPstmtPoolSize() >= 0) {
            if (this.isDebugging) {
                this.trace.log(BasicLevel.DEBUG, (Object)method.getName());
            }
            try {
                this.checkContext();
            }
            catch (Exception e) {
                this.trace.log(BasicLevel.ERROR, (Object)"checkContext error");
                throw new SQLException("JOnAS JDBC: " + e.getMessage());
            }
            if (args.length == 1) {
                return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, (String)args[0]);
            }
            if (args.length == 3) {
                return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, (String)args[0], ((Integer)args[1]).intValue(), ((Integer)args[2]).intValue());
            }
            if (args.length == 4) {
                return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, (String)args[0], ((Integer)args[1]).intValue(), ((Integer)args[2]).intValue(), ((Integer)args[3]).intValue());
            }
            if (args.length == 2) {
                String sql = (String)args[0];
                Object val = args[1];
                if (val.getClass().isArray()) {
                    if (Integer.TYPE.equals(val.getClass().getComponentType())) {
                        return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql, ConnectionImpl.toArrayInt((Integer[])val));
                    }
                    if (String.class.equals(val.getClass().getComponentType())) {
                        return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql, (String[])val);
                    }
                } else if (val instanceof Integer) {
                    return this.conman.getPStatement(this.mci, (Object)this.connection, this.user, sql, ((Integer)val).intValue());
                }
            }
            throw new IllegalStateException("Invalid call with arguments '" + args + "' for the method '" + method.getName() + "'.");
        }
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)method.getName());
        }
        try {
            this.checkContext();
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"checkContext error");
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
        try {
            return method.invoke((Object)this.connection, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw targetException;
        }
    }

    public static int[] toArrayInt(Integer[] ints) {
        int[] values = new int[ints.length];
        int i = 0;
        for (Integer integer : ints) {
            values[i++] = integer;
        }
        return values;
    }

    protected Object handleObjectMethods(Method method, Object[] args) {
        String methodName = method.getName();
        if (methodName.equals("equals")) {
            if (Proxy.isProxyClass(args[0].getClass())) {
                return this.equals(Proxy.getInvocationHandler(args[0]));
            }
            return this.equals(args[0]);
        }
        if (methodName.equals("toString")) {
            return this.toString();
        }
        if (methodName.equals("hashCode")) {
            return this.hashCode();
        }
        throw new IllegalStateException("Method '" + methodName + "' is not present on Object.class.");
    }

    public void close(Object proxy) throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            if (this.key != 0L) {
                this.mc.close((IJDBCConnection)proxy);
                this.key = 0L;
            }
        }
        catch (Exception e) {
            this.trace.log(BasicLevel.ERROR, (Object)"error");
            e.printStackTrace();
            throw new SQLException("JOnAS JDBC: " + e.getMessage());
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.isDebugging) {
            this.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        return this.key == 0L;
    }

    private void checkContext() throws Exception {
        if (this.key == 0L) {
            this.trace.log(BasicLevel.ERROR, (Object)"Connection is closed");
            throw new Exception("Connection is closed");
        }
        if (this.key != this.mc.getSignature()) {
            if (this.mc.getSignature() == 0L) {
                this.mc.setSignature(this.key);
            } else {
                this.trace.log(BasicLevel.ERROR, (Object)"not current active Connection ");
                throw new Exception("Connection w/sig(" + this.key + ") is not current active Connection (" + this.mc.getSignature() + ")");
            }
        }
    }

    public void setSignature(long sig) {
        this.key = sig;
    }

    public long getKey() {
        return this.key;
    }
}

