/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ee.jdbc.ConnectionManagerImpl;
import org.ow2.jonas.ee.jdbc.ConnectionRequestInfoImpl;
import org.ow2.jonas.ee.jdbc.ManagedConnectionFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceImpl
implements DataSource,
Serializable,
Referenceable {
    private ConnectionManager cm;
    private ManagedConnectionFactoryImpl mcf;
    private PrintWriter pw;
    private Reference reference;
    int loginTimeout = 0;
    private final boolean isDebugOn;

    public DataSourceImpl(ManagedConnectionFactoryImpl _mcf, ConnectionManager _cm) {
        this.cm = _cm == null ? new ConnectionManagerImpl() : _cm;
        this.mcf = _mcf;
        this.isDebugOn = this.mcf.trace.isLoggable(BasicLevel.DEBUG);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isDebugOn) {
            this.mcf.trace.log(BasicLevel.DEBUG, (Object)"");
        }
        try {
            Connection con = (Connection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, null);
            if (con == null) {
                SQLException se = new SQLException("Null connection object returned");
                throw se;
            }
            return con;
        }
        catch (ResourceException re) {
            throw new SQLException(re.getMessage());
        }
    }

    @Override
    public Connection getConnection(String user, String pwd) throws SQLException {
        if (this.isDebugOn) {
            this.mcf.trace.log(BasicLevel.DEBUG, (Object)("" + user));
        }
        try {
            ConnectionRequestInfoImpl info = new ConnectionRequestInfoImpl(user, pwd);
            Connection con = (Connection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)info);
            if (con == null) {
                SQLException se = new SQLException("Null connection object returned");
                throw se;
            }
            return con;
        }
        catch (ResourceException re) {
            throw new SQLException(re.getMessage());
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.pw;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public void setLoginTimeout(int _loginTimeout) throws SQLException {
        this.loginTimeout = _loginTimeout;
    }

    @Override
    public void setLogWriter(PrintWriter _pw) throws SQLException {
        this.pw = _pw;
    }

    public void setReference(Reference _ref) {
        this.reference = _ref;
    }

    public String getMapperName() {
        String mn = this.mcf.getMapperName();
        if (this.isDebugOn) {
            this.mcf.trace.log(BasicLevel.DEBUG, (Object)mn);
        }
        return mn;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }
}

