/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ee.jdbc.ConnectionRequestInfoImpl;
import org.ow2.jonas.ee.jdbc.DriverWrapper;
import org.ow2.jonas.ee.jdbc.ManagedConnectionFactoryImpl;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;

public class DriverManagerMCFImpl
extends ManagedConnectionFactoryImpl {
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxReq) throws ResourceException {
        if (this.trace.isLoggable(BasicLevel.DEBUG)) {
            this.trace.log(BasicLevel.DEBUG, (Object)("subject:" + subject + " connectionRequest:" + cxReq));
        }
        PasswordCredential pc = DriverManagerMCFImpl.getPasswordCredential(this, subject, cxReq, this.pw);
        String clsName = null;
        DriverWrapper dWrap = null;
        try {
            clsName = this.mcfData.getMCFData(0);
            ClassLoader loader = this.getClass().getClassLoader();
            Driver d = (Driver)Class.forName(clsName, true, loader).newInstance();
            dWrap = new DriverWrapper(d);
            DriverManager.registerDriver(dWrap);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Driver d = (Driver)Class.forName(clsName, true, loader).newInstance();
                dWrap = new DriverWrapper(d);
                DriverManager.registerDriver(dWrap);
            }
            catch (Exception e) {
                throw new ResourceException("Class Name not found:" + clsName, (Throwable)e);
            }
        }
        catch (Exception ex) {
            throw new ResourceException("Error loading driver manager: " + clsName + " " + ex.getMessage(), (Throwable)ex);
        }
        Connection connection = null;
        try {
            String val = null;
            val = this.mcfData.getMCFData(10);
            if (val != null && val.length() > 0) {
                DriverManager.setLoginTimeout(Integer.parseInt(val));
            }
            if (cxReq != null) {
                ConnectionRequestInfoImpl cx = (ConnectionRequestInfoImpl)cxReq;
                connection = DriverManager.getConnection(this.mcfData.getMCFData(7), cx.getUser(), cx.getPassword());
            } else {
                connection = pc != null ? DriverManager.getConnection(this.mcfData.getMCFData(7), pc.getUserName(), new String(pc.getPassword())) : DriverManager.getConnection(this.mcfData.getMCFData(7), this.mcfData.getMCFData(8), this.mcfData.getMCFData(9));
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw new ResourceAllocationException("The connection could not be allocated: " + sqle.getMessage(), (Throwable)sqle);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ResourceAllocationException("Error on allocation: " + ex.getMessage(), (Throwable)ex);
        }
        ManagedConnectionImpl mci = new ManagedConnectionImpl(this, pc, connection, null, null, dWrap);
        if (this.trace.isLoggable(BasicLevel.DEBUG)) {
            this.trace.log(BasicLevel.DEBUG, (Object)("Create Mc=" + mci + " with connection=" + connection));
        }
        return mci;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DriverManagerMCFImpl) {
            return this.mcfData.equals(((DriverManagerMCFImpl)obj).mcfData);
        }
        return false;
    }
}

