/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.ow2.jonas.ee.jdbc.ConnectionRequestInfoImpl;
import org.ow2.jonas.ee.jdbc.ManagedConnectionFactoryImpl;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;

public class ConnectionPoolMCFImpl
extends ManagedConnectionFactoryImpl {
    ConnectionPoolDataSource ds = null;

    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxReq) throws ResourceException {
        PasswordCredential pc = ConnectionPoolMCFImpl.getPasswordCredential(this, subject, cxReq, this.pw);
        if (this.ds == null) {
            try {
                this.ds = (ConnectionPoolDataSource)ConnectionPoolMCFImpl.getDataSource(this, pc, this.trace);
            }
            catch (Exception ex) {
                throw new ResourceException(ex.getMessage(), (Throwable)ex);
            }
        }
        PooledConnection pConnection = null;
        Connection connection = null;
        try {
            if (cxReq != null) {
                ConnectionRequestInfoImpl cx = (ConnectionRequestInfoImpl)cxReq;
                pConnection = this.ds.getPooledConnection(cx.getUser(), cx.getPassword());
            } else {
                pConnection = pc != null ? this.ds.getPooledConnection(pc.getUserName(), new String(pc.getPassword())) : (this.mcfData.getMCFData(8).length() > 0 ? this.ds.getPooledConnection(this.mcfData.getMCFData(8), this.mcfData.getMCFData(9)) : this.ds.getPooledConnection());
            }
            if (pConnection != null) {
                connection = pConnection.getConnection();
            }
        }
        catch (SQLException sqle) {
            throw new ResourceAllocationException("The connection could not be allocated: " + sqle.getMessage(), (Throwable)sqle);
        }
        return new ManagedConnectionImpl(this, pc, connection, pConnection, null, null);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConnectionPoolMCFImpl) {
            return this.mcfData.equals(((ConnectionPoolMCFImpl)obj).mcfData);
        }
        return false;
    }

    public String getDatabaseName() {
        return this.mcfData.getMCFData(2);
    }

    public void setDatabaseName(String val) {
        this.mcfData.setMCFData(2, val);
    }

    public String getDescription() {
        return this.mcfData.getMCFData(4);
    }

    public void setDescription(String val) {
        this.mcfData.setMCFData(4, val);
    }

    public String getPortNumber() {
        return this.mcfData.getMCFData(5);
    }

    public void setPortNumber(String val) {
        this.mcfData.setMCFData(5, val);
    }

    public String getServerName() {
        return this.mcfData.getMCFData(6);
    }

    public void setServerName(String val) {
        this.mcfData.setMCFData(6, val);
    }
}

