/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.ee.jdbc.ConnectionRequestInfoImpl;
import org.ow2.jonas.ee.jdbc.ManagedConnectionFactoryImpl;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;

public class XAMCFImpl
extends ManagedConnectionFactoryImpl {
    XADataSource ds = null;

    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxReq) throws ResourceException {
        this.trace.log(BasicLevel.DEBUG, (Object)"");
        PasswordCredential pc = XAMCFImpl.getPasswordCredential(this, subject, cxReq, this.pw);
        if (this.ds == null) {
            try {
                this.ds = (XADataSource)XAMCFImpl.getDataSource(this, pc, this.trace);
            }
            catch (Exception ex) {
                this.trace.log(BasicLevel.WARN, (Object)("Cannot get DataSource:" + ex));
                throw new ResourceException(ex.getMessage(), (Throwable)ex);
            }
        }
        XAConnection xaConnection = null;
        Connection connection = null;
        try {
            if (cxReq != null) {
                ConnectionRequestInfoImpl cx = (ConnectionRequestInfoImpl)cxReq;
                xaConnection = this.ds.getXAConnection(cx.getUser(), cx.getPassword());
            } else {
                xaConnection = pc != null ? this.ds.getXAConnection(pc.getUserName(), new String(pc.getPassword())) : (this.mcfData.getMCFData(8).length() > 0 ? this.ds.getXAConnection(this.mcfData.getMCFData(8), this.mcfData.getMCFData(9)) : this.ds.getXAConnection());
            }
            if (xaConnection != null) {
                connection = xaConnection.getConnection();
            }
        }
        catch (SQLException sqle) {
            this.trace.log(BasicLevel.WARN, (Object)("The connection could not be allocated: " + sqle));
            throw new ResourceAllocationException("The connection could not be allocated: " + sqle.getMessage(), (Throwable)sqle);
        }
        ManagedConnectionImpl mc = new ManagedConnectionImpl(this, pc, connection, null, xaConnection, null);
        if (this.trace.isLoggable(BasicLevel.DEBUG)) {
            this.trace.log(BasicLevel.DEBUG, (Object)("Returning: " + mc));
        }
        return mc;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof XAMCFImpl) {
            return this.mcfData.equals(((XAMCFImpl)obj).mcfData);
        }
        return false;
    }

    public String getDatabaseName() {
        return this.mcfData.getMCFData(2);
    }

    public void setDatabaseName(String val) {
        this.mcfData.setMCFData(2, val);
    }

    public String getDescription() {
        return this.mcfData.getMCFData(4);
    }

    public void setDescription(String val) {
        this.mcfData.setMCFData(4, val);
    }

    public String getPortNumber() {
        return this.mcfData.getMCFData(5);
    }

    public void setPortNumber(String val) {
        this.mcfData.setMCFData(5, val);
    }

    public String getServerName() {
        return this.mcfData.getMCFData(6);
    }

    public void setServerName(String val) {
        this.mcfData.setMCFData(6, val);
    }
}

