/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.jdbc;

import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.ee.jdbc.ManagedConnectionImpl;
import org.ow2.jonas.ee.jdbc.XAExceptionUtils;
import org.ow2.jonas.lib.util.Log;

public class XAResourceImpl
implements XAResource {
    private Xid currentXid = null;
    boolean started = false;
    boolean ended = true;
    protected ManagedConnectionImpl mc = null;
    private XAResource xares = null;
    protected Logger xalog = null;

    public XAResourceImpl(ManagedConnectionImpl mc, XAResource xares) {
        this.mc = mc;
        this.xares = xares;
        this.xalog = Log.getLoggerFactory().getLogger("org.ow2.jonas.ee.jdbc.xa");
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("mc=" + mc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("mc=" + this.mc + "   xid=" + xid + "," + onePhase));
        }
        Exception commitException = null;
        try {
            if (this.xares != null) {
                this.xares.commit(xid, onePhase);
                if (xid.equals(this.currentXid)) {
                    this.started = false;
                }
            } else {
                if (this.currentXid == null || !this.currentXid.equals(xid) || !this.started) {
                    this.xalog.log(BasicLevel.ERROR, (Object)("passed xid(" + xid + "),current Xid(" + this.currentXid + "),started(" + this.started + ")"));
                    throw new XAException("Commit: Must call correct XAResource for its started XID");
                }
                this.mc.connection.commit();
                this.started = false;
            }
        }
        catch (XAException xe) {
            this.xalog.log(BasicLevel.ERROR, (Object)xe.getMessage());
            commitException = xe;
            throw xe;
        }
        catch (SQLException e) {
            commitException = e;
            XAExceptionUtils.throwXAException("Error on commit", (Throwable)e);
        }
        finally {
            block25: {
                try {
                    this.mc.setAutoCommit(true);
                }
                catch (Exception exc) {
                    if (this.xares != null || !this.xalog.isLoggable(BasicLevel.DEBUG)) break block25;
                    this.xalog.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
                }
            }
            if (commitException != null) {
                this.xalog.log(BasicLevel.ERROR, (Object)commitException.getMessage());
                try {
                    this.mc.signalEvent(5, null, commitException);
                }
                catch (Exception ex) {
                    this.xalog.log(BasicLevel.WARN, (Object)ex.getMessage());
                }
            }
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("mc=" + this.mc + "   xid=" + xid + "," + flags));
        }
        if (this.currentXid == null || !this.currentXid.equals(xid)) {
            throw new XAException(105);
        }
        if (!this.started && this.ended) {
            throw new XAException(105);
        }
        this.ended = true;
        if (this.xares != null) {
            this.xares.end(xid, flags);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("mc=" + this.mc + "   xid=" + xid));
        }
        if (this.xares != null) {
            this.xares.forget(xid);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (this.xares != null) {
            return this.xares.getTransactionTimeout();
        }
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        boolean ret = false;
        if (xaRes.equals(this)) {
            ret = true;
        } else if (!(xaRes instanceof XAResourceImpl)) {
            ret = false;
        } else {
            XAResourceImpl xaResImpl = (XAResourceImpl)xaRes;
            if (this.mc == xaResImpl.mc) {
                ret = true;
            }
        }
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("" + xaRes + "," + this + " is " + ret));
        }
        return ret;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("mc=" + this.mc + "   xid=" + xid));
        }
        if (this.xares != null) {
            int ret = this.xares.prepare(xid);
            if (ret == 3) {
                this.started = false;
            }
            return ret;
        }
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("mc=" + this.mc));
        }
        if (this.xares != null) {
            return this.xares.recover(flag);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("mc=" + this.mc + "   xid=" + xid));
        }
        Exception rbException = null;
        try {
            if (this.xares != null) {
                this.xares.rollback(xid);
                if (xid.equals(this.currentXid)) {
                    this.started = false;
                }
            } else {
                if (this.currentXid == null || !this.currentXid.equals(xid) || !this.started) {
                    this.xalog.log(BasicLevel.ERROR, (Object)("passed xid(" + xid + "),current Xid(" + this.currentXid + "),started(" + this.started + ")"));
                    throw new XAException("Rollback: Must call correct XAResource for its started XID");
                }
                if (this.mc.connection != null) {
                    this.mc.connection.rollback();
                }
                this.started = false;
            }
        }
        catch (XAException xe) {
            this.xalog.log(BasicLevel.ERROR, (Object)xe.getMessage());
            rbException = xe;
            throw xe;
        }
        catch (SQLException e) {
            rbException = e;
            XAExceptionUtils.throwXAException("Error on rollback", (Throwable)e);
        }
        finally {
            block26: {
                try {
                    this.mc.setAutoCommit(true);
                }
                catch (Exception exc) {
                    if (this.xares != null || !this.xalog.isLoggable(BasicLevel.DEBUG)) break block26;
                    this.xalog.log(BasicLevel.DEBUG, (Object)"Unable to set autoCommit to true:", (Throwable)exc);
                }
            }
            if (rbException != null) {
                try {
                    this.xalog.log(BasicLevel.ERROR, (Object)rbException.getMessage());
                    this.mc.signalEvent(5, null, rbException);
                }
                catch (Exception ex) {
                    this.xalog.log(BasicLevel.WARN, (Object)ex.getMessage());
                }
            }
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.xares != null) {
            return this.xares.setTransactionTimeout(seconds);
        }
        return false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.xalog.isLoggable(BasicLevel.DEBUG)) {
            this.xalog.log(BasicLevel.DEBUG, (Object)("" + xid + "," + flags));
        }
        try {
            this.mc.setAutoCommit(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.xalog.log(BasicLevel.ERROR, (Object)("Unable to set autoCommit to false:" + ex.getMessage()));
            XAExceptionUtils.throwXAException("Error : Unable to set autoCommit to false in start", (Throwable)ex);
        }
        if (this.xares != null) {
            this.xares.start(xid, flags);
        } else if (this.started && (this.currentXid == null || !this.currentXid.equals(xid))) {
            this.xalog.log(BasicLevel.ERROR, (Object)"Must call correct XAResource for its started XID");
            throw new XAException("XAResourceImpl.start : Must call correct XAResource for its started XID");
        }
        this.currentXid = xid;
        this.started = true;
        this.ended = false;
    }
}

