/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.tenant;

import org.ow2.util.ee.deploy.api.deployable.IDeployableInfo;

/**
 * Contains tenant-id to add to deployable
 * @author Mohammed Boukada
 */
public class TenantIdInfo implements IDeployableInfo {

    /**
     * Tenant id value
     */
    private String tenantIdInfo;

    /**
     * Default constructor
     */
    public TenantIdInfo () {}

    /**
     * Gets the tenant id
     * @return tenant id
     */
    public String getTenantIdInfo () {
        return this.tenantIdInfo;
    }

    /**
     * Sets the tenant id
     * @param tenantIdInfo tenant id
     */
    public void setTenantIdInfo (String tenantIdInfo) {
        this.tenantIdInfo = tenantIdInfo;
    }

}
