/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.log;

import java.util.AbstractCollection;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.LogRecord;

public class RecordFeeder
implements Runnable {
    private int maxRecFetch = 10;
    private long timeout = 333L;
    private LinkedList source = null;
    private TreeSet records = null;
    private int maxRecords = 100000;

    public RecordFeeder(LinkedList queue, TreeSet recordSet) {
        this.source = queue;
        this.records = recordSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LogRecord[] recs = null;
        while (!Thread.currentThread().isInterrupted()) {
            int i;
            TreeSet treeSet;
            recs = this.readRecords();
            if (recs == null) continue;
            int overflow = recs.length + this.records.size() - this.maxRecords;
            if (overflow > 0) {
                treeSet = this.records;
                synchronized (treeSet) {
                    for (i = 0; i < overflow; ++i) {
                        this.records.remove(this.records.first());
                    }
                }
            }
            treeSet = this.records;
            synchronized (treeSet) {
                for (i = 0; i < recs.length; ++i) {
                    this.records.add(recs[i]);
                }
            }
            Thread.yield();
        }
        AbstractCollection abstractCollection = this.records;
        synchronized (abstractCollection) {
            this.records.clear();
        }
        abstractCollection = this.source;
        synchronized (abstractCollection) {
            this.source.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord[] readRecords() {
        LogRecord[] records = null;
        while (!Thread.currentThread().isInterrupted() && records == null) {
            Object object = this.source;
            synchronized (object) {
                int sz = this.source.size();
                if (sz > 0) {
                    sz = sz > this.maxRecFetch ? this.maxRecFetch : sz;
                    records = new LogRecord[sz];
                    for (int i = 0; i < sz; ++i) {
                        records[i] = (LogRecord)this.source.removeFirst();
                    }
                }
            }
            if (records != null) continue;
            try {
                object = this;
                synchronized (object) {
                    this.wait(this.timeout);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return records;
    }

    public void setMaxRecords(int max) {
        this.maxRecords = max;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecFetch(int max) {
        this.maxRecFetch = max;
    }

    public int getMaxRecFetch() {
        return this.maxRecords;
    }
}

