/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999-2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: LogManagementMBean.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.log;

import java.util.Map;
import java.util.Properties;

import org.objectweb.util.monolog.api.TopicalLogger;

/**
 * MBean interface for Logger management.
 * @author Philippe Durieux
 * @author Adriana Danes
 */
public interface LogManagementMBean {

    /**
     * Assumes that all Loggers are {@link TopicalLogger}.
     * @return Returns the topics name list.
     */
    String[] getTopics();

    /**
     * @param topic the topic we need to know its level.
     * @return Returns a topic's level.
     */
    String getTopicLevel(String topic);

    /**
     * Set a Topic's level.
     * @param topic topic name.
     * @param level the level to set on the given topic.
     */
    void setTopicLevel(String topic, String level);

    /**
     * @return Returns the list of logging system configuration properties.
     */
    Properties getProperties();

    /**
     * Saves the current configuration.
     */
    void saveConfig();

    /**
     * @return Returns the names of the Monolog handlers.
     */
    String[] getHandlerNames();

    /**
     * @param handlerName the handler name.
     * @return Returns the Map of the handler's configuration attributes.
     */
    Map getHandlerAttributes(String handlerName);
}
