/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.mail;

import java.io.File;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.AbstractJOnASBaseAntTask;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;

public class Mail
extends AbstractJOnASBaseAntTask {
    private static final String INFO = "[Mail] ";
    private static final String MAILFACTORY_PROPERTY = "jonas.service.mail.factories";
    private static final String SESSION_FACTORY = "Session";
    private static final String MIMEPARTDATASOURCE_FACTORY = "MimePartDataSource";
    private static final String SESSION_FACTORY_CLASS = "javax.mail.Session";
    private static final String MIMEPARTDATASOURCE_FACTORY_CLASS = "javax.mail.internet.MimePartDataSource";
    private String type = null;
    private String name = null;
    private String mailTo = null;
    private String subject = null;
    private String host = null;

    public void setMailTo(String mailTo) {
        this.mailTo = mailTo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHost(String host) {
        this.host = host;
    }

    private void checkProperties() {
        if (this.name == null) {
            throw new BuildException("[Mail] Property 'name' is missing.");
        }
        if (this.type == null) {
            throw new BuildException("[Mail] Property 'type' is missing.");
        }
    }

    public void execute() {
        super.execute();
        this.checkProperties();
        Properties props = new Properties();
        props.put("mail.factory.name", this.name);
        String className = null;
        String infoTxt = "Generating a MailFactory with type '" + this.type + "' and name '" + this.name + "'";
        if (this.host != null) {
            props.put("mail.host", this.host);
        }
        if (this.type.equalsIgnoreCase(SESSION_FACTORY)) {
            className = SESSION_FACTORY_CLASS;
        } else if (this.type.equalsIgnoreCase(MIMEPARTDATASOURCE_FACTORY)) {
            className = MIMEPARTDATASOURCE_FACTORY_CLASS;
            if (this.mailTo != null) {
                props.put("mail.to", this.mailTo);
                infoTxt = infoTxt + ", mailTo field '" + this.mailTo + "'";
            }
            if (this.subject != null) {
                props.put("mail.subject", this.subject);
                infoTxt = infoTxt + ", subject '" + this.subject + "'";
            }
        } else {
            throw new BuildException("[Mail] Invalid type '" + this.type + "'.");
        }
        this.log(INFO + infoTxt + "...");
        props.put("mail.factory.type", className);
        String jBaseConf = this.destDir.getPath() + File.separator + "conf";
        String propsFileName = jBaseConf + File.separator + this.name + ".properties";
        File tmpFile = new File(propsFileName);
        JTask jtask = new JTask();
        jtask.setDestDir(this.destDir);
        jtask.writePropsToFile(INFO, props, tmpFile);
        jtask.changeValueForKey(INFO, jBaseConf, "jonas.properties", MAILFACTORY_PROPERTY, this.name, true);
        this.addTask((BaseTaskItf)jtask);
        super.executeAllTask();
    }
}

