/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.mail;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.ow2.jonas.antmodular.bootstrap.JOnASAntTool;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.BaseTaskItf;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.DeployableSelector;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;

public class DeployableTask
extends JTask
implements BaseTaskItf {
    private static final String INFO = "[Deployable] ";
    private static final String DEPSEPARATOR_PROPERTY = ",";
    private static final String TARGET_EXCLUDE_PROPERTY = "exclude";
    private static final String TARGET_COPY_PROPERTY = "copy";
    File f_srcDir;
    File f_dstDir;
    private String extension = null;
    private String values = null;
    private String srcDir = null;
    private String dstDir = null;
    private String target = null;

    public String getSrcDir() {
        return this.srcDir;
    }

    public void setSrcDir(String sourceDir) {
        this.srcDir = sourceDir;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getValues() {
        return this.values;
    }

    public void setValues(String values) {
        this.values = values;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    private void checkParameters() {
        try {
            this.f_dstDir = new File(this.getDestDir().getPath(), this.dstDir);
            if (this.extension == null || this.values == null || this.target == null) {
                throw new BuildException("[Deployable] Property 'extension' or 'values' is incorrect.");
            }
            if (TARGET_COPY_PROPERTY.equalsIgnoreCase(this.target)) {
                this.f_srcDir = new File(this.srcDir);
                if (!this.f_srcDir.exists()) {
                    throw new BuildException("[Deployable] Property 'sourceDir'is incorrect.");
                }
            } else if (!TARGET_EXCLUDE_PROPERTY.equalsIgnoreCase(this.target)) {
                throw new BuildException("[Deployable] Unsupported target '" + this.target + "'. Possible values are :'" + TARGET_COPY_PROPERTY + ", " + TARGET_EXCLUDE_PROPERTY + "'");
            }
            if (!this.f_dstDir.exists()) {
                throw new BuildException("[Deployable] Property 'destDir'is incorrect.");
            }
        }
        catch (Exception e) {
            throw new BuildException("[Deployable] Properties are incorrect.");
        }
    }

    public String getDstDir() {
        return this.dstDir;
    }

    public void setDstDir(String destDir) {
        this.dstDir = destDir;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void execute() {
        this.checkParameters();
        ArrayList<String> deployables = new ArrayList<String>();
        this.parseDeployableValues(this.values, deployables);
        if (TARGET_COPY_PROPERTY.equalsIgnoreCase(this.target)) {
            this.log("[Deployable] Copying Type: " + this.extension + " values :" + deployables + " from " + this.f_srcDir.getAbsolutePath() + " to " + this.f_dstDir.getAbsolutePath());
            Copy copyTask = new Copy();
            JOnASAntTool.configure((Task)this, (Task)copyTask);
            copyTask.setFailOnError(true);
            copyTask.setTodir(this.f_dstDir);
            FileSet fset = new FileSet();
            fset.setDir(this.f_srcDir);
            DeployableSelector selector = new DeployableSelector(deployables);
            fset.add((FileSelector)selector);
            copyTask.addFileset(fset);
            copyTask.execute();
        } else {
            this.log("[Deployable] Excluding Type: " + this.extension + " values :" + this.values + " from " + this.f_dstDir.getAbsolutePath() + " deployables: " + deployables);
            File toDelete = null;
            for (String fileName : deployables) {
                toDelete = new File(this.f_dstDir, fileName);
                if (!toDelete.exists()) continue;
                this.log("[Deployable] Deleting " + toDelete.getAbsolutePath());
                toDelete.delete();
            }
        }
    }

    private void parseDeployableValues(String values2Parse, List<String> deplList) {
        if (values2Parse != null) {
            int ind = values2Parse.indexOf(DEPSEPARATOR_PROPERTY);
            String dep = null;
            File depF = null;
            if (ind != -1) {
                dep = values2Parse.substring(0, ind) + "." + this.extension;
                depF = new File(this.f_srcDir.getAbsolutePath(), dep);
                if (depF.exists()) {
                    deplList.add(dep);
                }
                this.parseDeployableValues(values2Parse.substring(ind + 1, values2Parse.length()), deplList);
            } else {
                dep = values2Parse + "." + this.extension;
                depF = TARGET_COPY_PROPERTY.equalsIgnoreCase(this.target) ? new File(this.f_srcDir.getAbsolutePath(), dep) : new File(this.f_dstDir.getAbsolutePath(), dep);
                if (depF.exists()) {
                    deplList.add(dep);
                }
            }
        }
    }
}

