/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or 1any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IDomain.java 14473 2008-07-08 08:54:20Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.management.extensions.domain.api;
/**
 * This interface provides a description of management operations
 * provided for domain management in a master server.
 * @author Adriana Danes
 * @author Oualaa Hani
 */
public interface IDomain {

    /**
     * Get the name of the server providing the ManagementEntryEndpoint.
     * @return the local server name.
     */
    String getServerName();
    /**
     * Get the domain name.
     * @return the domain name.
     */
    String getDomainName();
    /**
     * Return True if the managed server is master.
     * @param serverName managed server name
     */
    boolean isMaster(final String serverName);

    /**
     * Return True if the current server is a master.
     */
    boolean isMaster();

    /**
     * Return the type of a cluster in the current domain.
     * @param clusterName the cluster's name
     */
    String getClusterType(final String clusterName);

    /**
     * Return the server names that are belonging to the domain.
     */
    String[] getServerNames();

    /**
     * Return the server names that are belonging to a cluster.
     * @param clusterName the cluster name
     */
    String[] getServerNames(final String clusterName);

    /**
     * Return the clusters in the domain.
     */
    String[] getClusters();

    /**
     * Return the cluster daemons in the domain.
     */
    String[] getclusterDaemons();

    /**
     * Return the state of a server in the domain
     * @param serverName the server's name
     */
    String getServerState(final String serverName);

    /**
     * Return the cluster daemon of a server in the domain.
     * @param serverName the server's name
     */
    String getServerClusterdaemon(final String serverName);

    /**
     * Return the state of a cluster in the domain.
     * @param clusterName the cluster's name
     */
    String getClusterState(final String clusterName);

    /**
     * Return the state of a cluster daemon in the domain.
     * @param clusterdaemonName the cluster daemon's name.
     */
    String getClusterdaemonState(final String clusterdaemonName);

    /**
     * Return names of cluster in the domaine
     */
    String[] getClustersNames();

    /**
     * Return names of clustersdaemon in the domaine
     */
    String[] getClusterdaemonNames();

}
