/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or 1any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: IServer.java 14473 2008-07-08 08:54:20Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.management.extensions.server.api;


/**
 * This interface provides a description of management operations
 * provided for a server instance management in a domain.
 * @author Adriana Danes
 * @author Oualaa Hani
 */
public interface IServer {
    /**
     * Get the version of a server in the domain.
     * @param pServer the server's name.
     * @return the server's version
     */
    String getServerVersion(final String pServer);
    /**
     * Get the memory used by a server in the domain.
     * @param pServer the server's name.
     * @return the used memory
     */
    long currentUsedMemory(final String pServer);
}
