/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: J2EEServerMBean.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.jmbeans;

import java.util.ArrayList;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;

import org.apache.commons.modeler.BaseModelMBean;

/**
 * J2EEServer MBean implementation.
 * @author Adriana.Danes@bull.net
 */
public class J2EEServerMBean extends BaseModelMBean {

    public J2EEServerMBean() throws MBeanException, RuntimeOperationsException {
        super();
    }

    /**
     * Implement the state attribute.
     * @return the current server's state
     * @throws InstanceNotFoundException
     * @throws RuntimeOperationsException
     * @throws MBeanException
     * @throws InvalidTargetObjectTypeException
     */
    public String getState() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        J2EEServer.State state =  ((J2EEServer) getManagedResource()).getState();
        switch(state) {
            case STARTING :
                return "STARTING";
            case RUNNING :
                return "RUNNING";
            case STOPPING :
                return "STOPPING";
            case STOPPED :
                return "STOPPED";
            case FAILED :
                return "FAILED";
            default:
                return "unknown";
        }
    }


    /**
     * Implement resources attribute.
     * @return the list of J2EEResource names in the current server
     * @throws InstanceNotFoundException
     * @throws RuntimeOperationsException
     * @throws MBeanException
     * @throws InvalidTargetObjectTypeException
     */
    public String[] getResources() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        ArrayList<String> resourceList = ((J2EEServer) getManagedResource()).getResources();
        String[] result = new String[resourceList.size()];
        return resourceList.toArray(result);
    }
}
