/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServiceManagerUpdater.java 12707 2008-01-27 11:59:29Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.jmbeans;

import org.ow2.jonas.properties.ServerProperties;

/**
 * Service called to update the ServiceManager with service states.
 * @author Francois Fornaciari
 */
public interface ServiceManagerUpdater {
    /**
     * Update the ServiceManager with service states.
     * @param props JOnAS properties
     * @throws Exception Thrown if the update fails
     */
    void updateServiceManager(ServerProperties props) throws Exception;
}
