/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans.osgi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.ow2.jonas.Version;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.jmbeans.J2EEServer;
import org.ow2.jonas.lib.jmbeans.JavaVm;
import org.ow2.jonas.lib.jmbeans.LogManager;
import org.ow2.jonas.lib.jmbeans.OsgiServiceListener;
import org.ow2.jonas.lib.jmbeans.OsgiServicesUtil;
import org.ow2.jonas.lib.jmbeans.ReconfigManager;
import org.ow2.jonas.lib.jmbeans.ServiceManager;
import org.ow2.jonas.lib.jmbeans.ServiceManagerUpdater;
import org.ow2.jonas.lib.management.domain.J2EEDomain;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.timer.TimerManager;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.util.ee.deploy.api.archive.IArchiveManager;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;

public class MBeansRegistration
implements ServiceManagerUpdater {
    private static final String LOG_CONFIGFILE = "jonas.log.configfile";
    private static final String DEF_LOG_CONFIGFILE = "trace";
    private String logConfigFile = null;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.lib.jmbeans");
    private JmxService jmxService = null;
    private RegistryService registryService = null;
    private ConfigurationManager configManager = null;
    private String domainName = null;
    private String serverName = null;
    private BundleContext bc = null;
    private J2EEServer server = null;
    private ServerProperties serverProperties = null;
    private IDeployerManager deployerManager = null;
    private IArchiveManager archiveManager = null;
    private TimerManager tm = null;
    private ServiceManager serviceManager = null;

    public MBeansRegistration(BundleContext bc) {
        this.bc = bc;
    }

    public void start() throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)"Starting jonas-mbeans Bundle...");
        try {
            this.domainName = this.serverProperties.getDomainName();
            this.serverName = this.serverProperties.getServerName();
            this.tm = TimerManager.getInstance();
            String logConfigFileName = this.serverProperties.getValue(LOG_CONFIGFILE, DEF_LOG_CONFIGFILE);
            Log.configure((String)logConfigFileName);
            Properties logProperties = Log.getProperties();
            this.logConfigFile = Log.getConfigFileName();
            this.registerMBeans(this.serverProperties, logProperties);
            this.serverProperties = null;
        }
        catch (MalformedObjectNameException me) {
            logger.log(BasicLevel.ERROR, (Object)("Failed to register mbeans: " + me.getMessage()));
            return;
        }
        catch (Exception e) {
            System.out.println("Failed to register mbeans");
            e.printStackTrace();
            return;
        }
    }

    public void stop() throws Exception {
        logger.log(BasicLevel.DEBUG, (Object)"Stopping jonas-mbeans Bundle...");
        if (this.jmxService != null) {
            this.unregisterMBeans(this.domainName, this.serverName);
        }
        this.registryService = null;
    }

    private void registerMBeans(ServerProperties props, Properties logProps) throws Exception {
        String name = this.domainName + ":j2eeType=J2EEServer,name=" + this.serverName;
        ObjectName serverOn = ObjectName.getInstance(name);
        this.server = new J2EEServer(serverOn.toString(), true, false, true, this.bc);
        this.server.setServerVendor("OW2 (former ObjectWeb)");
        this.server.setServerVersion(Version.getNumber());
        this.server.setServerName(this.serverName);
        this.server.setDomainName(this.domainName);
        this.server.setAllProperties(props);
        this.server.setJonasBase(props.getValue("jonas.base"));
        this.server.setJonasRoot(props.getValue("jonas.root"));
        this.server.setProtocols(this.getProtocols());
        this.server.setArchiveManager(this.archiveManager);
        this.server.setDeployerManager(this.deployerManager);
        this.server.setConfigManager(this.configManager);
        this.server.initRepositoryDirs();
        String versions = "Versions";
        this.server.setVersions(versions);
        this.server.setTimerManager(this.tm);
        this.server.setActivated(true);
        Package p = this.server.getClass().getPackage();
        this.jmxService.loadDescriptors(p.getName(), this.getClass().getClassLoader());
        this.jmxService.registerModelMBean((Object)this.server, serverOn);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + serverOn.toString()));
        ObjectName domainOn = J2eeObjectName.J2EEDomain((String)this.domainName);
        J2EEDomain domain = new J2EEDomain(domainOn.toString());
        domain.setJmxService(this.jmxService);
        boolean master = props.isMaster();
        domain.setMaster(master, this.serverName);
        this.jmxService.registerModelMBean((Object)domain, domainOn);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + domainOn.toString()));
        domain.setMyJ2EEServerOn(serverOn.toString());
        String jvmName = this.serverName;
        ObjectName objectName = J2eeObjectName.JVM((String)this.domainName, (String)this.serverName, (String)jvmName);
        JavaVm jvm = new JavaVm(objectName.toString(), props);
        this.jmxService.registerModelMBean((Object)jvm, objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + objectName.toString()));
        this.server.addJavaVM(objectName.toString());
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + objectName));
        String nameReconfigManager = this.domainName + ":type=management,name=reconfigManager";
        objectName = ObjectName.getInstance(nameReconfigManager);
        ReconfigManager reconfigManager = new ReconfigManager(objectName, props);
        reconfigManager.setJmxService(this.jmxService);
        reconfigManager.setLogConfigFileName(this.logConfigFile);
        reconfigManager.setServerConfigFileName(props.getPropFileName());
        reconfigManager.addMBeanServerDelegateListener();
        this.jmxService.registerModelMBean((Object)reconfigManager, objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + objectName.toString()));
        String nameLogging = this.domainName + ":type=service,name=log";
        objectName = ObjectName.getInstance(nameLogging);
        LogManager logManager = new LogManager(objectName.toString());
        logManager.setProps(logProps);
        logManager.setConfigFile(this.logConfigFile);
        this.jmxService.registerModelMBean((Object)logManager, objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans registered: " + objectName.toString()));
        this.serviceManager = new ServiceManager(this.server);
        this.server.setServiceManager(this.serviceManager);
        this.updateServiceManager(props);
        OsgiServiceListener listener = new OsgiServiceListener(this.serviceManager);
        this.bc.addServiceListener((ServiceListener)listener);
    }

    private void unregisterMBeans(String domainName, String serverName) throws Exception {
        String name = domainName + ":j2eeType=J2EEServer,name=" + serverName;
        ObjectName objectName = ObjectName.getInstance(name);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
        String jvmName = serverName;
        objectName = J2eeObjectName.JVM((String)domainName, (String)serverName, (String)jvmName);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
        objectName = J2eeObjectName.J2EEDomain((String)domainName);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
        String nameLogging = domainName + ":type=service,name=log";
        objectName = ObjectName.getInstance(nameLogging);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
        String nameReconfigManager = domainName + ":type=management,name=reconfigManager";
        objectName = ObjectName.getInstance(nameReconfigManager);
        this.jmxService.unregisterModelMBean(objectName);
        logger.log(BasicLevel.DEBUG, (Object)("MBeans unregistered: " + objectName.toString()));
    }

    private String getProtocols() {
        String protocols = "";
        String prefix = "rmi/";
        List protocolList = this.registryService.getActiveProtocolNames();
        for (String protocolName : protocolList) {
            if (protocols == "") {
                protocols = prefix + protocolName;
                continue;
            }
            protocols = protocols + "," + prefix + protocolName;
        }
        return protocols;
    }

    public void updateServiceManager(ServerProperties props) throws Exception {
        ArrayList<String> runningServices = OsgiServicesUtil.getJonasServices(this.bc);
        String[] services = props.getValueAsArray("jonas.services");
        this.serviceManager.deleteAllServices();
        for (String service : services) {
            if (service.equals("registry") || service.equals("jmx")) continue;
            this.serviceManager.addService(service);
            if (!runningServices.contains(service)) continue;
            this.serviceManager.setServiceState(service, OsgiServicesUtil.runningState());
        }
    }

    public void setVersioningService(VersioningService versioningService) {
        this.server.setVersioningService(versioningService);
    }

    public void unsetVersioningService() {
        this.server.unsetVersioningService();
    }

    public VersioningService getVersioningService() {
        return this.server.getVersioningService();
    }
}

