/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: JNotification.java 12499 2008-01-08 13:51:19Z fornacif $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.jmbeans;

import javax.management.Notification;

public class JNotification extends Notification {
    /**
     * Adapt source type to JSR77 specification
     */
    protected String source = null;

    public final static String startingType = "j2ee.state.starting";
    public final static String runningType = "j2ee.state.running";
    protected final static String stoppingType = "j2ee.state.stopping";
    protected final static String stoppedType = "j2ee.state.stopped";
    protected final static String failedType = "j2ee.state.failed";
    
    /**
     * emitted if a server failure detected
     */
    public final static String serverFail = "jonas.management.fail";

    public JNotification(String type, Object source, long sequenceNumber) {
        super(type, source, sequenceNumber);
        // TODO Auto-generated constructor stub
        source = source.toString();
    }
    public JNotification(String type, Object source, long sequenceNumber, long timeStamp) {
        super(type, source, sequenceNumber, timeStamp);
        // TODO Auto-generated constructor stub
    }
    public JNotification(String type, Object source, long sequenceNumber, long timeStamp, String message) {
        super(type, source, sequenceNumber, timeStamp, message);
        // TODO Auto-generated constructor stub
    }
    public JNotification(String type, Object source, long sequenceNumber, String message) {
        super(type, source, sequenceNumber, message);
        // TODO Auto-generated constructor stub
    }
}
