/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: OsgiServiceListener.java 13980 2008-05-05 14:49:55Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.jmbeans;

import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

/**
 * Treats OSGI ServiceEvents allowing to detect service state change.
 * @author Adriana.Danes@bull.net
 */
public class OsgiServiceListener implements ServiceListener {

    private ServiceManager serviceManager = null;

    /**
     * Create Osgi Event Listener.
     * @param serviceManager
     */
    public OsgiServiceListener(final ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    /**
     * Track events concerning JOnAS services.
     * @param e received ServiceEvent
     */
    public void serviceChanged(final ServiceEvent e) {
        ServiceReference ref = e.getServiceReference();
        String serviceName = OsgiServicesUtil.jonasService(ref);
        if (serviceName == null) {
            return;
        }
        Object state = null;
        switch (e.getType()) {
            case ServiceEvent.REGISTERED:
                serviceManager.setServiceState(serviceName, ServiceState.RUNNING);
                break;
            case ServiceEvent.MODIFIED:
                // TODO
                break;
            case ServiceEvent.UNREGISTERING:
                serviceManager.setServiceState(serviceName, ServiceState.STOPPED);
                break;
        }

    }


}
