/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServiceName.java 14025 2008-05-16 09:16:16Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jonas.lib.jmbeans;

public enum ServiceName {
    REGISTRY ("registry"),
    JMX ("jmx"),
    SECURITY ("security"),
    DB ("db"),
    MAIL ("mail"),
    WM ("wm"),
    WC ("wc"),
    DBM ("dbm"),
    RESOURCE ("resource"),
    CMI ("cmi"),
    HA ("ha"),
    VERSIIONING ("versioning"),
    EJB2 ("ejb2"),
    EJB3 ("ejb3"),
    WS ("ws"),
    WEB ("web"),
    EAR ("ear"),
    DEPMONITOR ("depmonitor"),
    DISCOVERY ("discovery");

    /**
     * Service name.
     */
    private String name = null;

    /**
     * Private constructor.
     * @param name the given service name
     */
    private ServiceName(final String name) {
        this.name = name;
    }

    /**
     * Returns the service name.
     * @return the service name
     */
    public String getName(){
        return name;
    }
}
