/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServiceState.java 13980 2008-05-05 14:49:55Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.jmbeans;

/**
 * Enumeration listing all possible states for a JOnAS Service.
 * @author Adriana Danes
 */
public enum ServiceState {

    /**
     * STARTING state.
     */
    STARTING ("service.state.starting"),

    /**
     * RUNNING state.
     */
    RUNNING ("service.state.running"),

    /**
     * STOPPING state.
     */
    STOPPING ("service.state.stopping"),

    /**
     * STOPPED state.
     */
    STOPPED ("service.state.stopped"),

    /**
    * FAILED state.
    */
    FAILED ("service.state.failed");


    /**
     * State name.
     */
    private String name = null;

    /**
     * Private constructor.
     * @param name the given state name
     */
    private ServiceState(final String name) {
        this.name = name;
    }

    /**
     * Returns the state name.
     * @return the state name
     */
    public String getName(){
        return name;
    }
}
