/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 2007-2008 Bull S.A.S.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: J2EEServerMBean.java 15621 2008-10-21 10:02:30Z loverad $
 * --------------------------------------------------------------------------
 */

package org.ow2.jonas.lib.jmbeans;

import java.util.List;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;

import org.apache.commons.modeler.BaseModelMBean;
import org.ow2.jonas.lib.management.javaee.J2EEServerState;

/**
 * J2EEServer MBean implementation.
 * @author Adriana.Danes@bull.net
 */
public class J2EEServerMBean extends BaseModelMBean {

    public J2EEServerMBean() throws MBeanException, RuntimeOperationsException {
        super();
    }

    /**
     * Implement the state attribute.
     * @return the current server's state
     * @throws InstanceNotFoundException
     * @throws RuntimeOperationsException
     * @throws MBeanException
     * @throws InvalidTargetObjectTypeException
     */
    public String getState() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        J2EEServerState state =  ((J2EEServer) getManagedResource()).getState();
        return state.getName();
    }


    /**
     * Implement resources attribute.
     * @return the list of J2EEResource names in the current server
     * @throws InstanceNotFoundException
     * @throws RuntimeOperationsException
     * @throws MBeanException
     * @throws InvalidTargetObjectTypeException
     */
    public String[] getResources() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        List<String> resourceList = ((J2EEServer) getManagedResource()).getResources();
        String[] result = new String[resourceList.size()];
        return resourceList.toArray(result);
    }

    /**
     * Implement services attribute.
     * @return
     * @throws InstanceNotFoundException
     * @throws RuntimeOperationsException
     * @throws MBeanException
     * @throws InvalidTargetObjectTypeException
     */
    public String[] getServices() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        List<String> services = ((J2EEServer) getManagedResource()).getServices();
        String[] result = new String[services.size()];
        for (int i = 0; i < services.size(); i++) {
            result[i] = services.get(i);
        }
        return result;
    }

    /**
     * Implement deployedObjects attribute cf. to JSR77 requirements.
     * @return Array of OBJECT_NAMEs corresponding to all the deployed modules and apps.
     * @throws InstanceNotFoundException
     * @throws RuntimeOperationsException
     * @throws MBeanException
     * @throws InvalidTargetObjectTypeException
     */
    public String[] getDeployedObjects() throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        List<String> deployedObjects = ((J2EEServer) getManagedResource()).getDeployedObjects();
        String[] result = new String[deployedObjects.size()];
        for (int i = 0; i < deployedObjects.size(); i++) {
            result[i] = deployedObjects.get(i);
        }
        return result;
    }

    /**
     * Return the state of a given service.
     * @param service name
     * @return The service state
     * @throws InstanceNotFoundException
     * @throws RuntimeOperationsException
     * @throws MBeanException
     * @throws InvalidTargetObjectTypeException
     * @throws InvalidTargetObjectTypeExceptio
     */
    public String getServiceState(final String service) throws InstanceNotFoundException, RuntimeOperationsException, MBeanException, InvalidTargetObjectTypeException {
        return ((J2EEServer) getManagedResource()).getServiceState(service);
    }
}
