/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.jmbeans;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.ow2.jonas.Version;
import org.ow2.jonas.configuration.ConfigurationManager;
import org.ow2.jonas.ejb3.IEasyBeansService;
import org.ow2.jonas.generators.wsgen.wrapper.WsGenWrapper;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.jmbeans.monitoring.MemoryMonitoring;
import org.ow2.jonas.lib.management.javaee.J2EEDeployedObject;
import org.ow2.jonas.lib.management.javaee.J2EEManagedObject;
import org.ow2.jonas.lib.management.javaee.J2EEResource;
import org.ow2.jonas.lib.management.javaee.J2EEServerState;
import org.ow2.jonas.lib.timer.TimerManager;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.management.ServiceManager;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEServer
extends J2EEManagedObject
implements J2EEServerService,
NotificationListener,
MBeanRegistration {
    private Log logger = LogFactory.getLog(J2EEServer.class);
    private long sequenceNumber = 0L;
    private MBeanServer mbeanServer = null;
    private J2EEServerState serverState = null;
    private long startTime;
    private String serverVendor = null;
    private String serverVersion = null;
    private String jonasBase = null;
    private String protocols = null;
    private String versions = null;
    private ServerProperties serverProperties = null;
    private MemoryMonitoring monitor = null;
    private IDeployerManager deployerManager = null;
    private IArchiveManager archiveManager = null;
    private ConfigurationManager configManager = null;
    private ArrayList<String> javaVMs = null;
    private ArrayList<String> resources = null;
    private ArrayList<String> deployedObjects = null;
    private VersioningService versioningService;
    private RegistryService registryService = null;
    private IEasyBeansService easyBeansService;
    private static final String JONAS_BOOTSTRAP = "jonas.bootstrap";
    private static final String JONAS_START_DATE = "jonas.start.date";
    private String[] eventTypes;
    private ArrayList<String> repositoryDirs = null;
    private ServiceManager serviceManager;

    public J2EEServer() {
        this.setStateManageable(true);
        this.setStatisticsProvider(false);
        this.setEventProvider(true);
        if (this.isEventProvider()) {
            this.eventTypes = new String[J2EEServerState.values().length];
            for (J2EEServerState state : J2EEServerState.values()) {
                this.eventTypes[state.ordinal()] = state.getName();
            }
        }
        if (this.isStateManageable()) {
            Date d = new Date();
            this.startTime = d.getTime();
        }
        this.serverState = J2EEServerState.INITIAL;
        this.resources = new ArrayList();
        this.deployedObjects = new ArrayList();
        this.monitor = new MemoryMonitoring();
        this.javaVMs = new ArrayList();
    }

    public void startJ2EEServer() throws Exception {
        this.versions = "Versions";
        this.serverVendor = "OW2 (former ObjectWeb)";
        this.serverVersion = Version.getNumber();
        this.jonasBase = this.getJonasBase();
        this.setTimerManager(TimerManager.getInstance());
        this.setActivated(true);
        this.initRepositoryDirs();
        this.createProtocols();
    }

    public String[] getEventTypes() {
        return this.eventTypes;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getServerVendor() {
        return this.serverVendor;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public String getServerName() {
        return this.serverProperties.getServerName();
    }

    public String getJonasBase() {
        return this.serverProperties.getValue("jonas.base");
    }

    public String getJonasRoot() {
        return this.serverProperties.getValue("jonas.root");
    }

    public String getProtocols() {
        return this.protocols;
    }

    public String getVersions() {
        return this.versions;
    }

    public boolean isActivated() {
        return this.monitor.getActivated();
    }

    private void setActivated(boolean activated) {
        this.monitor.setActivated(activated);
    }

    public long getCurrentUsedMemory() {
        return this.monitor.usedMemory();
    }

    public long getCurrentTotalMemory() {
        return this.monitor.totalMemory();
    }

    public int getRange() {
        return this.monitor.getRange();
    }

    public void setRange(int range) {
        this.monitor.setRange(range);
    }

    public int getSizeTableMeasures() {
        return this.monitor.getSizeTableMeasures();
    }

    public void setSizeTableMeasures(int sizeTableMeasures) {
        this.monitor.setSizeTableMeasures(sizeTableMeasures);
    }

    public Long[] getTableMeasures() {
        return this.monitor.getTableMeasures();
    }

    public List<String> getResources() {
        return this.resources;
    }

    public List<String> getDeployedObjects() {
        return this.deployedObjects;
    }

    public String getDomainName() {
        return this.serverProperties.getDomainName();
    }

    public String[] getJavaVMs() {
        String[] result = new String[this.javaVMs.size()];
        int i = 0;
        for (String name : this.javaVMs) {
            result[i++] = name;
        }
        return result;
    }

    public void addJavaVM(String objectName) {
        this.javaVMs.add(objectName);
    }

    public void bindVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unbindVersioningService() {
        this.versioningService = null;
    }

    public void start() throws Exception {
        if (this.serverState.equals((Object)J2EEServerState.STOPPED) || this.serverState.equals((Object)J2EEServerState.FAILED)) {
            this.setStartDate();
            if (this.serviceManager.getOptionalServices().size() > 0) {
                this.setStarting();
                this.serviceManager.startServices();
            } else {
                this.setRunning();
            }
        } else {
            throw new IllegalStateException("The start() operation can be invoked only when the server is in STOPPED or FAILED state");
        }
    }

    public void startRecursive() throws Exception {
        try {
            this.start();
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("The startRecursive() operation can be invoked only when the server is in STOPPED or FAILED state");
        }
    }

    public void stop() throws Exception {
        if (this.serverState.equals((Object)J2EEServerState.RUNNING) || this.serverState.equals((Object)J2EEServerState.STARTING) || this.serverState.equals((Object)J2EEServerState.FAILED)) {
            if (this.serviceManager.getOptionalServices().size() > 0) {
                this.setStopping();
                this.serviceManager.stopServices();
            } else {
                this.setStopped();
            }
        } else {
            throw new IllegalStateException("The stop() operation can be invoked only when the server is in RUNNING, STARTING or FAILED state");
        }
    }

    public void halt() throws Exception {
        this.configManager.haltServer();
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName causeOn = ((MBeanServerNotification)notification).getMBeanName();
            String type = causeOn.getKeyProperty("j2eeType");
            if (J2EEResource.isJ2eeResourceType((String)type)) {
                this.handleResourceNotification(causeOn, notification.getType());
            }
            if (J2EEDeployedObject.isJ2EEDeployedObjectType((String)type)) {
                this.handleDeployedNotification(causeOn, notification.getType());
            }
        }
    }

    private void handleResourceNotification(ObjectName resourceOn, String notificationType) {
        if (notificationType.equals("JMX.mbean.registered")) {
            this.addResource(resourceOn.toString());
        } else if (notificationType.equals("JMX.mbean.unregistered")) {
            this.removeResource(resourceOn.toString());
        }
    }

    private void handleDeployedNotification(ObjectName resourceOn, String notificationType) {
        if (notificationType.equals("JMX.mbean.registered")) {
            this.addDeployedObject(resourceOn.toString());
        } else if (notificationType.equals("JMX.mbean.unregistered")) {
            this.removeDeployedObject(resourceOn.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(String name) {
        ArrayList<String> arrayList = this.resources;
        synchronized (arrayList) {
            if (!this.resources.contains(name)) {
                this.resources.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeployedObject(String name) {
        ArrayList<String> arrayList = this.deployedObjects;
        synchronized (arrayList) {
            if (!this.deployedObjects.contains(name)) {
                this.deployedObjects.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeResource(String name) {
        ArrayList<String> arrayList = this.resources;
        synchronized (arrayList) {
            int index = this.resources.indexOf(name);
            if (index > -1) {
                this.resources.remove(index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeployedObject(String name) {
        ArrayList<String> arrayList = this.deployedObjects;
        synchronized (arrayList) {
            int index = this.deployedObjects.indexOf(name);
            if (index > -1) {
                this.deployedObjects.remove(index);
            }
        }
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            return;
        }
        try {
            ObjectName on = ObjectName.getInstance("JMImplementation:type=MBeanServerDelegate");
            this.mbeanServer.addNotificationListener(on, this, null, null);
        }
        catch (JMException me) {
            me.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        if (Boolean.getBoolean(JONAS_BOOTSTRAP)) {
            this.setStopped();
        } else if (this.serviceManager.getOptionalServices().size() > 0) {
            this.setStarting();
        } else {
            this.setRunning();
        }
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbeanServer = server;
        if (name == null) {
            return ObjectName.getInstance(this.getObjectName());
        }
        return name;
    }

    private void info(String message) {
        this.logger.info((Object)"JOnAS server ''{0}'' {1}", new Object[]{this.getServerName(), message});
    }

    public void setStarting() {
        this.serverState = J2EEServerState.STARTING;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("STARTING");
    }

    public void setRunning() {
        this.serverState = J2EEServerState.RUNNING;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("RUNNING");
        this.registerEasyBeansEmbeddedService();
    }

    public void setStopping() {
        this.serverState = J2EEServerState.STOPPING;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("STOPPING");
    }

    public void setStopped() {
        this.serverState = J2EEServerState.STOPPED;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("STOPPED");
    }

    public void setFailed() {
        this.serverState = J2EEServerState.FAILED;
        Notification notif = new Notification(this.serverState.getName(), this.getObjectName(), this.sequenceNumber++);
        this.sendNotification(notif);
        this.info("FAILED");
    }

    public J2EEServerState getState() {
        return this.serverState;
    }

    public boolean isStarting() {
        return this.serverState.equals((Object)J2EEServerState.STARTING);
    }

    public boolean isRunning() {
        return this.serverState.equals((Object)J2EEServerState.RUNNING);
    }

    public boolean isFailed() {
        return this.serverState.equals((Object)J2EEServerState.FAILED);
    }

    public boolean isStopping() {
        return this.serverState.equals((Object)J2EEServerState.STOPPING);
    }

    public boolean isStopped() {
        return this.serverState.equals((Object)J2EEServerState.STOPPED);
    }

    public void setDeployerManager(IDeployerManager deployerManager) {
        this.deployerManager = deployerManager;
    }

    public void setArchiveManager(IArchiveManager archiveManager) {
        this.archiveManager = archiveManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void deploy(String fileName) {
        this.logger.debug((Object)"Deploying ", new Object[]{fileName});
        File f = new File(fileName);
        if (!f.isAbsolute()) {
            throw new RuntimeException("The given filename '" + fileName + "' is not an absolute file.");
        }
        final IDeployable deployable = this.getDeployable(fileName);
        IExecution<Void> exec = new IExecution<Void>(){

            public Void execute() throws RuntimeException {
                try {
                    J2EEServer.this.deployerManager.deploy(deployable);
                }
                catch (Exception e) {
                    J2EEServer.this.logger.error((Object)"Cannot deploy the deployable ", new Object[]{deployable, e});
                    throw new RuntimeException("Cannot deploy the deployable '" + deployable + "' : " + e.getMessage());
                }
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)exec);
        if (result.hasException()) {
            throw new RuntimeException(result.getException());
        }
    }

    public void undeploy(String fileName) {
        this.logger.debug((Object)"Undeploying ", new Object[]{fileName});
        final IDeployable deployable = this.getDeployable(fileName);
        IExecution<Void> exec = new IExecution<Void>(){

            public Void execute() throws RuntimeException {
                try {
                    J2EEServer.this.deployerManager.undeploy(deployable);
                    J2EEServer.this.runGC();
                }
                catch (Exception e) {
                    J2EEServer.this.logger.error((Object)"Cannot undeploy the deployable ", new Object[]{deployable, e});
                    throw new RuntimeException("Cannot undeploy the deployable '" + deployable + "' : " + e.getMessage());
                }
                return null;
            }
        };
        ExecutionResult result = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)exec);
        if (result.hasException()) {
            throw new RuntimeException(result.getException());
        }
    }

    protected IDeployable getDeployable(String fileName) {
        IDeployable deployable = null;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException("The file '" + fileName + "' is not present on the filesystem.");
        }
        IArchive archive = this.archiveManager.getArchive((Object)file);
        if (archive == null) {
            this.logger.error((Object)"No archive found for the invalid file ", new Object[]{file});
            throw new RuntimeException("No archive found for the invalid file '" + file + "'.");
        }
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
        }
        catch (DeployableHelperException e) {
            this.logger.error((Object)"Cannot get a deployable for the archive ", new Object[]{archive, e});
            throw new RuntimeException("Cannot get a deployable for the archive '" + archive + "' : " + e.getMessage());
        }
        return deployable;
    }

    public boolean isDeployed(String fileName) throws Exception {
        File file = new File(fileName);
        if (file.exists()) {
            try {
                return this.isDeployedFile(file.toURL());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return false;
    }

    public String getJvmInfos() {
        StringBuffer sb = new StringBuffer();
        sb.append("JVM used is ");
        sb.append(System.getProperty("java.version"));
        sb.append(" version of ");
        sb.append(System.getProperty("java.vm.name"));
        sb.append("-");
        sb.append(System.getProperty("java.vm.version"));
        sb.append("/");
        sb.append(System.getProperty("java.vendor"));
        sb.append(" vendor on ");
        sb.append(System.getProperty("os.name"));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        sb.append("/");
        sb.append(System.getProperty("os.arch"));
        sb.append(" OS.");
        return sb.toString();
    }

    public void runGC() throws RemoteException {
        Runtime.getRuntime().gc();
    }

    public Properties getConfigFileEnv() {
        return this.serverProperties.getConfigFileEnv();
    }

    public void setConfigManager(ConfigurationManager configManager) {
        this.configManager = configManager;
    }

    public TimerManager getTimerManager() {
        return this.monitor.getTimerManager();
    }

    public void setTimerManager(TimerManager timerManager) {
        this.monitor.setTimerManager(timerManager);
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public void setEasyBeansService(IEasyBeansService easyBeansService) {
        this.easyBeansService = easyBeansService;
    }

    public void initRepositoryDirs() {
        this.repositoryDirs = new ArrayList();
        String deployDir = this.getJonasBase() + File.separator + "deploy";
        this.repositoryDirs.add(deployDir);
    }

    public void setDirectories(String dirs) {
        ArrayList<String> additionalDirectories = this.convertToList(dirs);
        Iterator<String> i$ = additionalDirectories.iterator();
        while (i$.hasNext()) {
            String dir;
            String dirName = dir = i$.next();
            File tmpFile = new File(dir);
            if (!tmpFile.isAbsolute()) {
                dirName = this.jonasBase + File.separator + dir;
                tmpFile = new File(dirName);
            }
            if (!tmpFile.exists()) continue;
            this.repositoryDirs.add(dirName);
        }
    }

    private ArrayList<String> convertToList(String value) {
        String[] values = value.split(",");
        ArrayList<String> injection = new ArrayList<String>();
        if (values.length != 1 || !"".equals(values[0])) {
            for (int i = 0; i < values.length; ++i) {
                String part = values[i];
                injection.add(part.trim());
            }
        }
        return injection;
    }

    private ArrayList<URL> getInstalledFiles() throws MalformedURLException, IOException {
        ArrayList<URL> al = this.getInstalledWars();
        ArrayList<URL> al1 = this.getInstalledJars();
        for (URL url : al1) {
            al.add(url);
        }
        al1 = this.getInstalledRars();
        for (URL url : al1) {
            al.add(url);
        }
        al1 = this.getInstalledEars();
        for (URL url : al1) {
            al.add(url);
        }
        return al;
    }

    private ArrayList<URL> getInstalledJars() throws MalformedURLException, IOException {
        ArrayList<URL> al = new ArrayList<URL>();
        ArrayList al1 = null;
        for (String dir : this.repositoryDirs) {
            al1 = JModule.getInstalledFileInDir((String)dir, (String)"jar");
            for (URL url : al1) {
                al.add(url);
            }
        }
        return al;
    }

    private ArrayList<URL> getInstalledWars() throws MalformedURLException, IOException {
        ArrayList<URL> al = new ArrayList<URL>();
        String extension = "war";
        ArrayList al1 = null;
        for (String dir : this.repositoryDirs) {
            al1 = JModule.getInstalledFileInDir((String)dir, (String)extension);
            for (URL url : al1) {
                al.add(url);
            }
        }
        return al;
    }

    private ArrayList<URL> getInstalledRars() throws MalformedURLException, IOException {
        ArrayList<URL> al = new ArrayList<URL>();
        String extension = "rar";
        ArrayList al1 = null;
        for (String dir : this.repositoryDirs) {
            al1 = JModule.getInstalledFileInDir((String)dir, (String)extension);
            for (URL url : al1) {
                al.add(url);
            }
        }
        return al;
    }

    private ArrayList<URL> getInstalledEars() throws MalformedURLException, IOException {
        ArrayList<URL> al = new ArrayList<URL>();
        String extension = "ear";
        ArrayList al1 = null;
        for (String dir : this.repositoryDirs) {
            al1 = JModule.getInstalledFileInDir((String)dir, (String)extension);
            for (URL url : al1) {
                al.add(url);
            }
        }
        return al;
    }

    private ArrayList<URL> getDeplyableFiles() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledFiles();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private ArrayList<URL> getDeplyableJars() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledJars();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private ArrayList<URL> getDeplyableWars() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledWars();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private ArrayList<URL> getDeplyableEars() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledEars();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private ArrayList<URL> getDeplyableRars() throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        ArrayList<URL> installedUrls = this.getInstalledRars();
        ArrayList<URL> deployableUrls = new ArrayList<URL>();
        for (URL installed : installedUrls) {
            if (this.isDeployedFile(installed)) continue;
            deployableUrls.add(installed);
        }
        return deployableUrls;
    }

    private boolean isDeployedWar(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("WebModule")) continue;
            try {
                URL url = (URL)this.mbeanServer.getAttribute(on, "warURL");
                if (!fileUrl.equals(url)) continue;
                return true;
            }
            catch (AttributeNotFoundException e) {
            }
        }
        return false;
    }

    private boolean isDeployedJar(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        for (String deployed : this.deployedObjects) {
            URL url;
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("EJBModule") || !fileUrl.equals(url = (URL)this.mbeanServer.getAttribute(on, "url"))) continue;
            return true;
        }
        return false;
    }

    private boolean isDeployedRar(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        for (String deployed : this.deployedObjects) {
            URL url;
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("ResourceAdapterModule") || !fileUrl.equals(url = (URL)this.mbeanServer.getAttribute(on, "rarURL"))) continue;
            return true;
        }
        return false;
    }

    private boolean isDeployedEar(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        for (String deployed : this.deployedObjects) {
            URL url;
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("J2EEApplication") || !fileUrl.equals(url = (URL)this.mbeanServer.getAttribute(on, "earUrl"))) continue;
            return true;
        }
        return false;
    }

    private boolean isDeployedFile(URL fileUrl) throws NullPointerException, MalformedObjectNameException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.isDeployedJar(fileUrl)) {
            return true;
        }
        if (this.isDeployedWar(fileUrl)) {
            return true;
        }
        if (this.isDeployedRar(fileUrl)) {
            return true;
        }
        return this.isDeployedEar(fileUrl);
    }

    public ArrayList<String> getDeployableFiles() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableFiles();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployableJars() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableJars();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployableEars() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableEars();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployableWars() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableWars();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployableRars() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ArrayList<URL> deployableUrls = this.getDeplyableRars();
            for (URL url : deployableUrls) {
                result.add(this.extractPath(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getDeployedWars() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            String j2eeApplication = on.getKeyProperty("J2EEApplication");
            boolean inEar = true;
            if ("none".equals(j2eeApplication)) {
                inEar = false;
            }
            if (!j2eeType.equals("WebModule") || inEar) continue;
            try {
                URL url = (URL)this.mbeanServer.getAttribute(on, "warURL");
                result.add(this.extractPath(url));
            }
            catch (AttributeNotFoundException e) {}
        }
        return result;
    }

    public ArrayList<String> getDeployedJars() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            String j2eeApplication = on.getKeyProperty("J2EEApplication");
            boolean inEar = true;
            if ("none".equals(j2eeApplication)) {
                inEar = false;
            }
            if (!j2eeType.equals("EJBModule") || inEar) continue;
            URL url = (URL)this.mbeanServer.getAttribute(on, "url");
            result.add(this.extractPath(url));
        }
        return result;
    }

    public ArrayList<String> getDeployedRars() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            String j2eeApplication = on.getKeyProperty("J2EEApplication");
            boolean inEar = true;
            if ("none".equals(j2eeApplication)) {
                inEar = false;
            }
            if (!j2eeType.equals("ResourceAdapterModule") || inEar) continue;
            URL url = (URL)this.mbeanServer.getAttribute(on, "rarURL");
            result.add(this.extractPath(url));
        }
        return result;
    }

    public ArrayList<String> getDeployedEars() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        for (String deployed : this.deployedObjects) {
            ObjectName on = ObjectName.getInstance(deployed);
            String j2eeType = on.getKeyProperty("j2eeType");
            if (!j2eeType.equals("J2EEApplication")) continue;
            URL url = (URL)this.mbeanServer.getAttribute(on, "earUrl");
            result.add(this.extractPath(url));
        }
        return result;
    }

    public ArrayList<String> getDeployedFiles() throws Exception {
        ArrayList<String> result = this.getDeployedEars();
        ArrayList<String> resultNext = this.getDeployedWars();
        for (String file : resultNext) {
            result.add(file);
        }
        resultNext = this.getDeployedJars();
        for (String file : resultNext) {
            result.add(file);
        }
        resultNext = this.getDeployedRars();
        for (String file : resultNext) {
            result.add(file);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String sendFile(byte[] fileContent, String fileName, boolean replaceExisting) throws Exception {
        File directoryUploadedFile;
        block9: {
            directoryUploadedFile = null;
            FileOutputStream fos = null;
            try {
                String dir = this.jonasBase + File.separator + "deploy";
                if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
                    File tempFile = File.createTempFile("jonas_renameUpload", ".tmp");
                    tempFile.deleteOnExit();
                    FileOutputStream tempFos = new FileOutputStream(tempFile);
                    tempFos.write(fileContent);
                    tempFos.close();
                    String versionID = this.versioningService.getVersionID(tempFile);
                    tempFile.delete();
                    if (versionID != null && !fileName.contains(versionID)) {
                        int extensionStarts = fileName.length() - 4;
                        fileName = fileName.substring(0, extensionStarts) + versionID + fileName.substring(extensionStarts);
                    }
                }
                if ((directoryUploadedFile = new File(dir, fileName)).exists() && !replaceExisting) {
                    throw new Exception("File '" + directoryUploadedFile + "' already exists on the server.");
                }
                fos = new FileOutputStream(directoryUploadedFile);
                fos.write(fileContent);
                if (fos == null) break block9;
            }
            catch (Throwable throwable) {
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.logger.debug((Object)"Cannot close the output stream", new Object[]{ioe});
                }
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (IOException ioe) {
                this.logger.debug((Object)"Cannot close the output stream", new Object[]{ioe});
            }
        }
        if (directoryUploadedFile == null) return "error, no uploaded file";
        this.logger.info((Object)("sendFile return directoryUploadedFile= " + directoryUploadedFile.getPath()), new Object[0]);
        return directoryUploadedFile.getPath();
    }

    public String distribute(String fileName, byte[] fileContent) throws Exception {
        this.logger.info((Object)"Distribute file to the local filesystem with the name = ''{0}''.", new Object[]{fileName});
        String path = this.sendFile(fileContent, fileName, true);
        return path;
    }

    public boolean removeModuleFile(String fileName) throws Exception {
        boolean existFile = false;
        File searchedFile = new File(fileName);
        String dir = null;
        if (!searchedFile.exists()) {
            dir = this.jonasBase + File.separator + "deploy";
            searchedFile = new File(dir, fileName);
        }
        if (searchedFile.exists()) {
            existFile = true;
        } else {
            dir = this.getFolderDir(fileName);
            searchedFile = new File(dir, fileName);
            if (searchedFile.exists()) {
                existFile = true;
            }
        }
        if (existFile) {
            return searchedFile.delete();
        }
        throw new Exception("File '" + searchedFile + "' was not found on the JOnAS server. Cannot remove it");
    }

    private String getFolderDir(String fileName) throws Exception {
        String dir = null;
        if (fileName.toLowerCase().endsWith(".jar")) {
            dir = this.jonasBase + File.separator + "ejbjars";
        } else if (fileName.toLowerCase().endsWith(".war")) {
            dir = this.jonasBase + File.separator + "webapps";
        } else if (fileName.toLowerCase().endsWith(".ear")) {
            dir = this.jonasBase + File.separator + "apps";
        } else if (fileName.toLowerCase().endsWith(".rar")) {
            dir = this.jonasBase + File.separator + "rars";
        } else {
            throw new Exception("Invalid extension for the file '" + fileName + "'. Valid are .jar, .war, .ear, .rar");
        }
        return dir;
    }

    public String wsgenLocalFile(String pathname, Boolean unpacked) {
        try {
            WsGenWrapper wsgen = new WsGenWrapper();
            String outputFilename = wsgen.callWsGenExecute(pathname, unpacked);
            boolean modified = wsgen.callWsGenIsInputModifed();
            if (modified) {
                return outputFilename;
            }
            return null;
        }
        catch (Exception e) {
            this.logger.warn((Object)"Cannot generate web services for this component {0}", new Object[]{pathname, e});
            return null;
        }
    }

    private String extractPath(URL url) {
        String path;
        try {
            File file = new File(url.toURI());
            path = file.toURL().getFile();
        }
        catch (Exception e) {
            path = url.getPath();
        }
        return path;
    }

    private void createProtocols() {
        String protocols = "";
        String prefix = "rmi/";
        List protocolList = this.registryService.getActiveProtocolNames();
        for (String protocolName : protocolList) {
            if (protocols == "") {
                protocols = prefix + protocolName;
                continue;
            }
            protocols = protocols + "," + prefix + protocolName;
        }
        this.protocols = protocols;
    }

    public List<String> getServices() {
        return this.serviceManager.getAllServices();
    }

    public String getServiceDescription(String service) {
        return this.serviceManager.getServiceDescription(service);
    }

    public String getServiceState(String service) {
        return this.serviceManager.getServiceState(service);
    }

    public void startService(String service) throws Exception {
        this.serviceManager.startService(service);
    }

    public void stopService(String service) throws Exception {
        this.serviceManager.stopService(service);
    }

    private void registerEasyBeansEmbeddedService() {
        if (this.easyBeansService != null) {
            this.easyBeansService.registerEmbeddedService();
        }
    }

    private void setStartDate() {
        System.setProperty(JONAS_START_DATE, Long.toString(System.currentTimeMillis()));
    }

    private String getServerStartupTime() {
        long startupTime;
        String startDate = System.getProperty(JONAS_START_DATE);
        System.clearProperty(JONAS_START_DATE);
        if (startDate != null && (startupTime = System.currentTimeMillis() - Long.parseLong(startDate)) > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("m'm'ss's'");
            return sdf.format(startupTime);
        }
        return null;
    }

    public String getThreadStackDump() {
        StringBuilder builder = new StringBuilder();
        Map<Thread, StackTraceElement[]> st = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : st.entrySet()) {
            StackTraceElement[] el = e.getValue();
            Thread t = e.getKey();
            builder.append("\"").append(t.getName()).append("\"");
            builder.append(" id=").append(t.getId());
            builder.append(", ");
            builder.append(" prio=").append(t.getPriority());
            builder.append(", ");
            if (t.isAlive()) {
                builder.append("alive, ");
            }
            if (t.isInterrupted()) {
                builder.append("interrupted, ");
            }
            builder.append((Object)((Object)t.getState()) + ", ");
            if (t.isDaemon()) {
                builder.append("daemon, ");
            }
            builder.append("\n");
            for (StackTraceElement line : el) {
                builder.append("\t").append(line).append("\n");
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public void printThreadStackDump(String filename) {
        File f = null;
        String stackDump = null;
        PrintWriter printWriter = null;
        try {
            f = new File(filename);
            try {
                FileWriter fileWriter = new FileWriter(f);
                BufferedWriter bufWriter = new BufferedWriter(fileWriter);
                printWriter = new PrintWriter((Writer)bufWriter, true);
            }
            catch (IOException ioe) {
                this.logger.warn((Object)("Could not prepare file \"" + filename + "\" for writing"), new Object[]{ioe});
            }
            try {
                stackDump = this.getThreadStackDump();
            }
            catch (Exception estack) {
                this.logger.warn((Object)"Error getting thread stack dump", new Object[]{estack});
            }
            printWriter.write(stackDump);
            if (printWriter.checkError()) {
                this.logger.warn((Object)("Could not write in file \"" + filename + "\""), new Object[0]);
            }
            printWriter.close();
        }
        catch (Exception efile) {
            this.logger.warn((Object)("Could not create file \"" + filename + "\""), new Object[]{efile});
        }
    }

    public void logThreadStackDump() {
        try {
            String stackDump = this.getThreadStackDump();
            this.logger.info((Object)stackDump, new Object[0]);
        }
        catch (Exception estack) {
            this.logger.warn((Object)"Error getting thread stack dump", new Object[]{estack});
        }
    }

    public TabularData getThreadStackDumpList() {
        String[] itemNames = new String[]{"id", "name", "priority", "is alive", "is interrupted", "state", "is daemon", "stackTrace"};
        Object[] itemValues = new String[itemNames.length];
        String[] itemDescriptions = new String[itemNames.length];
        OpenType[] itemTypes = new OpenType[itemNames.length];
        CompositeType threadPropertiesType = null;
        CompositeData[] compositeDataSupportTab = null;
        TabularType tabularType = null;
        TabularDataSupport tabularDataSupport = null;
        for (int i = 0; i < itemNames.length; ++i) {
            itemDescriptions[i] = "Thread" + itemNames[i];
            itemTypes[i] = SimpleType.STRING;
        }
        Map<Thread, StackTraceElement[]> st = Thread.getAllStackTraces();
        compositeDataSupportTab = new CompositeDataSupport[st.size()];
        int indice = 0;
        String stackTrace = "";
        for (Map.Entry<Thread, StackTraceElement[]> e : st.entrySet()) {
            StackTraceElement[] el = e.getValue();
            Thread t = e.getKey();
            itemValues[0] = Long.toString(t.getId());
            itemValues[1] = t.getName();
            itemValues[2] = Integer.toString(t.getPriority());
            itemValues[3] = t.isAlive() ? "true" : "false";
            itemValues[4] = t.isInterrupted() ? "true" : "false";
            itemValues[5] = t.getState().toString();
            itemValues[6] = t.isDaemon() ? "true" : "false";
            for (StackTraceElement line : el) {
                stackTrace = stackTrace + line + "\n";
            }
            itemValues[7] = stackTrace;
            stackTrace = "";
            try {
                threadPropertiesType = new CompositeType("threadProperty", "a thread property", itemNames, itemDescriptions, itemTypes);
                compositeDataSupportTab[indice] = new CompositeDataSupport(threadPropertiesType, itemNames, itemValues);
                ++indice;
            }
            catch (OpenDataException ex) {
                this.logger.warn((Object)"Could not create CompositeDataSupport using CompositeType \"threadPropertiesType\"", new Object[]{ex});
                return null;
            }
        }
        try {
            tabularType = new TabularType("threadProperties", "List of Thread properties", threadPropertiesType, itemNames);
            tabularDataSupport = new TabularDataSupport(tabularType, itemNames.length, 0.75f);
            tabularDataSupport.putAll(compositeDataSupportTab);
            return tabularDataSupport;
        }
        catch (OpenDataException ex2) {
            this.logger.warn((Object)"Could not create TabularDataSupport using TabularType \"threadProperties\"", new Object[]{ex2});
            return null;
        }
    }
}

