/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;

public class SingletonNamingManager
implements JNamingManager {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.naming");
    private ThreadLocal threadContext = new ThreadLocal();
    private InitialContext ictx = null;
    private static Context serverContext = null;
    private Hashtable myEnv = null;
    private Hashtable clBindings = new Hashtable();
    private static Context clientCtx = null;
    private static JNamingManager unique = null;
    private JComponentContextFactory factory = null;

    private SingletonNamingManager() throws NamingException {
        IExecution<InitialContext> ie = new IExecution<InitialContext>(){

            public InitialContext execute() throws Exception {
                return new InitialContext();
            }
        };
        ExecutionResult result = null;
        result = RunnableHelper.execute((ClassLoader)SingletonNamingManager.class.getClassLoader(), (IExecution)ie);
        if (result.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)("NamingManager: " + result.getException()));
            throw new NamingException("Cannot get InitialContext: " + result.getException());
        }
        this.ictx = (InitialContext)result.getResult();
        unique = this;
    }

    public static JNamingManager getInstance() throws NamingException {
        if (unique == null) {
            unique = new SingletonNamingManager();
        }
        return unique;
    }

    public void setJComponentContextFactory(JComponentContextFactory factory) {
        this.factory = factory;
    }

    public InitialContext getInitialContext() {
        return this.ictx;
    }

    public Context getComponentContext() throws NamingException {
        Context ctx = null;
        ctx = (Context)this.threadContext.get();
        if (ctx != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"return Context for ejb");
            }
            return ctx;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null && cl.getParent() != null && (ctx = (Context)this.clBindings.get(cl.getParent())) != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"return Context for webapp");
            }
            return ctx;
        }
        if (clientCtx != null && (ctx = clientCtx) != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"return Context for client");
            }
            return ctx;
        }
        if (ctx == null) {
            ctx = this.getServerContext();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"return default server Context");
            }
        }
        return ctx;
    }

    public Context setComponentContext(Context ctx) {
        Context ret = (Context)this.threadContext.get();
        this.threadContext.set(ctx);
        return ret;
    }

    public void resetComponentContext(Context ctx) {
        this.threadContext.set(ctx);
    }

    public void setComponentContext(Context ctx, ClassLoader cl) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("class loader = " + cl));
        }
        this.clBindings.put(cl, ctx);
    }

    public void setClientContainerComponentContext(Context ctx) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        clientCtx = ctx;
    }

    public Context getComponentContext(ClassLoader cl) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("class loader = " + cl));
        }
        return (Context)this.clBindings.get(cl);
    }

    public void unSetComponentContext(ClassLoader cl) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("class loader = " + cl));
        }
        this.clBindings.remove(cl);
    }

    public Hashtable getEnv() {
        return this.myEnv;
    }

    public Context getServerContext() {
        if (serverContext == null && this.factory != null) {
            try {
                serverContext = this.factory.createComponentContext("server");
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("cannot create serverContext:" + e));
            }
        }
        return serverContext;
    }
}

