/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.naming;

import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JComponentContextFactoryDelegate;

public final class SingletonComponentContextFactory
implements JComponentContextFactory {
    private static final String COMP_SUBCONTEXT = "comp";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.naming");
    private static JComponentContextFactory unique;
    private ArrayList<JComponentContextFactoryDelegate> delegates = new ArrayList();
    private static Context sharedCompContext;

    private SingletonComponentContextFactory() {
        sharedCompContext = new ComponentContext(COMP_SUBCONTEXT);
        unique = this;
    }

    public static synchronized JComponentContextFactory getInstance() throws NamingException {
        if (unique == null) {
            unique = new SingletonComponentContextFactory();
        }
        return unique;
    }

    public synchronized void addDelegate(JComponentContextFactoryDelegate extension) throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)("add :" + extension));
        this.delegates.add(extension);
        extension.modify(sharedCompContext);
    }

    public synchronized void removeDelegate(JComponentContextFactoryDelegate extension) throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)("extension:" + extension));
        this.delegates.remove(extension);
        extension.undo(sharedCompContext);
    }

    public synchronized Context createComponentContext(String id) throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)id);
        ComponentContext ctx = new ComponentContext(id);
        ComponentContext compCtx = (ComponentContext)ctx.createSubcontext(COMP_SUBCONTEXT);
        compCtx.addWrapped(sharedCompContext);
        return ctx;
    }

    static {
        sharedCompContext = null;
    }
}

