/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.naming;

import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.loader.OSGiClassLoader;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JComponentContextFactoryDelegate;

public final class SingletonComponentContextFactory
implements JComponentContextFactory {
    private static final String COMP_SUBCONTEXT = "comp";
    private static final String APP_SUBCONTEXT = "app";
    private static final String MODULE_SUBCONTEXT = "module";
    private static final String GLOBAL_SUBCONTEXT = "global";
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.naming");
    private static JComponentContextFactory unique;
    private ArrayList<JComponentContextFactoryDelegate> delegates = new ArrayList();
    private static Context sharedCompContext;
    private ComponentContext globalContext = null;

    private SingletonComponentContextFactory() throws NamingException {
        sharedCompContext = new ComponentContext(COMP_SUBCONTEXT);
        unique = this;
    }

    public static synchronized JComponentContextFactory getInstance() throws NamingException {
        if (unique == null) {
            unique = new SingletonComponentContextFactory();
        }
        return unique;
    }

    public synchronized void addDelegate(JComponentContextFactoryDelegate extension) throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)("add :" + extension));
        this.delegates.add(extension);
        extension.modify(sharedCompContext);
    }

    public synchronized void removeDelegate(JComponentContextFactoryDelegate extension) throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)("extension:" + extension));
        this.delegates.remove(extension);
        extension.undo(sharedCompContext);
    }

    public synchronized Context createComponentContext(String id) throws NamingException {
        return this.createComponentContext(id, null, null);
    }

    public synchronized Context createComponentContext(String id, Context moduleContext, Context appContext) throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)id);
        ComponentContext ctx = new ComponentContext(id);
        ComponentContext compCtx = (ComponentContext)ctx.createSubcontext(COMP_SUBCONTEXT);
        ctx.addBinding(GLOBAL_SUBCONTEXT, this.getGlobalContext());
        compCtx.addWrapped(sharedCompContext);
        Context moduleCtx = null;
        moduleCtx = moduleContext == null ? compCtx : moduleContext;
        ctx.addBinding(MODULE_SUBCONTEXT, moduleCtx);
        Context appCtx = null;
        appCtx = appContext == null ? moduleCtx : appContext;
        ctx.addBinding(APP_SUBCONTEXT, appCtx);
        return ctx;
    }

    protected synchronized Context getGlobalContext() {
        if (this.globalContext != null) {
            return this.globalContext;
        }
        this.globalContext = new ComponentContext(GLOBAL_SUBCONTEXT);
        IExecution<InitialContext> ie = new IExecution<InitialContext>(){

            public InitialContext execute() throws Exception {
                return new InitialContext();
            }
        };
        ExecutionResult result = null;
        result = RunnableHelper.execute((ClassLoader)new OSGiClassLoader(), (IExecution)ie);
        if (result.hasException()) {
            throw new IllegalStateException("Unable to get InitialContext", result.getException());
        }
        Context jndiContext = (Context)result.getResult();
        this.globalContext.addWrapped(jndiContext, true);
        return this.globalContext;
    }

    static {
        sharedCompContext = null;
    }
}

