/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;

public abstract class AbstractCellView
implements CellView,
Serializable {
    protected static GraphCellEditor cellEditor = new DefaultGraphCellEditor();
    protected JGraph graph = null;
    protected CellMapper mapper = null;
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList();
    protected AttributeMap attributes = new AttributeMap();
    protected AttributeMap allAttributes;

    public AbstractCellView(Object object, JGraph jGraph, CellMapper cellMapper) {
        this.cell = object;
        this.graph = jGraph;
        this.mapper = cellMapper;
        this.updateAllAttributes();
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public GraphModel getModel() {
        return this.graph.getModel();
    }

    public CellMapper getMapper() {
        return this.mapper;
    }

    public Object getCell() {
        return this.cell;
    }

    public void refresh(boolean bl) {
        boolean bl2;
        Object object;
        this.update();
        if (this.mapper != null && this.getModel() != null) {
            Object object2 = this.getModel().getParent(this.cell);
            if (this.graph.getGraphLayoutCache().isVisible(object2)) {
                object = this.mapper.getMapping(object2, bl);
                if (object != this.parent) {
                    this.removeFromParent();
                }
                this.parent = object;
            } else if (this.parent != null) {
                this.removeFromParent();
                this.parent = null;
            }
        }
        boolean bl3 = bl2 = !this.graph.getGraphLayoutCache().isOrdered();
        if (bl2) {
            this.childViews.clear();
        }
        object = this.getModel();
        int n = 0;
        while (n < object.getChildCount(this.cell)) {
            CellView cellView;
            Object object3 = object.getChild(this.cell, n);
            if (this.graph.getGraphLayoutCache().isVisible(object3) && (cellView = this.mapper.getMapping(object3, bl)) != null && !object.isPort(object3) && (!this.childViews.contains(cellView) || bl2)) {
                this.childViews.add(cellView);
            }
            ++n;
        }
    }

    public void update() {
        this.updateAllAttributes();
        this.childUpdated();
    }

    protected void updateAllAttributes() {
        this.allAttributes = this.getModel().getAttributes(this.cell);
        this.allAttributes = this.allAttributes != null ? (AttributeMap)this.allAttributes.clone() : this.getModel().createAttributes();
        this.allAttributes.putAll(this.attributes);
    }

    public void childUpdated() {
        if (this.parent != null) {
            this.parent.childUpdated();
        }
    }

    public CellView getParentView() {
        return this.parent;
    }

    public CellView[] getChildViews() {
        CellView[] cellViewArray = new CellView[this.childViews.size()];
        this.childViews.toArray(cellViewArray);
        return cellViewArray;
    }

    public static CellView[] getDescendantViews(CellView[] cellViewArray) {
        Object object;
        Stack<CellView> stack = new Stack<CellView>();
        int n = 0;
        while (n < cellViewArray.length) {
            stack.add(cellViewArray[n]);
            ++n;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!stack.isEmpty()) {
            object = (CellView)stack.pop();
            CellView[] cellViewArray2 = object.getChildViews();
            int n2 = 0;
            while (n2 < cellViewArray2.length) {
                stack.add(cellViewArray2[n2]);
                ++n2;
            }
            arrayList.add(object);
        }
        object = new CellView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public AttributeMap getAllAttributes() {
        return this.allAttributes;
    }

    public AttributeMap setAttributes(AttributeMap attributeMap) {
        AttributeMap attributeMap2 = this.attributes.applyMap(attributeMap);
        this.update();
        return attributeMap2;
    }

    public abstract Rectangle2D getBounds();

    public static Rectangle2D getBounds(CellView[] cellViewArray) {
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle2D rectangle2D = null;
            int n = 0;
            while (n < cellViewArray.length) {
                Rectangle2D rectangle2D2;
                if (cellViewArray[n] != null && (rectangle2D2 = cellViewArray[n].getBounds()) != null) {
                    if (rectangle2D == null) {
                        rectangle2D = cellViewArray[n].getAttributes().createRect(rectangle2D2);
                    } else {
                        Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
                    }
                }
                ++n;
            }
            return rectangle2D;
        }
        return null;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        if (rectangle2D2 == null) {
            rectangle2D2 = this.getAttributes().createRect();
        }
        Point2D point2D = this.getAttributes().createPoint(rectangle2D2.getX(), rectangle2D2.getY());
        Point2D point2D2 = this.getAttributes().createPoint(rectangle2D.getX(), rectangle2D.getY());
        Rectangle2D rectangle2D3 = this.getAttributes().createRect(rectangle2D);
        if (GraphConstants.isMoveable(this.getAttributes()) && !point2D2.equals(point2D)) {
            this.translate(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        } else {
            rectangle2D3.setFrame(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D.getWidth() - point2D2.getX() + point2D.getX(), rectangle2D.getHeight() - point2D2.getY() + point2D.getY());
        }
        double d = rectangle2D3.getWidth();
        double d2 = rectangle2D3.getHeight();
        double d3 = rectangle2D2.getWidth();
        double d4 = rectangle2D2.getHeight();
        if ((d != d3 || d2 != d4) && d3 > 0.0 && d4 > 0.0) {
            this.scale(d / d3, d2 / d4, point2D2);
        }
    }

    protected void translate(double d, double d2) {
        if (this.isLeaf()) {
            this.getAttributes().translate(d, d2);
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AbstractCellView)) continue;
                AbstractCellView abstractCellView = (AbstractCellView)e;
                abstractCellView.translate(d, d2);
            }
        }
    }

    protected void scale(double d, double d2, Point2D point2D) {
        if (this.isLeaf()) {
            this.getAttributes().scale(d, d2, point2D);
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                AbstractCellView abstractCellView;
                AttributeMap attributeMap;
                Object e = iterator.next();
                if (!(e instanceof AbstractCellView) || !GraphConstants.isSizeable(attributeMap = (abstractCellView = (AbstractCellView)e).getAttributes()) && !GraphConstants.isAutoSize(attributeMap)) continue;
                abstractCellView.scale(d, d2, point2D);
            }
        }
    }

    public boolean intersects(Graphics graphics, Rectangle2D rectangle2D) {
        if (this.isLeaf()) {
            Rectangle2D rectangle2D2 = this.getBounds();
            if (rectangle2D2 != null) {
                return rectangle2D2.intersects(rectangle2D);
            }
        } else {
            Iterator iterator = this.childViews.iterator();
            while (iterator.hasNext()) {
                if (!((CellView)iterator.next()).intersects(graphics, rectangle2D)) continue;
                return true;
            }
        }
        return false;
    }

    public Component getRendererComponent(JGraph jGraph, boolean bl, boolean bl2, boolean bl3) {
        CellViewRenderer cellViewRenderer = this.getRenderer();
        if (cellViewRenderer != null) {
            return cellViewRenderer.getRendererComponent(jGraph, this, bl, bl2, bl3);
        }
        return null;
    }

    public abstract CellViewRenderer getRenderer();

    public abstract CellHandle getHandle(GraphContext var1);

    public GraphCellEditor getEditor() {
        return cellEditor;
    }
}

